/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, AppEngine> appEngines;
    protected static Map<String, EngineInfo> appEngineInfosByName;
    protected static Map<String, EngineInfo> appEngineInfosByResourceUrl;
    protected static List<EngineInfo> appEngineInfos;

    public static synchronized void init() {
        if (!AppEngines.isInitialized()) {
            if (appEngines == null) {
                appEngines = new HashMap<String, AppEngine>();
            }
            ClassLoader classLoader = AppEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.app.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable.app.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                LOGGER.info("Initializing app engine using configuration '{}'", (Object)resource);
                AppEngines.initAppEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-app-context.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable-app-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                LOGGER.info("Initializing app engine using Spring configuration '{}'", (Object)resource);
                AppEngines.initAppEngineFromSpringResource(resource);
            }
            AppEngines.setInitialized(true);
        } else {
            LOGGER.info("App engines already initialized");
        }
    }

    protected static void initAppEngineFromSpringResource(URL resource) {
        try {
            Class springConfigurationHelperClass = ReflectUtil.loadClass((String)"org.flowable.app.spring.SpringAppConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildAppEngine", URL.class);
            AppEngine appEngine = (AppEngine)method.invoke(null, resource);
            String appEngineName = appEngine.getName();
            EngineInfo appEngineInfo = new EngineInfo(appEngineName, resource.toString(), null);
            appEngineInfosByName.put(appEngineName, appEngineInfo);
            appEngineInfosByResourceUrl.put(resource.toString(), appEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize app engine from spring configuration resource " + resource + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerAppEngine(AppEngine appEngine) {
        appEngines.put(appEngine.getName(), appEngine);
    }

    public static void unregister(AppEngine appEngine) {
        appEngines.remove(appEngine.getName());
    }

    private static EngineInfo initAppEngineFromResource(URL resourceUrl) {
        EngineInfo appEngineInfo = appEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (appEngineInfo != null) {
            appEngineInfos.remove(appEngineInfo);
            if (appEngineInfo.getException() == null) {
                String appEngineName = appEngineInfo.getName();
                appEngines.remove(appEngineName);
                appEngineInfosByName.remove(appEngineName);
            }
            appEngineInfosByResourceUrl.remove(appEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOGGER.info("initializing app engine for resource {}", (Object)resourceUrl);
            AppEngine appEngine = AppEngines.buildAppEngine(resourceUrl);
            String appEngineName = appEngine.getName();
            LOGGER.info("initialised app engine {}", (Object)appEngineName);
            appEngineInfo = new EngineInfo(appEngineName, resourceUrlString, null);
            appEngines.put(appEngineName, appEngine);
            appEngineInfosByName.put(appEngineName, appEngineInfo);
        }
        catch (Throwable e) {
            LOGGER.error("Exception while initializing app engine: {}", (Object)e.getMessage(), (Object)e);
            appEngineInfo = new EngineInfo(null, resourceUrlString, ExceptionUtils.getStackTrace((Throwable)e));
        }
        appEngineInfosByResourceUrl.put(resourceUrlString, appEngineInfo);
        appEngineInfos.add(appEngineInfo);
        return appEngineInfo;
    }

    protected static AppEngine buildAppEngine(URL resource) {
        AppEngine appEngine;
        block8: {
            InputStream inputStream = resource.openStream();
            try {
                AppEngineConfiguration appEngineConfiguration = AppEngineConfiguration.createAppEngineConfigurationFromInputStream(inputStream);
                appEngine = appEngineConfiguration.buildAppEngine();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FlowableException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return appEngine;
    }

    public static List<EngineInfo> getAppEngineInfos() {
        return appEngineInfos;
    }

    public static EngineInfo getAppEngineInfo(String appEngineName) {
        return appEngineInfosByName.get(appEngineName);
    }

    public static AppEngine getDefaultAppEngine() {
        return AppEngines.getAppEngine(NAME_DEFAULT);
    }

    public static AppEngine getAppEngine(String appEngineName) {
        if (!AppEngines.isInitialized()) {
            AppEngines.init();
        }
        return appEngines.get(appEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        LOGGER.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return AppEngines.initAppEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, AppEngine> getAppEngines() {
        return appEngines;
    }

    public static synchronized void destroy() {
        if (AppEngines.isInitialized()) {
            HashMap<String, AppEngine> engines = new HashMap<String, AppEngine>(appEngines);
            appEngines = new HashMap<String, AppEngine>();
            for (String appEngineName : engines.keySet()) {
                AppEngine appEngine = (AppEngine)engines.get(appEngineName);
                try {
                    appEngine.close();
                }
                catch (Exception e) {
                    LOGGER.error("exception while closing {}", (Object)(appEngineName == null ? "the default app engine" : "app engine " + appEngineName), (Object)e);
                }
            }
            appEngineInfosByName.clear();
            appEngineInfosByResourceUrl.clear();
            appEngineInfos.clear();
            AppEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        AppEngines.isInitialized = isInitialized;
    }

    static {
        appEngines = new HashMap<String, AppEngine>();
        appEngineInfosByName = new HashMap<String, EngineInfo>();
        appEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        appEngineInfos = new ArrayList<EngineInfo>();
    }
}

