/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntity;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntityImpl;
import org.flowable.app.engine.impl.persistence.entity.data.AbstractAppDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.AppDefinitionDataManager;
import org.flowable.app.engine.impl.repository.AppDefinitionQueryImpl;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;

public class MybatisAppDefinitionDataManager
extends AbstractAppDataManager<AppDefinitionEntity>
implements AppDefinitionDataManager {
    public MybatisAppDefinitionDataManager(AppEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public Class<? extends AppDefinitionEntity> getManagedEntityClass() {
        return AppDefinitionEntityImpl.class;
    }

    public AppDefinitionEntity create() {
        return new AppDefinitionEntityImpl();
    }

    @Override
    public AppDefinitionEntity findLatestAppDefinitionByKey(String appDefinitionKey) {
        return (AppDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestAppDefinitionByKey", (Object)appDefinitionKey);
    }

    @Override
    public AppDefinitionEntity findLatestAppDefinitionByKeyAndTenantId(String appDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("appDefinitionKey", appDefinitionKey);
        params.put("tenantId", tenantId);
        return (AppDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestAppDefinitionByKeyAndTenantId", params);
    }

    @Override
    public void deleteAppDefinitionsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteAppDefinitionsByDeploymentId", (Object)deploymentId, AppDefinitionEntityImpl.class);
    }

    @Override
    public AppDefinitionEntity findAppDefinitionByDeploymentAndKey(String deploymentId, String appDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("appDefinitionKey", appDefinitionKey);
        return (AppDefinitionEntity)this.getDbSqlSession().selectOne("selectAppDefinitionByDeploymentAndKey", parameters);
    }

    @Override
    public AppDefinitionEntity findAppDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String appDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("appDefinitionKey", appDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (AppDefinitionEntity)this.getDbSqlSession().selectOne("selectAppDefinitionByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public AppDefinitionEntity findAppDefinitionByKeyAndVersion(String appDefinitionKey, Integer appDefinitionVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appDefinitionKey", appDefinitionKey);
        params.put("appDefinitionVersion", appDefinitionVersion);
        List results = this.getDbSqlSession().selectList("selectAppDefinitionsByKeyAndVersion", params);
        if (results.size() == 1) {
            return (AppDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " app definitions with key = '" + appDefinitionKey + "' and version = '" + appDefinitionVersion + "'.");
        }
        return null;
    }

    @Override
    public AppDefinitionEntity findAppDefinitionByKeyAndVersionAndTenantId(String appDefinitionKey, Integer appDefinitionVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appDefinitionKey", appDefinitionKey);
        params.put("appDefinitionVersion", appDefinitionVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectAppDefinitionsByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (AppDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " app definitions with key = '" + appDefinitionKey + "' and version = '" + appDefinitionVersion + "'.");
        }
        return null;
    }

    @Override
    public void updateAppDefinitionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateAppDefinitionTenantIdForDeploymentId", params);
    }

    @Override
    public List<AppDefinition> findAppDefinitionsByQueryCriteria(AppDefinitionQueryImpl appDefinitionQuery) {
        return this.getDbSqlSession().selectList("selectAppDefinitionsByQueryCriteria", (ListQueryParameterObject)appDefinitionQuery);
    }

    @Override
    public long findAppDefinitionCountByQueryCriteria(AppDefinitionQueryImpl appDefinitionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectAppDefinitionCountByQueryCriteria", (Object)appDefinitionQuery);
    }
}

