/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.spring;

import java.util.Map;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AppEngineFactoryBean
implements FactoryBean<AppEngine>,
DisposableBean,
ApplicationContextAware {
    protected AppEngineConfiguration appEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected AppEngine appEngine;

    public void destroy() throws Exception {
        if (this.appEngine != null) {
            this.appEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public AppEngine getObject() throws Exception {
        this.configureExternallyManagedTransactions();
        if (this.appEngineConfiguration.getBeans() == null) {
            this.appEngineConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
        }
        this.appEngine = this.appEngineConfiguration.buildAppEngine();
        return this.appEngine;
    }

    protected void configureExternallyManagedTransactions() {
        SpringAppEngineConfiguration engineConfiguration;
        if (this.appEngineConfiguration instanceof SpringAppEngineConfiguration && (engineConfiguration = (SpringAppEngineConfiguration)this.appEngineConfiguration).getTransactionManager() != null) {
            this.appEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<AppEngine> getObjectType() {
        return AppEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public AppEngineConfiguration getAppEngineConfiguration() {
        return this.appEngineConfiguration;
    }

    public void setAppEngineConfiguration(AppEngineConfiguration appEngineConfiguration) {
        this.appEngineConfiguration = appEngineConfiguration;
    }
}

