/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.templating;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.finos.springbot.symphony.SymphonyException;
import org.finos.springbot.symphony.templating.FreemarkerWorkTemplater;
import org.finos.springbot.workflow.form.ButtonList;
import org.finos.springbot.workflow.response.Response;
import org.finos.springbot.workflow.response.WorkResponse;
import org.finos.springbot.workflow.response.templating.AbstractResourceTemplateProvider;
import org.finos.springbot.workflow.templating.Mode;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;

public class SymphonyTemplateProvider
extends AbstractResourceTemplateProvider<String, String, WorkResponse> {
    private final FreemarkerWorkTemplater formConverter;

    public SymphonyTemplateProvider(String templatePrefix, String templateSuffix, String defaultTemplateName, ResourceLoader rl, FreemarkerWorkTemplater formConverter) {
        super(templatePrefix, templateSuffix, defaultTemplateName, rl);
        this.formConverter = formConverter;
    }

    protected String getDefaultTemplate(WorkResponse r) {
        Object insert;
        Class c;
        if ("default-edit".equals(r.getTemplateName())) {
            c = r.getFormClass();
            insert = this.formConverter.convert(c, Mode.FORM);
        } else if ("default-view".equals(r.getTemplateName())) {
            c = r.getFormClass();
            boolean needsButtons = this.needsButtons((Response)r);
            insert = this.formConverter.convert(c, needsButtons ? Mode.DISPLAY_WITH_BUTTONS : Mode.DISPLAY);
        } else {
            throw new SymphonyException("Don't know how to construct default template for " + r);
        }
        String defaultTemplate = (String)this.getTemplateForName(this.getDefaultTemplateName());
        String out = defaultTemplate.replace("<!-- Message Content -->", (CharSequence)insert);
        return out;
    }

    protected boolean needsButtons(Response r) {
        if (r instanceof WorkResponse) {
            ButtonList bl = (ButtonList)((WorkResponse)r).getData().get("buttons");
            return bl != null && bl.getContents().size() > 0;
        }
        return false;
    }

    protected String deserializeTemplate(InputStream is) throws IOException {
        return StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
    }

    protected String applyTemplate(String template, WorkResponse t) {
        return template;
    }
}

