/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.templating;

import java.util.List;
import org.finos.springbot.symphony.templating.FreemarkerVariable;
import org.finos.springbot.workflow.annotations.WorkMode;
import org.finos.springbot.workflow.templating.AbstractTopLevelConverter;
import org.finos.springbot.workflow.templating.Mode;
import org.finos.springbot.workflow.templating.Rendering;
import org.finos.springbot.workflow.templating.TypeConverter;
import org.finos.springbot.workflow.templating.WithType;

public class FreemarkerWorkTemplater
extends AbstractTopLevelConverter<String, WorkMode> {
    public static final String JUST_BUTTONS_FORM = "just-buttons-form";

    public FreemarkerWorkTemplater(List<TypeConverter<String>> fieldConverters, Rendering<String> r) {
        super(fieldConverters, r);
    }

    public String convert(Class<?> c, Mode m) {
        FreemarkerVariable v = new FreemarkerVariable("entity.form");
        StringBuilder sb = new StringBuilder();
        sb.append("\n<#-- starting template -->");
        if (m == Mode.FORM) {
            sb.append("\n<form id=\"" + c.getCanonicalName() + "\">");
        }
        sb.append((String)this.apply(null, (WithType)this, c, m == Mode.FORM, v, this.topLevelFieldOutput()));
        if (m == Mode.DISPLAY_WITH_BUTTONS) {
            sb.append("\n<form id=\"just-buttons-form\">");
            sb.append(this.handleButtons());
            sb.append("\n</form>");
        } else if (m == Mode.FORM) {
            sb.append(this.handleButtons());
            sb.append("\n</form>");
        }
        sb.append("\n<#-- ending template -->\n");
        return sb.toString();
    }

    private String handleButtons() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  <p><#list entity.buttons.contents as button>");
        sb.append("\n    <button ");
        sb.append("\n         name=\"${button.name}\"");
        sb.append("\n         type=\"${button.buttonType?lower_case}\">");
        sb.append("\n      ${button.text}");
        sb.append("\n    </button>");
        sb.append("\n  </#list></p>");
        return sb.toString();
    }
}

