/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.templating;

import com.symphony.user.EmailAddress;
import com.symphony.user.UserId;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.finos.springbot.entityjson.EntityJson;
import org.finos.springbot.symphony.templating.FreemarkerVariable;
import org.finos.springbot.workflow.templating.TableRendering;
import org.finos.springbot.workflow.templating.Variable;
import org.springframework.util.StringUtils;

public class FreemarkerRendering
implements TableRendering<String> {
    public String description(String d) {
        return "<span>" + d + "</span>";
    }

    public String list(List<String> contents) {
        return "<table>" + contents.stream().reduce((a, b) -> a + "\n" + b).orElse("") + "</table>";
    }

    public String addFieldName(String field, String value) {
        return !StringUtils.hasText((String)field) ? "" : "<tr><td style=\"width: 200px\"><b>" + field + ":</b></td><td>" + value + "</td></tr>";
    }

    public String renderUserDropdown(Variable variable, String optionLocation, String optionKey, String optionValue, boolean editable) {
        return this.renderDropdown(variable, "id[0].value", optionLocation, optionKey, optionValue, editable);
    }

    public String renderDropdown(Variable variable, String variableKey, String choiceLocation, String choiceKey, String choiceValue, boolean editable) {
        String index = variable.index().getDataPath();
        int indent = ((FreemarkerVariable)variable).depth;
        if (editable) {
            return this.formatErrorsAndIndent(variable.getFormFieldName(), indent) + "<div style=\"min-height: 100px;\"><select " + this.attribute(variable, "name", variable.getFormFieldName()) + this.attribute(variable, "data-placeholder", "Choose " + variable.getDisplayName()) + ">" + this.indent(indent) + "  <#list entity." + choiceLocation + " as " + index + ">" + this.indent(indent) + "   <option value=\"${" + index + this.extend(choiceKey) + "}\" selected=\"${(((" + variable.getDataPath() + this.extend(variableKey) + ")!'') == " + index + this.extend(choiceKey) + ")?string('true','false')}\">" + this.indent(indent) + "    ${" + index + this.extend(choiceValue) + "}" + this.indent(indent) + "   </option>" + this.indent(indent) + " </#list>" + this.indent(indent) + "</select></div>";
        }
        return this.indent(indent) + "  <#list entity." + choiceLocation + " as " + index + ">" + this.indent(indent) + "   <#if (" + index + this.extend(choiceKey) + " == (" + variable.getDataPath() + this.extend(variableKey) + ")!'')>" + this.indent(indent) + "    ${" + index + this.extend(choiceValue) + "}" + this.indent(indent) + "   </#if>" + this.indent(indent) + "  </#list>";
    }

    private String mapToOptions(Map<String, String> options, Variable v, String variableKey) {
        return options.entrySet().stream().map(e -> this.convertToOption((Map.Entry<String, String>)e, v, variableKey)).reduce((a, b) -> a + "\n" + b).orElse("");
    }

    private String convertToOption(Map.Entry<String, String> e, Variable v, String variableKey) {
        return "   <option value=\"" + e.getKey() + "\" selected=\"${(((" + v.getDataPath() + variableKey + ")!'') == '" + e.getKey() + "')?string('true','false')}\">" + e.getValue() + "</option>";
    }

    private String mapToIfs(Map<String, String> options, Variable v, String variableKey) {
        return options.entrySet().stream().map(e -> this.convertToIf((Map.Entry<String, String>)e, v, variableKey)).reduce((a, b) -> a + "\n" + b).orElse("");
    }

    private String convertToIf(Map.Entry<String, String> e, Variable v, String variableKey) {
        return "   <#if ((" + v.getDataPath() + variableKey + ")!'') == '" + e.getKey() + "'>" + e.getValue() + "</#if>";
    }

    public String renderDropdown(Variable variable, String variableKey, Map<String, String> options, boolean editable) {
        int indent = ((FreemarkerVariable)variable).depth;
        if (editable) {
            return this.formatErrorsAndIndent(variable.getFormFieldName(), indent) + "<div style=\"min-height: 100px;\"><select " + this.attribute(variable, "name", variable.getFormFieldName()) + this.attribute(variable, "data-placeholder", "Choose " + variable.getDisplayName()) + ">" + this.indent(indent) + this.mapToOptions(options, variable, variableKey) + this.indent(indent) + "</select></div>";
        }
        return this.indent(indent) + this.mapToIfs(options, variable, variableKey);
    }

    public String textField(Variable variable, boolean editable) {
        String formFieldName = variable.getFormFieldName();
        if (editable) {
            return this.formatErrorsAndIndent(formFieldName, ((FreemarkerVariable)variable).depth) + "<text-field " + this.attribute(variable, "name", formFieldName) + this.attribute(variable, "placeholder", "") + ">" + this.text(variable, "", "!''") + "</text-field>";
        }
        return this.text(variable, "", "!''");
    }

    public String checkBox(Variable variable, boolean editable) {
        if (!editable) {
            return this.text(variable, "", "?string(\"Y\", \"N\")");
        }
        return this.formatErrorsAndIndent(variable.getFormFieldName(), ((FreemarkerVariable)variable).depth) + "<checkbox " + this.attribute(variable, "name", variable.getFormFieldName()) + this.attributeParam(variable, "checked", variable.getDataPath() + "?string('true', 'false')") + this.attribute(variable, "value", "true") + ">" + variable.getDisplayName() + "</checkbox>";
    }

    public String collection(Type t, Variable v, Variable i, String in, boolean editable) {
        return null;
    }

    public String button(String text, String id) {
        return "<button name=\"" + id + "\">" + text + "</button>";
    }

    public String buttons(String location) {
        return null;
    }

    private String attributeParam(Variable v, String name, String value) {
        return this.indent(((FreemarkerVariable)v).depth + 1) + name + "=\"${" + value + "}\"";
    }

    private String attribute(Variable v, String name, String value) {
        return this.indent(((FreemarkerVariable)v).depth + 1) + name + "=\"" + value + "\"";
    }

    private String text(Variable variable, String extension, String suffix) {
        return "${(" + variable.getDataPath() + extension + ")" + suffix + "}";
    }

    private String formatErrorsAndIndent(String formField, int indent) {
        if (!StringUtils.hasText((String)formField)) {
            return this.indent(indent);
        }
        return this.indent(indent) + "<span class=\"tempo-text-color--red\">${entity.errors.contents['" + formField + "']!''}</span>" + this.indent(indent);
    }

    private String indent(int n) {
        return "\n" + String.format("%" + n + "s", "");
    }

    public String table(Variable variable, String headers, String body) {
        StringBuilder sb = new StringBuilder();
        int depth = variable.getDepth();
        sb.append(this.formatErrorsAndIndent(variable.getFormFieldName(), depth));
        sb.append(this.indent(depth) + "<table><thead><tr>");
        sb.append(headers);
        sb.append(this.indent(depth) + "</tr></thead><tbody>");
        sb.append(body);
        sb.append(this.indent(depth) + "</tbody></table>");
        return sb.toString();
    }

    public String tableCell(Map<String, String> attributes, String content) {
        String atts = attributes.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + (String)e.getValue() + "\"").reduce("", (a, b) -> a + " " + b).trim();
        atts = atts.length() > 0 ? " " + atts : atts;
        return "<td" + atts + ">" + content + "</td>";
    }

    protected String beginIterator(Variable variable, Variable reg) {
        return this.indent(variable) + "<#list " + variable.getDataPath() + " as " + reg.getDataPath() + ">";
    }

    protected String indent(Variable variable) {
        return this.indent(variable.getDepth());
    }

    protected String endIterator(Variable variable) {
        return this.indent(variable) + "</#list>";
    }

    public String tableRow(Variable variable, Variable subVar, List<String> cells) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.beginIterator(variable, subVar));
        sb.append(this.indent(subVar) + " <tr>");
        sb.append(cells.stream().reduce((a, b) -> a + "\n" + b).orElse(""));
        sb.append(this.indent(subVar) + "</tr>");
        sb.append(this.endIterator(variable));
        return sb.toString();
    }

    public String tableHeaderRow(List<String> contents) {
        return contents.stream().reduce((a, b) -> a + "\n" + b).orElse("");
    }

    public String tableRowCheckBox(Variable variable, Variable subVar) {
        return "<checkbox name=\"" + variable.getFormFieldName() + ".${" + subVar.getDataPath() + "?index}." + "selected" + "\" />";
    }

    public String tableRowEditButton(Variable variable, Variable subVar) {
        String editId = variable.getFormFieldName() + "[${" + subVar.getDataPath() + "?index}]." + "table-edit-row";
        return this.button("Edit", editId);
    }

    public String userDisplay(Variable v) {
        StringBuilder sb = new StringBuilder();
        int depth = v.getDepth();
        sb.append(this.indent(depth) + "<#if " + v.getDataPath() + "??><#if " + v.getDataPath() + ".id??><#list " + v.getDataPath() + ".id as id>");
        sb.append(this.indent(depth) + " <#if id??>");
        sb.append(this.indent(depth) + " <#if id.type == '" + EntityJson.getEntityJsonTypeName(UserId.class) + "'><mention uid=\"${id.value}\" /><#break></#if>");
        sb.append(this.indent(depth) + " <#if id.type == '" + EntityJson.getEntityJsonTypeName(EmailAddress.class) + "'><mention email=\"${id.value}\" /><#break></#if>");
        sb.append(this.indent(depth) + " </#if></#list>");
        sb.append(this.indent(depth) + " <#elseif " + v.getDataPath() + ".name??>");
        sb.append(this.indent(depth) + "  ${" + v.getDataPath() + ".name}");
        sb.append(this.indent(depth) + "</#if></#if>");
        return sb.toString();
    }
}

