/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.data;

import com.fasterxml.jackson.databind.Module;
import com.symphony.user.DisplayName;
import com.symphony.user.EmailAddress;
import com.symphony.user.StreamID;
import java.util.Arrays;
import java.util.List;
import org.finos.springbot.entities.VersionSpaceHelp;
import org.finos.springbot.entityjson.VersionSpace;
import org.finos.springbot.symphony.data.LegacyFormatModule;
import org.finos.springbot.workflow.data.DataHandlerConfig;
import org.finos.springbot.workflow.data.EntityJsonConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DataHandlerConfig.class})
public class SymphonyDataHandlerCofig
implements InitializingBean {
    @Autowired
    EntityJsonConverter ejc;

    public void afterPropertiesSet() throws Exception {
        VersionSpaceHelp.basicSymphonyVersionSpace().stream().forEach(vs -> this.ejc.addVersionSpace(vs));
        List<VersionSpace> chatWorkflowVersionSpaces = SymphonyDataHandlerCofig.syphonyExtendedVersionSpace();
        chatWorkflowVersionSpaces.stream().forEach(vs -> this.ejc.addVersionSpace(vs));
        this.ejc.getObjectMapper().registerModule((Module)new LegacyFormatModule());
    }

    public static List<VersionSpace> syphonyExtendedVersionSpace() {
        return Arrays.asList(new VersionSpace(DisplayName.class, "1.0", new String[0]), new VersionSpace(StreamID.class, "1.0", new String[0]), new VersionSpace(EmailAddress.class, "1.0", new String[0]));
    }
}

