/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.conversations;

import com.symphony.bdk.gen.api.model.V4RoomCreated;
import com.symphony.bdk.gen.api.model.V4UserJoinedRoom;
import com.symphony.bdk.gen.api.model.V4UserLeftRoom;
import com.symphony.bdk.spring.events.RealTimeEvent;
import java.util.Collections;
import java.util.List;
import org.finos.springbot.symphony.content.SymphonyRoom;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.symphony.conversations.SymphonyConversations;
import org.finos.springbot.workflow.actions.Action;
import org.finos.springbot.workflow.actions.MemberAction;
import org.finos.springbot.workflow.actions.consumers.ActionConsumer;
import org.finos.springbot.workflow.content.Chat;
import org.finos.springbot.workflow.content.User;
import org.springframework.context.event.EventListener;

public class RoomMembershipChangeHandler {
    protected final List<ActionConsumer> messageConsumers;
    protected final SymphonyConversations sc;

    public RoomMembershipChangeHandler(List<ActionConsumer> messageConsumers, SymphonyConversations sc) {
        this.messageConsumers = messageConsumers;
        this.sc = sc;
    }

    @EventListener
    public void created(RealTimeEvent<V4RoomCreated> event) {
        V4RoomCreated roomCreated = (V4RoomCreated)event.getSource();
        SymphonyRoom room = this.sc.loadRoomById(roomCreated.getStream().getStreamId());
        SymphonyUser user = this.sc.loadUserById(roomCreated.getRoomProperties().getCreatorUser().getUserId());
        MemberAction a = new MemberAction((Chat)room, (User)user, MemberAction.Type.ADDED, Collections.emptyList());
        this.post(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(MemberAction a) {
        try {
            Action.CURRENT_ACTION.set(a);
            for (ActionConsumer c : this.messageConsumers) {
                c.accept((Object)a);
            }
        }
        finally {
            Action.CURRENT_ACTION.set(Action.NULL_ACTION);
        }
    }

    @EventListener
    public void joined(RealTimeEvent<V4UserJoinedRoom> event) {
        V4UserJoinedRoom userJoined = (V4UserJoinedRoom)event.getSource();
        SymphonyRoom room = this.sc.loadRoomById(userJoined.getStream().getStreamId());
        SymphonyUser user = this.sc.loadUserById(userJoined.getAffectedUser().getUserId());
        MemberAction a = new MemberAction((Chat)room, (User)user, MemberAction.Type.ADDED, Collections.emptyList());
        this.post(a);
    }

    @EventListener
    public void left(RealTimeEvent<V4UserLeftRoom> event) {
        V4UserLeftRoom userLeft = (V4UserLeftRoom)event.getSource();
        SymphonyRoom room = this.sc.loadRoomById(userLeft.getStream().getStreamId());
        SymphonyUser user = this.sc.loadUserById(userLeft.getAffectedUser().getUserId());
        MemberAction a = new MemberAction((Chat)room, (User)user, MemberAction.Type.REMOVED, Collections.emptyList());
        this.post(a);
    }
}

