/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.content.serialization;

import com.symphony.user.DisplayName;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.finos.springbot.entityjson.EntityJson;
import org.finos.springbot.symphony.SymphonyException;
import org.finos.springbot.symphony.content.CashTag;
import org.finos.springbot.symphony.content.HashTag;
import org.finos.springbot.symphony.content.RoomName;
import org.finos.springbot.symphony.content.SymphonyRoom;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.symphony.messages.PresentationMLHandler;
import org.finos.springbot.workflow.content.Content;
import org.finos.springbot.workflow.content.Message;
import org.finos.springbot.workflow.content.Tag;
import org.finos.springbot.workflow.content.serialization.AbstractContentParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.Taxonomy;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class MessageMLParser
extends AbstractContentParser<String, EntityJson> {
    private static final Logger LOG = LoggerFactory.getLogger(PresentationMLHandler.class);
    private SAXParserFactory factory = SAXParserFactory.newInstance();

    public Message apply(String source) {
        return this.apply(source, new EntityJson());
    }

    public Message apply(String message, final EntityJson jsonObjects) {
        message = !message.contains("<messageML>") ? "<messageML>" + message + "</messageML>" : message;
        final Content[] out = new Content[]{null};
        try {
            SAXParser saxParser = this.factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(message)), (DefaultHandler)new DefaultHandler2(){
                AbstractContentParser.Frame<?> top = null;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (this.top instanceof AbstractContentParser.CodeBlockFrame) {
                        this.push(new AbstractContentParser.IgnoredFrame(qName));
                        return;
                    } else if (this.isStartCodeBlock(qName, attributes)) {
                        this.push(new AbstractContentParser.CodeBlockFrame(qName));
                        return;
                    } else if (this.isStartTag(qName, attributes)) {
                        String dataEntityId = attributes.getValue("data-entity-id");
                        Object o = jsonObjects.get((Object)dataEntityId);
                        if (o instanceof SymphonyUser) {
                            this.push((AbstractContentParser.Frame)new TagFrame<SymphonyUser>(qName, (SymphonyUser)o));
                            return;
                        } else if (o instanceof HashTag) {
                            this.push((AbstractContentParser.Frame)new TagFrame<HashTag>(qName, (HashTag)((Object)o)));
                            return;
                        } else if (o instanceof CashTag) {
                            this.push((AbstractContentParser.Frame)new TagFrame<CashTag>(qName, (CashTag)((Object)o)));
                            return;
                        } else {
                            if (!(o instanceof Taxonomy) || ((Taxonomy)o).getId().isEmpty() || !(((Taxonomy)o).getId().get(0) instanceof HashTag)) throw new UnsupportedOperationException();
                            this.push((AbstractContentParser.Frame)new TagFrame<HashTag>(qName, (HashTag)((Object)((Taxonomy)o).getId().get(0))));
                        }
                        return;
                    } else if (this.isStartTable(qName, attributes)) {
                        this.push(new AbstractContentParser.TableFrame("table"));
                        return;
                    } else if (this.isStartParaListItemOrCell(qName, attributes)) {
                        this.push(new AbstractContentParser.ParagraphFrame(qName));
                        return;
                    } else if (this.isStartList(qName, attributes)) {
                        this.push(new AbstractContentParser.ListFrame(qName));
                        return;
                    } else if (this.isStartRow(qName, attributes)) {
                        if (!(this.top instanceof AbstractContentParser.TableFrame)) throw new UnsupportedOperationException();
                        ((AbstractContentParser.TableFrame)this.top).newRow();
                        return;
                    } else {
                        if (!this.isStartMessage(qName, attributes) || this.top != null) return;
                        this.push(new AbstractContentParser.MessageFrame("messageML"));
                    }
                }

                private boolean isStartMessage(String qName, Attributes attributes) {
                    return "messageML".equals(qName) || "div".equals(qName) && "PresentationML".equals(attributes.getValue("data-format"));
                }

                private boolean isStartList(String qName, Attributes attributes) {
                    return "ul".equals(qName) || "ol".equals(qName);
                }

                private boolean isStartRow(String qName, Attributes attributes) {
                    return "tr".equals(qName);
                }

                private boolean isStartCodeBlock(String qName, Attributes attributes) {
                    return "pre".equals(qName) || "code".equals(qName);
                }

                private <X extends AbstractContentParser.Frame<?>> X push(X newFrame) {
                    newFrame.parent = this.top;
                    this.top = newFrame;
                    return newFrame;
                }

                @Override
                public void startEntity(String name) throws SAXException {
                }

                @Override
                public void endEntity(String name) throws SAXException {
                }

                private boolean isStartTable(String qName, Attributes attributes) {
                    return "table".equals(qName);
                }

                private boolean isStartTag(String qName, Attributes attributes) {
                    return "span".equals(qName) && attributes.getValue("class") != null && attributes.getValue("class").contains("entity");
                }

                private boolean isStartParaListItemOrCell(String qName, Attributes attributes) {
                    return "p".equals(qName) || "td".equals(qName) || "li".equals(qName) || "th".equals(qName);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.top.isEnding(qName)) {
                        AbstractContentParser.Frame parent = this.top.parent;
                        Content c = this.top.getContents();
                        if (parent == null) {
                            out[0] = c;
                        } else {
                            this.top = parent;
                            this.top.push(c);
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.top instanceof AbstractContentParser.TextFrame) {
                        ((AbstractContentParser.TextFrame)this.top).push(ch, start, length);
                    } else {
                        String content = new String(ch, start, length);
                        if (!content.trim().isEmpty()) {
                            throw new UnsupportedOperationException("Wasn't expecting text: " + content);
                        }
                    }
                }

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    LOG.error("SAX warning: ", (Throwable)e);
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    LOG.error("SAX error: ", (Throwable)e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    LOG.error("SAX fatal error: ", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw new SymphonyException("Couldn't parse message: " + message, e);
        }
        return (Message)out[0];
    }

    static class TagFrame<X extends Tag>
    extends AbstractContentParser.TextFrame<X> {
        String id;
        X contents;

        public TagFrame(String qName, X contents) {
            super(qName);
            this.contents = contents;
        }

        public X getContents() {
            if (this.contents instanceof SymphonyUser && this.contents.getName() == null) {
                SymphonyUser su = (SymphonyUser)this.contents;
                su.getId().add(new DisplayName(this.bufferWithoutPrefix()));
            } else if (this.contents instanceof SymphonyRoom && this.contents.getName() == null) {
                SymphonyRoom sr = (SymphonyRoom)this.contents;
                sr.getId().add(new RoomName(this.bufferWithoutPrefix()));
            }
            return this.contents;
        }

        protected String bufferWithoutPrefix() {
            String out = this.buf.toString();
            if (out.startsWith("" + this.contents.getTagType().getPrefix())) {
                return out.substring(1);
            }
            return out;
        }

        public boolean isEnding(String qName) {
            return true;
        }

        public void push(Content c) {
            throw new UnsupportedOperationException("Can't nest content in tag");
        }

        public boolean hasContent() {
            return true;
        }
    }
}

