/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.content;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.symphony.user.DisplayName;
import com.symphony.user.EmailAddress;
import com.symphony.user.Mention;
import com.symphony.user.StreamID;
import com.symphony.user.UserId;
import java.util.ArrayList;
import java.util.List;
import org.finos.springbot.symphony.content.SymphonyAddressable;
import org.finos.springbot.symphony.content.SymphonyContent;
import org.finos.springbot.workflow.annotations.Work;
import org.finos.springbot.workflow.content.Tag;
import org.finos.springbot.workflow.content.User;
import org.symphonyoss.TaxonomyElement;

@Work(jsonTypeName={"com.symphony.user.mention", "org.finos.symphony.toolkit.workflow.content.userDef"}, index=false)
@JsonIncludeProperties(value={"id", "version"})
public final class SymphonyUser
extends Mention
implements User,
SymphonyContent,
SymphonyAddressable,
Tag {
    public SymphonyUser() {
    }

    public SymphonyUser(long userId) {
        super(SymphonyUser.createTaxonomy(userId, null, null));
    }

    private static List<TaxonomyElement> createTaxonomy(Long userId, String displayName, String emailAddress) {
        ArrayList<TaxonomyElement> out = new ArrayList<TaxonomyElement>();
        if (userId != null) {
            out.add((TaxonomyElement)new UserId("" + userId));
        } else {
            out.add(null);
        }
        if (displayName != null) {
            out.add((TaxonomyElement)new DisplayName(displayName));
        } else {
            out.add(null);
        }
        if (emailAddress != null) {
            out.add((TaxonomyElement)new EmailAddress(emailAddress));
        } else {
            out.add(null);
        }
        return out;
    }

    public SymphonyUser(long userId, String name, String emailAddress) {
        super(SymphonyUser.createTaxonomy(userId, name, emailAddress));
    }

    public SymphonyUser(String name, String emailAddress) {
        super(SymphonyUser.createTaxonomy(null, name, emailAddress));
    }

    @JsonIgnore
    public String getEmailAddress() {
        return this.fromTaxonomy(EmailAddress.class);
    }

    public String toString() {
        return "SymphonyUser [getId()=" + this.getId() + "]";
    }

    @JsonIgnore
    public String getStreamId() {
        return this.fromTaxonomy(StreamID.class);
    }

    public String getName() {
        return this.fromTaxonomy(DisplayName.class);
    }

    @JsonIgnore
    public Tag.Type getTagType() {
        return MENTION;
    }

    @JsonIgnore
    public String getUserId() {
        return this.fromTaxonomy(UserId.class);
    }

    @JsonIgnore
    public String getKey() {
        return this.getUserId();
    }
}

