/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.content;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.symphony.user.StreamID;
import java.util.ArrayList;
import java.util.List;
import org.finos.springbot.symphony.content.RoomName;
import org.finos.springbot.symphony.content.SymphonyAddressable;
import org.finos.springbot.workflow.annotations.Work;
import org.finos.springbot.workflow.content.Chat;
import org.symphonyoss.Taxonomy;
import org.symphonyoss.TaxonomyElement;

@Work(jsonTypeName={"org.finos.symphony.toolkit.workflow.content.chat"}, index=false)
public class SymphonyRoom
extends Taxonomy
implements Chat,
SymphonyAddressable {
    public SymphonyRoom() {
    }

    public SymphonyRoom(String name, String id) {
        super(SymphonyRoom.createTaxonomy(name, id));
    }

    private static List<TaxonomyElement> createTaxonomy(String name, String streamId) {
        ArrayList<TaxonomyElement> out = new ArrayList<TaxonomyElement>();
        if (streamId != null) {
            out.add((TaxonomyElement)new StreamID(streamId));
        } else {
            out.add(null);
        }
        if (name != null) {
            out.add(new RoomName(name));
        } else {
            out.add(null);
        }
        return out;
    }

    @JsonIgnore
    public String getName() {
        return this.fromTaxonomy(RoomName.class);
    }

    public String toString() {
        return "SymphonyRoom [name=" + this.getName() + ", streamId=" + this.getKey() + "]";
    }

    @JsonIgnore
    public String getKey() {
        return this.fromTaxonomy(StreamID.class);
    }
}

