/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.templating;

import java.util.List;
import org.finos.springbot.symphony.SymphonyWorkflowConfig;
import org.finos.springbot.symphony.content.SymphonyRoom;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.symphony.templating.FreemarkerRendering;
import org.finos.springbot.symphony.templating.FreemarkerWorkTemplater;
import org.finos.springbot.workflow.content.Chat;
import org.finos.springbot.workflow.content.User;
import org.finos.springbot.workflow.templating.BeanConverter;
import org.finos.springbot.workflow.templating.BooleanConverter;
import org.finos.springbot.workflow.templating.ChatConverter;
import org.finos.springbot.workflow.templating.DropdownAnnotationConverter;
import org.finos.springbot.workflow.templating.EnumConverter;
import org.finos.springbot.workflow.templating.Rendering;
import org.finos.springbot.workflow.templating.TableConverter;
import org.finos.springbot.workflow.templating.TableRendering;
import org.finos.springbot.workflow.templating.TextFieldConverter;
import org.finos.springbot.workflow.templating.TimeConverter;
import org.finos.springbot.workflow.templating.TypeConverter;
import org.finos.springbot.workflow.templating.UserConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={SymphonyWorkflowConfig.class})
public class FreemarkerTypeConverterConfig {
    @Bean
    protected FreemarkerRendering symphonyFreeMarkerRendering() {
        return new FreemarkerRendering();
    }

    @Bean
    @Qualifier(value="freemarker")
    protected BeanConverter<String> fmBeanConverter(FreemarkerRendering r) {
        return new BeanConverter((Rendering)r);
    }

    @Bean
    @Qualifier(value="freemarker")
    protected BooleanConverter<String> fmBooleanConverter(FreemarkerRendering r) {
        return new BooleanConverter((Rendering)r);
    }

    @Bean
    @Qualifier(value="freemarker")
    protected TableConverter<String> fmCollectionConverter(FreemarkerRendering r) {
        return new TableConverter((TableRendering)r);
    }

    @Bean
    @Qualifier(value="freemarker")
    protected EnumConverter<String> fmEnumConverter(FreemarkerRendering r) {
        return new EnumConverter((Rendering)r);
    }

    @Bean
    @Qualifier(value="freemarker")
    public UserConverter<String> hashTagConverter(FreemarkerRendering r) {
        return new UserConverter(50, (Rendering)r, new Class[]{SymphonyUser.class});
    }

    @Bean
    @Qualifier(value="freemarker")
    public TimeConverter<String> timeConverter(FreemarkerRendering r) {
        return new TimeConverter((Rendering)r);
    }

    @Bean
    @Qualifier(value="freemarker")
    protected TextFieldConverter<String> fmTextFieldConverter(FreemarkerRendering r) {
        return new TextFieldConverter(50, (Rendering)r, new Class[]{String.class, Number.class, Integer.TYPE, Float.TYPE, Double.TYPE, Short.TYPE, Long.TYPE, Byte.TYPE});
    }

    @Bean
    @Qualifier(value="freemarker")
    protected ChatConverter<String> fmRoomConverter(FreemarkerRendering r) {
        return new ChatConverter(50, (Rendering)r, new Class[]{SymphonyRoom.class, Chat.class});
    }

    @Bean
    @Qualifier(value="freemarker")
    protected DropdownAnnotationConverter<String> fmDropdownAnnotationConverter(FreemarkerRendering r) {
        return new DropdownAnnotationConverter((Rendering)r);
    }

    @Bean
    @Qualifier(value="freemarker")
    protected UserConverter<String> rmUserConverter(FreemarkerRendering r) {
        return new UserConverter(50, (Rendering)r, new Class[]{User.class});
    }

    @Bean
    @ConditionalOnMissingBean
    public FreemarkerWorkTemplater formMessageMLConverter(@Qualifier(value="freemarker") List<TypeConverter<String>> converters, FreemarkerRendering r) {
        return new FreemarkerWorkTemplater(converters, (Rendering<String>)r);
    }
}

