/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.tags;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.finos.springbot.symphony.content.HashTag;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.workflow.content.Tag;
import org.finos.springbot.workflow.tags.TagSupport;
import org.springframework.util.StringUtils;

public class SymphonyTagSupport
extends TagSupport {
    public static String toHashTag(String in) {
        if (!StringUtils.hasText((String)in)) {
            return "";
        }
        return "<hash tag=\"" + SymphonyTagSupport.formatTag((String)in) + "\" /> ";
    }

    public static String toCashTag(String in) {
        if (!StringUtils.hasText((String)in)) {
            return "";
        }
        return "<cash tag=\"" + SymphonyTagSupport.formatTag((String)in) + "\" /> ";
    }

    public static String toUserTag(String id) {
        if (!StringUtils.hasText((String)id)) {
            return "";
        }
        return "<mention uid=\"" + id + "\" />";
    }

    public static String format(Tag t) {
        if (t.getTagType() == Tag.CASH) {
            return SymphonyTagSupport.toCashTag(t.getName());
        }
        if (t.getTagType() == Tag.HASH) {
            return SymphonyTagSupport.toHashTag(t.getName());
        }
        if (t.getTagType() == Tag.MENTION) {
            return SymphonyTagSupport.toUserTag(((SymphonyUser)t).getUserId());
        }
        return "";
    }

    public static Set<HashTag> classHashTags(Object in) {
        if (in instanceof Class) {
            return SymphonyTagSupport.toHashTags((Class)in).stream().collect(Collectors.toSet());
        }
        if (in != null) {
            return SymphonyTagSupport.toHashTags(in.getClass()).stream().collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static Set<HashTag> toHashTags(Class<?> c) {
        return SymphonyTagSupport.toTags(c).stream().map(e -> new HashTag((String)e)).collect(Collectors.toSet());
    }
}

