/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.messages;

import com.symphony.bdk.gen.api.model.V4MessageSent;
import com.symphony.bdk.spring.events.RealTimeEvent;
import java.util.List;
import org.finos.springbot.entityjson.EntityJson;
import org.finos.springbot.symphony.content.SymphonyAddressable;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.symphony.content.serialization.MessageMLParser;
import org.finos.springbot.symphony.conversations.SymphonyConversations;
import org.finos.springbot.workflow.actions.Action;
import org.finos.springbot.workflow.actions.SimpleMessageAction;
import org.finos.springbot.workflow.actions.consumers.ActionConsumer;
import org.finos.springbot.workflow.content.Addressable;
import org.finos.springbot.workflow.content.Message;
import org.finos.springbot.workflow.content.User;
import org.finos.springbot.workflow.data.EntityJsonConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class PresentationMLHandler
implements ApplicationListener<RealTimeEvent<V4MessageSent>> {
    private static final Logger LOG = LoggerFactory.getLogger(PresentationMLHandler.class);
    String botUsername;
    MessageMLParser messageParser;
    EntityJsonConverter jsonConverter;
    List<ActionConsumer> messageConsumers;
    SymphonyConversations ruBuilder;

    public PresentationMLHandler(MessageMLParser messageParser, EntityJsonConverter jsonConverter, List<ActionConsumer> messageConsumers, SymphonyConversations ruBuilder, String botUsername) {
        this.messageParser = messageParser;
        this.jsonConverter = jsonConverter;
        this.messageConsumers = messageConsumers;
        this.ruBuilder = ruBuilder;
        this.botUsername = botUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(RealTimeEvent<V4MessageSent> t) {
        block6: {
            try {
                V4MessageSent ms = (V4MessageSent)t.getSource();
                if (ms == null || ms.getMessage().getUser().getUsername().equals(this.botUsername)) break block6;
                EntityJson ej = this.jsonConverter.readValue(ms.getMessage().getData());
                Message words = this.messageParser.apply(ms.getMessage().getMessage(), ej);
                SymphonyAddressable rr = this.ruBuilder.loadRoomById(ms.getMessage().getStream().getStreamId());
                SymphonyUser u = this.ruBuilder.loadUserById(ms.getMessage().getUser().getUserId());
                rr = rr == null ? u : rr;
                SimpleMessageAction sma = new SimpleMessageAction((Addressable)rr, (User)u, words, (Object)ej);
                try {
                    Action.CURRENT_ACTION.set(sma);
                    for (ActionConsumer c : this.messageConsumers) {
                        c.accept((Object)sma);
                    }
                }
                finally {
                    Action.CURRENT_ACTION.set(Action.NULL_ACTION);
                }
            }
            catch (Exception e) {
                LOG.error("Couldn't handle event " + t, (Throwable)e);
            }
        }
    }
}

