/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.history;

import com.symphony.bdk.core.service.message.MessageService;
import com.symphony.bdk.core.service.pagination.model.PaginationAttribute;
import com.symphony.bdk.gen.api.model.MessageSearchQuery;
import com.symphony.bdk.gen.api.model.V4Message;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.finos.springbot.entityjson.EntityJson;
import org.finos.springbot.symphony.content.CashTag;
import org.finos.springbot.symphony.content.HashTag;
import org.finos.springbot.symphony.content.SymphonyAddressable;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.symphony.conversations.StreamResolver;
import org.finos.springbot.symphony.history.SymphonyHistory;
import org.finos.springbot.symphony.tags.SymphonyTagSupport;
import org.finos.springbot.workflow.content.Addressable;
import org.finos.springbot.workflow.content.Tag;
import org.finos.springbot.workflow.data.EntityJsonConverter;

public class SymphonyHistoryImpl
implements SymphonyHistory {
    private EntityJsonConverter jsonConverter;
    private MessageService messageApi;
    private StreamResolver sr;

    public SymphonyHistoryImpl(EntityJsonConverter jsonConverter, MessageService messageApi, StreamResolver sr) {
        this.jsonConverter = jsonConverter;
        this.messageApi = messageApi;
        this.sr = sr;
    }

    public <X> Optional<X> getLastFromHistory(Class<X> type, SymphonyAddressable address) {
        return this.getRelevantObject(this.getLastEntityJsonFromHistory(type, address), type);
    }

    @Override
    public <X> Optional<EntityJson> getLastEntityJsonFromHistory(Class<X> type, SymphonyAddressable address) {
        MessageSearchQuery msq = this.createMessageSearchQuery(type, address, null, null);
        PaginationAttribute pa = new PaginationAttribute(Integer.valueOf(0), Integer.valueOf(1));
        List out = this.messageApi.searchMessages(msq, pa);
        return this.convertToOptionalEntityJson(out);
    }

    protected Optional<EntityJson> convertToOptionalEntityJson(List<V4Message> out) {
        for (V4Message msg : out) {
            EntityJson o = this.getEntityJson(msg);
            if (o == null) continue;
            return Optional.of(o);
        }
        return Optional.empty();
    }

    protected <X> Optional<X> convertToOptionalInstance(Class<X> type, List<V4Message> out) {
        for (V4Message msg : out) {
            X o = this.getRelevantObject(msg, type);
            if (o == null) continue;
            return Optional.of(o);
        }
        return Optional.empty();
    }

    public <X> Optional<X> getLastFromHistory(Class<X> type, Tag t, SymphonyAddressable address) {
        return this.getRelevantObject(this.getLastEntityJsonFromHistory(type, t, address), type);
    }

    @Override
    public <X> Optional<EntityJson> getLastEntityJsonFromHistory(Class<X> type, Tag t, SymphonyAddressable address) {
        MessageSearchQuery msq = this.createMessageSearchQuery(null, address, null, t);
        PaginationAttribute pa = new PaginationAttribute(Integer.valueOf(0), Integer.valueOf(1));
        List out = this.messageApi.searchMessages(msq, pa);
        return this.convertToOptionalEntityJson(out);
    }

    public <X> List<X> getFromHistory(Class<X> type, Tag t, SymphonyAddressable address, Instant since) {
        return this.getFromEntityJson(this.getEntityJsonFromHistory(t, address, since), type);
    }

    @Override
    public <X> List<X> getFromEntityJson(List<EntityJson> ej, Class<X> type) {
        return ej.stream().map(i -> this.getRelevantObject(Optional.of(i), type)).filter(o -> o.isPresent()).map(o -> o.get()).collect(Collectors.toList());
    }

    @Override
    public List<EntityJson> getEntityJsonFromHistory(Tag t, SymphonyAddressable address, Instant since) {
        MessageSearchQuery msq = this.createMessageSearchQuery(null, address, since, t);
        PaginationAttribute pa = new PaginationAttribute(Integer.valueOf(0), Integer.valueOf(50));
        List out = this.messageApi.searchMessages(msq, pa);
        return out.stream().map(msg -> this.getEntityJson((V4Message)msg)).filter(e -> e != null).collect(Collectors.toList());
    }

    protected EntityJson getEntityJson(V4Message msg) {
        try {
            return this.jsonConverter.readValue(msg.getData());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    protected <T> T getRelevantObject(V4Message msg, Class<T> required) {
        EntityJson ej = this.getEntityJson(msg);
        return this.getFromEntityJson(ej, required).orElse(null);
    }

    protected <T> Optional<T> getRelevantObject(Optional<EntityJson> ej, Class<T> required) {
        if (ej == null || !ej.isPresent()) {
            return Optional.empty();
        }
        return this.getFromEntityJson(ej.get(), required);
    }

    @Override
    public <X> Optional<X> getFromEntityJson(EntityJson ej, Class<X> required) {
        for (Map.Entry ent : ej.entrySet()) {
            if (!required.isAssignableFrom(ent.getValue().getClass())) continue;
            return Optional.of(ent.getValue());
        }
        return Optional.empty();
    }

    public <X> List<X> getFromHistory(Class<X> type, SymphonyAddressable address, Instant since) {
        return this.getEntityJsonFromHistory(type, address, since).stream().map(ej -> this.getRelevantObject(Optional.of(ej), type)).filter(o -> o.isPresent()).map(o -> o.get()).collect(Collectors.toList());
    }

    @Override
    public <X> List<EntityJson> getEntityJsonFromHistory(Class<X> type, SymphonyAddressable address, Instant since) {
        MessageSearchQuery msq = this.createMessageSearchQuery(type, address, since, null);
        PaginationAttribute pa = new PaginationAttribute(Integer.valueOf(0), Integer.valueOf(50));
        List out = this.messageApi.searchMessages(msq, pa);
        return out.stream().map(msg -> this.getEntityJson((V4Message)msg)).filter(e -> e != null).collect(Collectors.toList());
    }

    private <X> MessageSearchQuery createMessageSearchQuery(Class<X> type, Addressable address, Instant since, Tag t) {
        MessageSearchQuery msq = new MessageSearchQuery();
        if (address instanceof SymphonyAddressable) {
            msq.setStreamId(this.sr.getStreamFor((SymphonyAddressable)address));
        }
        if (since != null) {
            msq.fromDate(Long.valueOf(since.toEpochMilli()));
        }
        if (type != null) {
            msq.setHashtag(SymphonyTagSupport.formatTag(type));
        } else if (t != null) {
            if (t instanceof CashTag) {
                msq.setCashtag(t.getName());
            } else if (t instanceof HashTag) {
                msq.setHashtag(t.getName());
            } else if (t instanceof SymphonyUser) {
                msq.setMention(Long.valueOf(Long.parseLong(((SymphonyUser)t).getUserId())));
            }
        }
        return msq;
    }

    public boolean isSupported(Addressable a) {
        return a instanceof SymphonyAddressable;
    }
}

