/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.form;

import com.symphony.bdk.core.service.message.MessageService;
import com.symphony.bdk.gen.api.model.V4Message;
import com.symphony.bdk.gen.api.model.V4SymphonyElementsAction;
import com.symphony.bdk.spring.events.RealTimeEvent;
import java.util.List;
import java.util.Map;
import org.finos.springbot.entityjson.EntityJson;
import org.finos.springbot.symphony.content.SymphonyAddressable;
import org.finos.springbot.symphony.content.SymphonyRoom;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.symphony.conversations.SymphonyConversations;
import org.finos.springbot.workflow.actions.Action;
import org.finos.springbot.workflow.actions.FormAction;
import org.finos.springbot.workflow.actions.consumers.ActionConsumer;
import org.finos.springbot.workflow.content.Addressable;
import org.finos.springbot.workflow.data.EntityJsonConverter;
import org.finos.springbot.workflow.form.FormConverter;
import org.finos.springbot.workflow.form.FormValidationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ElementsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ElementsHandler.class);
    MessageService messagesApi;
    EntityJsonConverter jsonConverter;
    FormConverter formConverter;
    List<ActionConsumer> elementsConsumers;
    SymphonyConversations ruBuilder;
    FormValidationProcessor validationProcessor;

    public ElementsHandler(MessageService messagesApi, EntityJsonConverter jsonConverter, FormConverter formConverter, List<ActionConsumer> elementsConsumers, SymphonyConversations ruBuilder, FormValidationProcessor fvp) {
        this.messagesApi = messagesApi;
        this.jsonConverter = jsonConverter;
        this.formConverter = formConverter;
        this.elementsConsumers = elementsConsumers;
        this.ruBuilder = ruBuilder;
        this.validationProcessor = fvp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void accept(RealTimeEvent<V4SymphonyElementsAction> event) {
        block8: {
            try {
                V4SymphonyElementsAction action = (V4SymphonyElementsAction)event.getSource();
                Map formValues = (Map)action.getFormValues();
                String verb = (String)formValues.get("action");
                String formId = action.getFormId();
                Object currentForm = this.hasFormData(formValues) ? this.formConverter.convert(formValues, formId) : null;
                EntityJson data = this.retrieveData(action.getFormMessageId());
                SymphonyRoom rr = this.ruBuilder.loadRoomById(action.getStream().getStreamId());
                SymphonyUser u = this.ruBuilder.loadUserById(event.getInitiator().getUser().getUserId());
                SymphonyAddressable from = rr == null ? u : rr;
                FormAction ea = this.validationProcessor.validationCheck(verb, (Addressable)rr, currentForm, () -> new FormAction(from, u, currentForm, verb, (Map)data));
                if (ea == null) break block8;
                try {
                    Action.CURRENT_ACTION.set(ea);
                    for (ActionConsumer c : this.elementsConsumers) {
                        try {
                            c.accept((Object)ea);
                        }
                        catch (Exception ee) {
                            LOG.error("Failed to handle consumer " + c, (Throwable)ee);
                        }
                    }
                }
                finally {
                    Action.CURRENT_ACTION.set(Action.NULL_ACTION);
                }
            }
            catch (Exception e) {
                LOG.error("Couldn't handle event " + event, (Throwable)e);
            }
        }
    }

    private boolean hasFormData(Map<String, Object> formValues) {
        return formValues.size() > 1;
    }

    private EntityJson retrieveData(String formMessageId) {
        if (formMessageId != null) {
            V4Message originatingMessage = this.messagesApi.getMessage(formMessageId.replace("/", "_").replace("+", "-").replace("=", ""));
            return this.jsonConverter.readValue(originatingMessage.getData());
        }
        return new EntityJson();
    }
}

