/*
 * Decompiled with CFR 0.152.
 */
package org.finos.springbot.symphony.conversations;

import com.symphony.bdk.core.service.pagination.model.PaginationAttribute;
import com.symphony.bdk.core.service.session.SessionService;
import com.symphony.bdk.core.service.stream.StreamService;
import com.symphony.bdk.core.service.user.UserService;
import com.symphony.bdk.gen.api.model.MemberInfo;
import com.symphony.bdk.gen.api.model.Stream;
import com.symphony.bdk.gen.api.model.StreamAttributes;
import com.symphony.bdk.gen.api.model.StreamFilter;
import com.symphony.bdk.gen.api.model.StreamType;
import com.symphony.bdk.gen.api.model.UserV2;
import com.symphony.bdk.gen.api.model.V2RoomSearchCriteria;
import com.symphony.bdk.gen.api.model.V3RoomAttributes;
import com.symphony.bdk.gen.api.model.V3RoomDetail;
import com.symphony.bdk.gen.api.model.V3RoomSearchResults;
import com.symphony.user.StreamID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.finos.springbot.symphony.SymphonyException;
import org.finos.springbot.symphony.content.SymphonyAddressable;
import org.finos.springbot.symphony.content.SymphonyRoom;
import org.finos.springbot.symphony.content.SymphonyUser;
import org.finos.springbot.symphony.conversations.SymphonyConversations;
import org.finos.springbot.workflow.content.Addressable;
import org.finos.springbot.workflow.content.Chat;
import org.finos.springbot.workflow.content.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SymphonyConversationsImpl
implements SymphonyConversations,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SymphonyConversationsImpl.class);
    private List<User> defaultAdministrators = new ArrayList<User>();
    private long botUserId;
    private final UserService userService;
    private final StreamService streamsApi;
    private final SessionService sessionService;
    private final boolean localPodLookup;

    public SymphonyConversationsImpl(StreamService streamsApi, UserService userService, SessionService sessionService, boolean localPodLookup) {
        this.userService = userService;
        this.streamsApi = streamsApi;
        this.localPodLookup = localPodLookup;
        this.sessionService = sessionService;
    }

    public Set<Addressable> getAllAddressables() {
        return this.getAllConversationsFiltered(new StreamFilter());
    }

    public Set<SymphonyRoom> getAllChats() {
        StreamType st = new StreamType().type(StreamType.TypeEnum.ROOM);
        StreamFilter streamTypes = new StreamFilter().streamTypes(Collections.singletonList(st));
        return this.getAllConversationsFiltered(streamTypes);
    }

    protected Set<Addressable> getAllConversationsFiltered(StreamFilter f) {
        List sl;
        f.includeInactiveStreams(Boolean.valueOf(false));
        HashSet<Addressable> out = new HashSet<Addressable>();
        int skip = 0;
        do {
            sl = this.streamsApi.listStreams(f, new PaginationAttribute(Integer.valueOf(skip), Integer.valueOf(50)));
            sl.forEach(si -> {
                Addressable a = this.convertToAddressable((StreamAttributes)si);
                if (a != null) {
                    out.add(a);
                }
            });
            skip += sl.size();
        } while (sl.size() == 50);
        return out;
    }

    protected Addressable convertToAddressable(StreamAttributes si) {
        switch (si.getStreamType().getType()) {
            case IM: {
                return this.loadUserByStreamAttributes(si);
            }
            case MIM: {
                return null;
            }
            case ROOM: {
                return this.loadRoomByStreamAttributes(si);
            }
        }
        return null;
    }

    protected SymphonyUser loadUserByStreamAttributes(StreamAttributes si) {
        if (si.getStreamAttributes().getMembers().size() != 2) {
            return null;
        }
        Long userId = si.getStreamAttributes().getMembers().stream().filter(id -> id != this.botUserId).findFirst().orElse(null);
        if (userId == null) {
            return null;
        }
        SymphonyUser out = new SymphonyUser(userId);
        out.getId().add(new StreamID(si.getId()));
        return out;
    }

    protected SymphonyRoom loadRoomByStreamAttributes(StreamAttributes si) {
        return new SymphonyRoom(si.getRoomAttributes().getName(), si.getId());
    }

    @Override
    public SymphonyUser loadUserById(Long userId) {
        List users = this.userService.listUsersByIds(Collections.singletonList(userId), Boolean.valueOf(this.localPodLookup), Boolean.valueOf(true));
        if (users.size() == 1) {
            UserV2 user = (UserV2)users.get(0);
            return new SymphonyUser(userId, user.getDisplayName(), user.getEmailAddress());
        }
        throw new SymphonyException("User not found: " + userId);
    }

    @Override
    public String getStreamFor(SymphonyAddressable a) {
        if (a instanceof SymphonyUser) {
            return this.getStreamIdForUser((SymphonyUser)a);
        }
        if (a instanceof SymphonyRoom) {
            return ((SymphonyRoom)a).getKey();
        }
        throw new SymphonyException("What is this? " + a);
    }

    protected String getStreamIdForUser(SymphonyUser a) {
        if (a.getStreamId() != null) {
            return a.getStreamId();
        }
        if (a.getUserId() == null) {
            a = this.loadUserByEmail(a.getEmailAddress());
        }
        long userId = Long.parseLong(a.getUserId());
        Stream s = this.streamsApi.create(Collections.singletonList(userId));
        a.getId().add(new StreamID(s.getId()));
        return s.getId();
    }

    @Override
    public SymphonyUser loadUserByUsername(String username) {
        List users = this.userService.listUsersByUsernames(Collections.singletonList(username));
        if (users.size() == 1) {
            UserV2 user = (UserV2)users.get(0);
            return new SymphonyUser(user.getId(), user.getDisplayName(), user.getEmailAddress());
        }
        throw new SymphonyException("User not found: " + username);
    }

    @Override
    public SymphonyUser loadUserByEmail(String name) {
        List users = this.userService.listUsersByEmails(Collections.singletonList(name), Boolean.valueOf(this.localPodLookup), Boolean.valueOf(true));
        if (users.size() == 1) {
            UserV2 user = (UserV2)users.get(0);
            return new SymphonyUser(user.getId(), user.getDisplayName(), user.getEmailAddress());
        }
        throw new SymphonyException("User not found: " + name);
    }

    @Override
    public SymphonyRoom loadRoomById(String streamId) {
        try {
            V3RoomDetail r = this.streamsApi.getRoomInfo(streamId);
            return new SymphonyRoom(r.getRoomAttributes().getName(), streamId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public SymphonyRoom loadRoomByName(String name) {
        V2RoomSearchCriteria rsc = new V2RoomSearchCriteria();
        rsc.setQuery(name);
        V3RoomSearchResults res = this.streamsApi.searchRooms(rsc);
        return res.getRooms().stream().filter(r -> r.getRoomAttributes().getName().equals(name)).findFirst().map(rd -> new SymphonyRoom(rd.getRoomAttributes().getName(), rd.getRoomSystemInfo().getId())).orElse(null);
    }

    public SymphonyRoom ensureChat(SymphonyRoom r, List<SymphonyUser> users, Map<String, Object> meta) {
        String description = "";
        String name = r.getName();
        boolean isPublic = false;
        description = (String)meta.getOrDefault("room-description", "");
        isPublic = (Boolean)meta.getOrDefault("room-public", false);
        SymphonyRoom theRoom = null;
        if (r instanceof SymphonyRoom) {
            theRoom = r.getKey() != null ? r : this.loadRoomByName(name);
        }
        if (theRoom == null) {
            V3RoomAttributes ra = new V3RoomAttributes().name(name).description(description)._public(Boolean.valueOf(isPublic)).discoverable(Boolean.valueOf(isPublic));
            V3RoomDetail detail = this.streamsApi.create(ra);
            String streamId = detail.getRoomSystemInfo().getId();
            theRoom = new SymphonyRoom(name, streamId);
            List adminIds = this.getDefaultAdministrators().stream().filter(u -> u instanceof SymphonyUser).map(u -> (SymphonyUser)u).map(su -> Long.parseLong(su.getUserId())).filter(id -> id != null).collect(Collectors.toList());
            for (Long user : adminIds) {
                this.streamsApi.addMemberToRoom(user, streamId);
                this.streamsApi.promoteUserToRoomOwner(user, streamId);
            }
            LOG.info("Created room {} with admins {} ", (Object)theRoom, this.getDefaultAdministrators());
        }
        String streamId = theRoom.getKey();
        users.stream().filter(u -> u instanceof SymphonyUser).map(u -> u).forEach(u -> this.streamsApi.addMemberToRoom(Long.valueOf(Long.parseLong(u.getUserId())), streamId));
        return theRoom;
    }

    public List<SymphonyUser> getChatMembers(SymphonyRoom r) {
        return this.getUsersInternal(r, f -> true);
    }

    public List<SymphonyUser> getChatAdmins(SymphonyRoom r) {
        return this.getUsersInternal(r, f -> f.getOwner());
    }

    protected List<SymphonyUser> getUsersInternal(SymphonyRoom r, Predicate<MemberInfo> filter) {
        if (r instanceof SymphonyRoom) {
            List ml = this.streamsApi.listRoomMembers(r.getKey());
            List ids = ml.stream().filter(filter).map(e -> e.getId()).collect(Collectors.toList());
            List users = this.userService.listUsersByIds(ids, Boolean.valueOf(this.localPodLookup), Boolean.valueOf(true));
            return users.stream().map(e -> new SymphonyUser(e.getId(), e.getDisplayName(), e.getEmailAddress())).collect(Collectors.toList());
        }
        throw new SymphonyException("Not a room: " + r);
    }

    public List<User> getDefaultAdministrators() {
        return this.defaultAdministrators;
    }

    public void setDefaultAdministrators(List<User> defaultAdministrators) {
        this.defaultAdministrators = defaultAdministrators;
    }

    public void afterPropertiesSet() throws Exception {
        this.botUserId = this.sessionService.getSession().getId();
    }

    public SymphonyRoom getExistingChat(String name) {
        return this.loadRoomByName(name);
    }

    public boolean isSupported(Chat r) {
        return r instanceof SymphonyRoom;
    }

    public boolean isSupported(User u) {
        return u instanceof SymphonyUser;
    }

    public boolean isThisBot(User u) {
        if (u instanceof SymphonyUser) {
            return ((SymphonyUser)u).getUserId().equals("" + this.botUserId);
        }
        return false;
    }
}

