/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.util;

import com.regnosys.rosetta.resource.RosettaResource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.scoping.RosettaScopeProvider;
import com.regnosys.rosetta.services.RosettaGrammarAccess;
import com.regnosys.rosetta.tests.util.ModelHelper;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.lazy.LazyLinker;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.resource.XtextSyntaxDiagnosticWithRange;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.util.CancelIndicator;

public class ExpressionParser {
    @Inject
    private IParser parser;
    @Inject
    private RosettaGrammarAccess grammar;
    @Inject
    private ModelHelper modelHelper;
    @Inject
    private Provider<ExpressionResource> resourceProvider;
    @Inject
    private RosettaStaticLinker linker;

    public RosettaExpression parseExpression(CharSequence expr) {
        return this.parseExpression(expr, List.of());
    }

    public RosettaExpression parseExpression(CharSequence expr, Collection<? extends CharSequence> attrs) {
        return this.parseExpression(expr, List.of(), attrs);
    }

    public RosettaExpression parseExpression(CharSequence expr, List<RosettaModel> context, Collection<? extends CharSequence> attrs) {
        List<Attribute> attributes = attrs.stream().map(a -> this.parseAttribute((CharSequence)a, context)).toList();
        return this.parseExpression(expr, context, (Attribute[])attributes.toArray(Attribute[]::new));
    }

    public RosettaExpression parseExpression(CharSequence expr, Attribute ... attributes) {
        return this.parseExpression(expr, List.of(), attributes);
    }

    public RosettaExpression parseExpression(CharSequence expr, List<RosettaModel> context, Attribute ... attributes) {
        List<RosettaModel> cont = context.isEmpty() ? this.defaultContext() : context;
        IParseResult result = this.parser.parse(this.grammar.getExpressionRule(), (Reader)new StringReader(expr.toString()));
        RosettaExpression expression = (RosettaExpression)result.getRootASTElement();
        this.addSyntaxDiagnostics((Resource)this.createResource("expr", (EObject)expression, cont), result);
        this.link((EObject)expression, cont, List.of(attributes));
        return expression;
    }

    public Attribute parseAttribute(CharSequence attr) {
        return this.parseAttribute(attr, this.defaultContext());
    }

    public Attribute parseAttribute(CharSequence attr, List<RosettaModel> context) {
        List<RosettaModel> cont = context.isEmpty() ? this.defaultContext() : context;
        IParseResult result = this.parser.parse(this.grammar.getAttributeRule(), (Reader)new StringReader(attr.toString()));
        Attribute attribute = (Attribute)result.getRootASTElement();
        this.addSyntaxDiagnostics((Resource)this.createResource("attribute", (EObject)attribute, cont), result);
        this.link((EObject)attribute, context, List.of());
        return attribute;
    }

    private void addSyntaxDiagnostics(Resource resource, IParseResult parseResult) {
        for (INode error : parseResult.getSyntaxErrors()) {
            String[] issueData;
            SyntaxErrorMessage syntaxErrorMessage = error.getSyntaxErrorMessage();
            if ("org.eclipse.xtext.diagnostics.Diagnostic.Syntax.Range".equals(syntaxErrorMessage.getIssueCode()) && (issueData = syntaxErrorMessage.getIssueData()).length == 1) {
                String data = issueData[0];
                int colon = data.indexOf(58);
                resource.getErrors().add((Object)new XtextSyntaxDiagnosticWithRange(error, Integer.parseInt(data.substring(0, colon)), Integer.parseInt(data.substring(colon + 1)), null));
                return;
            }
            resource.getErrors().add((Object)new XtextSyntaxDiagnostic(error));
        }
    }

    private ExpressionResource createResource(String name, EObject content, List<RosettaModel> context) {
        ResourceSet resourceSet = context.getFirst().eResource().getResourceSet();
        int nr = 0;
        URI uniqueURI = URI.createURI((String)("synthetic://" + name + nr++));
        while (resourceSet.getResource(uniqueURI, false) != null) {
            uniqueURI = URI.createURI((String)("synthetic://" + name + nr++));
        }
        ExpressionResource resource = (ExpressionResource)((Object)this.resourceProvider.get());
        resource.setURI(uniqueURI);
        resource.getContents().add((Object)content);
        resourceSet.getResources().add((Object)resource);
        return resource;
    }

    private List<RosettaModel> defaultContext() {
        ResourceSet rs = this.modelHelper.testResourceSet();
        ArrayList<RosettaModel> result = new ArrayList<RosettaModel>();
        rs.getResources().forEach(r -> result.add((RosettaModel)r.getContents().getFirst()));
        return result;
    }

    private void link(EObject obj, List<RosettaModel> context, Collection<? extends EObject> globals) {
        ExpressionResource resource = (ExpressionResource)obj.eResource();
        this.linker.setStateForNextLink(context, globals);
        ListBasedDiagnosticConsumer consumer = new ListBasedDiagnosticConsumer();
        resource.setLoading(true);
        this.linker.linkModel(obj, (IDiagnosticConsumer)consumer);
        resource.setLoading(false);
        obj.eResource().getErrors().addAll((Collection)consumer.getResult(Severity.ERROR));
        EcoreUtil2.resolveLazyCrossReferences((Resource)obj.eResource(), (CancelIndicator)CancelIndicator.NullImpl);
    }

    private static class ExpressionResource
    extends RosettaResource {
        private ExpressionResource() {
        }

        public void setLoading(boolean value) {
            this.isLoading = value;
        }
    }

    private static class RosettaStaticLinker
    extends LazyLinker {
        @Inject
        RosettaContextBasedScopeProvider scopeProvider;
        IScope staticScope = IScope.NULLSCOPE;

        private RosettaStaticLinker() {
        }

        public void setStateForNextLink(List<RosettaModel> context, Collection<? extends EObject> globals) {
            this.scopeProvider.setContext(context);
            this.staticScope = Scopes.scopeFor(globals);
        }

        private void clearState() {
            this.scopeProvider.setContext(List.of());
            this.staticScope = IScope.NULLSCOPE;
        }

        protected void doLinkModel(EObject root, IDiagnosticConsumer consumer) {
            ((DefaultLinkingService)((LazyLinkingResource)root.eResource()).getLinkingService()).setScopeProvider((IScopeProvider)this.scopeProvider);
            super.doLinkModel(root, consumer);
            EcoreUtil2.resolveAll((EObject)root);
            this.clearState();
        }

        protected void createAndSetProxy(EObject obj, INode node, EReference eRef) {
            String varName = NodeModelUtils.getTokenText((INode)node);
            IEObjectDescription staticElement = this.staticScope.getSingleElement(QualifiedName.create((String)varName));
            if (staticElement != null) {
                EObject resolved = staticElement.getEObjectOrProxy();
                if (eRef.isMany()) {
                    InternalEList list = (InternalEList)obj.eGet((EStructuralFeature)eRef, false);
                    list.addUnique((Object)resolved);
                } else {
                    obj.eSet((EStructuralFeature)eRef, (Object)resolved);
                }
            } else {
                super.createAndSetProxy(obj, node, eRef);
            }
        }
    }

    private static class RosettaContextBasedScopeProvider
    extends RosettaScopeProvider {
        List<RosettaModel> context = List.of();

        private RosettaContextBasedScopeProvider() {
        }

        public void setContext(List<RosettaModel> context) {
            this.context = context;
        }

        protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
            List base = super.getImplicitImports(ignoreCase);
            List<ImportNormalizer> extra = this.context.stream().map(RosettaModel::getName).distinct().map(ns -> this.createImportedNamespaceResolver(ns + ".*", ignoreCase)).toList();
            ArrayList<ImportNormalizer> merged = new ArrayList<ImportNormalizer>(base.size() + extra.size());
            merged.addAll(base);
            merged.addAll(extra);
            return merged;
        }
    }
}

