/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.util;

import com.google.common.collect.ImmutableMap;
import com.regnosys.rosetta.generator.RosettaGenerator;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.tests.compiler.InMemoryJavacCompiler;
import com.regnosys.rosetta.tests.util.ModelHelper;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.DottedPath;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.testing.RegisteringFileSystemAccess;

public class CodeGeneratorTestHelper {
    @Inject
    @Extension
    private RosettaGenerator _rosettaGenerator;
    @Inject
    @Extension
    private ModelHelper _modelHelper;

    public Map<String, String> generateCode(CharSequence ... models) {
        Map<String, String> _xblockexpression = null;
        Functions.Function1 _function = it -> it.eResource();
        List eResources = ListExtensions.map(this._modelHelper.parseRosettaWithNoErrors(models), (Functions.Function1)_function);
        _xblockexpression = this.generateCode(eResources);
        return _xblockexpression;
    }

    public Map<String, String> generateCode(CharSequence model) {
        Map<String, String> _xblockexpression = null;
        Resource eResource = this._modelHelper.parseRosettaWithNoErrors(model).eResource();
        _xblockexpression = this.generateCode(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Resource[]{eResource})));
        return _xblockexpression;
    }

    public Map<String, String> generateCode(List<Resource> resources) {
        RegisteringFileSystemAccess fsa = this.generateCodeWithFSA(resources);
        LinkedHashMap generatedCode = CollectionLiterals.newLinkedHashMap();
        Consumer<RegisteringFileSystemAccess.GeneratedFile> _function = it -> {
            boolean _tripleNotEquals;
            String _javaClassName = it.getJavaClassName();
            boolean bl = _tripleNotEquals = _javaClassName != null;
            if (_tripleNotEquals) {
                generatedCode.put(it.getJavaClassName(), it.getContents().toString());
            }
        };
        fsa.getGeneratedFiles().forEach(_function);
        return generatedCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteringFileSystemAccess generateCodeWithFSA(List<Resource> resources) {
        RegisteringFileSystemAccess fsa = new RegisteringFileSystemAccess();
        GeneratorContext _generatorContext = new GeneratorContext();
        Procedures.Procedure1 _function = it -> it.setCancelIndicator(CancelIndicator.NullImpl);
        GeneratorContext ctx = (GeneratorContext)ObjectExtensions.operator_doubleArrow((Object)_generatorContext, (Procedures.Procedure1)_function);
        ResourceSet resourceSet = ((Resource)IterableExtensions.head(resources)).getResourceSet();
        try {
            this._rosettaGenerator.beforeAllGenerate(resourceSet, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
            Consumer<Resource> _function_1 = it -> {
                try {
                    this._rosettaGenerator.beforeGenerate(it, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
                    this._rosettaGenerator.doGenerate(it, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
                }
                finally {
                    this._rosettaGenerator.afterGenerate(it, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
                }
            };
            resources.forEach(_function_1);
        }
        finally {
            this._rosettaGenerator.afterAllGenerate(resourceSet, (IFileSystemAccess2)fsa, (IGeneratorContext)ctx);
        }
        return fsa;
    }

    public Map<String, String> generateCode(RosettaModel model) {
        Map<String, String> _xblockexpression = null;
        Resource eResource = model.eResource();
        _xblockexpression = this.generateCode(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Resource[]{eResource})));
        return _xblockexpression;
    }

    public Map<String, Class<?>> compileToClasses(Map<String, String> code) {
        return this.inMemoryCompileToClasses(code, this.getClass().getClassLoader());
    }

    public Map<String, Class<?>> compileJava8(CharSequence model) {
        Map<String, Class<?>> _xblockexpression = null;
        Map<String, String> code = this.generateCode(model);
        _xblockexpression = this.inMemoryCompileToClasses(code, this.getClass().getClassLoader());
        return _xblockexpression;
    }

    public Enum<?> createEnumInstance(Map<String, Class<?>> classes, String className, String enumValue) {
        Class<?> _get;
        Enum<?> _xblockexpression = null;
        DottedPath _rootPackage = this._modelHelper.rootPackage();
        String _plus = String.valueOf(_rootPackage) + ".";
        String _plus_1 = _plus + className;
        Class<?> myEnumClass = _get = classes.get(_plus_1);
        Object _valueOf = Enum.valueOf(myEnumClass, enumValue);
        _xblockexpression = (Enum<?>)_valueOf;
        return _xblockexpression;
    }

    public RosettaModelObject createInstanceUsingBuilder(Map<String, Class<?>> classes, String className, Map<String, Object> itemsToSet) {
        return this.createInstanceUsingBuilder(classes, this._modelHelper.rootPackage(), className, itemsToSet);
    }

    public RosettaModelObject createInstanceUsingBuilder(Map<String, Class<?>> classes, DottedPath namespace, String className, Map<String, Object> itemsToSet) {
        return this.createInstanceUsingBuilder(classes, namespace, className, itemsToSet, (Map<String, List<?>>)ImmutableMap.of());
    }

    public RosettaModelObject createInstanceUsingBuilder(Map<String, Class<?>> classes, String className, Map<String, Object> itemsToSet, Map<String, List<?>> itemsToAddToList) {
        return this.createInstanceUsingBuilder(classes, this._modelHelper.rootPackage(), className, itemsToSet, itemsToAddToList);
    }

    public RosettaModelObjectBuilder createBuilderInstance(Map<String, Class<?>> classes, DottedPath namespace, String className) {
        try {
            String _plus = String.valueOf(namespace) + ".";
            String _plus_1 = _plus + className;
            Object _invoke = classes.get(_plus_1).getMethod("builder", new Class[0]).invoke(null, new Object[0]);
            return (RosettaModelObjectBuilder)_invoke;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RosettaModelObjectBuilder createBuilderInstance(Map<String, Class<?>> classes, String className) {
        return this.createBuilderInstance(classes, this._modelHelper.rootPackage(), className);
    }

    public Object setAttribute(RosettaModelObjectBuilder rosettaClassBuilderInstance, String name, Object value) {
        try {
            Method setter;
            Object _xblockexpression = null;
            Class _class = rosettaClassBuilderInstance.getClass();
            String _firstUpper = StringExtensions.toFirstUpper((String)name);
            String _plus = "set" + _firstUpper;
            Class<?> _class_1 = null;
            if (value != null) {
                _class_1 = value.getClass();
            }
            if ((setter = this.getMatchingMethod(_class, _plus, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{_class_1})))) == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("No method #");
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)name);
                String _plus_1 = "set" + _firstUpper_1;
                _builder.append(_plus_1);
                _builder.append("(");
                Class<?> _class_2 = null;
                if (value != null) {
                    _class_2 = value.getClass();
                }
                String _simpleName = null;
                if (_class_2 != null) {
                    _simpleName = _class_2.getSimpleName();
                }
                _builder.append(_simpleName);
                _builder.append(") in ");
                Class _class_3 = rosettaClassBuilderInstance.getClass();
                _builder.append((Object)_class_3);
                throw new RuntimeException(_builder.toString());
            }
            Class _class_4 = rosettaClassBuilderInstance.getClass();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)name);
            String _plus_2 = "set" + _firstUpper_2;
            Class<?> _class_5 = null;
            if (value != null) {
                _class_5 = value.getClass();
            }
            _xblockexpression = this.getMatchingMethod(_class_4, _plus_2, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{_class_5}))).invoke((Object)rosettaClassBuilderInstance, value);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public RosettaModelObject createInstanceUsingBuilder(Map<String, Class<?>> classes, DottedPath namespace, String className, Map<String, Object> itemsToSet, Map<String, List<?>> itemsToAddToList) {
        try {
            String _plus = String.valueOf(namespace) + ".";
            String _plus_1 = _plus + className;
            Class<?> clazz = classes.get(_plus_1);
            if (clazz == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Class ");
                String _plus_2 = String.valueOf(namespace) + ".";
                String _plus_3 = _plus_2 + className;
                _builder.append(_plus_3);
                _builder.append(" not found");
                throw new RuntimeException(_builder.toString());
            }
            RosettaModelObjectBuilder rosettaClassBuilderInstance = this.createBuilderInstance(classes, namespace, className);
            BiConsumer<String, Object> _function = (name, value) -> this.setAttribute(rosettaClassBuilderInstance, (String)name, value);
            itemsToSet.forEach(_function);
            BiConsumer<String, List> _function_1 = (name, objectsToAdd) -> {
                Consumer<Object> _function_2 = value -> {
                    try {
                        Class builderClazz = rosettaClassBuilderInstance.getClass();
                        String _firstUpper = StringExtensions.toFirstUpper((String)name);
                        String _plus_4 = "add" + _firstUpper;
                        Functions.Function1 _function_3 = it -> it.getClass();
                        Method meth = this.getMatchingMethod(builderClazz, _plus_4, ListExtensions.map(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{value})), (Functions.Function1)_function_3));
                        meth.invoke((Object)rosettaClassBuilderInstance, value);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                objectsToAdd.forEach(_function_2);
            };
            itemsToAddToList.forEach(_function_1);
            Object _invoke = rosettaClassBuilderInstance.getClass().getMethod("build", new Class[0]).invoke((Object)rosettaClassBuilderInstance, new Object[0]);
            return (RosettaModelObject)_invoke;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public FieldWithMeta<String> createFieldWithMetaString(Map<String, Class<?>> classes, String value, String scheme) {
        try {
            MetaFields.MetaFieldsBuilder metaFieldsBuilder = MetaFields.builder().setScheme(scheme);
            Object fieldWithMetaStringBuilder = classes.get("com.rosetta.model.metafields.FieldWithMetaString").getMethod("builder", new Class[0]).invoke(null, new Object[0]);
            Class<?> _class = value.getClass();
            this.getMatchingMethod(fieldWithMetaStringBuilder.getClass(), "setValue", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{_class}))).invoke(fieldWithMetaStringBuilder, value);
            this.getMatchingMethod(fieldWithMetaStringBuilder.getClass(), "setMeta", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{MetaFields.class}))).invoke(fieldWithMetaStringBuilder, metaFieldsBuilder);
            Object _invoke = fieldWithMetaStringBuilder.getClass().getMethod("build", new Class[0]).invoke(fieldWithMetaStringBuilder, new Object[0]);
            return (FieldWithMeta)_invoke;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Method getMatchingMethod(Class<?> clazz, String name, List<Class<?>> values) {
        Method meth;
        Method _xblockexpression = null;
        Functions.Function1 _function = m -> {
            String _name = m.getName();
            return Objects.equals(_name, name);
        };
        Iterable methods = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)clazz.getMethods())), (Functions.Function1)_function);
        int _xifexpression = 0;
        _xifexpression = values == null ? 0 : values.size();
        int size = _xifexpression;
        Functions.Function1 _function_1 = m -> {
            int _parameterCount = m.getParameterCount();
            return _parameterCount == size;
        };
        methods = IterableExtensions.filter((Iterable)methods, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = m -> CodeGeneratorTestHelper.paramsMatch(m, values);
        _xblockexpression = meth = (Method)IterableExtensions.findFirst((Iterable)methods, (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    public static boolean paramsMatch(Method m, List<Class<?>> value) {
        for (int i = 0; i < ((List)Conversions.doWrapArray(m.getParameterTypes())).size(); ++i) {
            Class<?> clazz = value.get(i);
            Class<?> p = m.getParameterTypes()[i];
            if (clazz == null || p.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public Map<String, String> writeClasses(Map<String, String> code, String directory) {
        try {
            Set<Map.Entry<String, String>> _entrySet = code.entrySet();
            for (Map.Entry<String, String> entry : _entrySet) {
                String name = entry.getKey();
                String pathName = name.replace(".", File.separator);
                boolean _endsWith = pathName.endsWith("Factory");
                boolean _not = !_endsWith;
                if (!_not) continue;
                Path path = Paths.get("target/" + directory + "/java", pathName + ".java");
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, entry.getValue().getBytes(), new OpenOption[0]);
            }
            return code;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Map<String, Class<?>> inMemoryCompileToClasses(Map<String, String> sources, ClassLoader scope) {
        Map<String, Class<?>> _xblockexpression = null;
        InMemoryJavacCompiler inMemoryCompiler = InMemoryJavacCompiler.newInstance().useParentClassLoader(scope).useOptions("--release", "8", "-Xlint:all", "-Xdiags:verbose");
        BiConsumer<String, String> _function = (className, sourceCode) -> inMemoryCompiler.addSource((String)className, (String)sourceCode);
        sources.forEach(_function);
        _xblockexpression = inMemoryCompiler.compileAll();
        return _xblockexpression;
    }
}

