/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.testmodel;

import com.google.common.io.CharStreams;
import com.google.inject.Injector;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.tests.testmodel.JavaTestModel;
import com.regnosys.rosetta.tests.testmodel.RosettaTestModel;
import com.regnosys.rosetta.tests.util.CodeGeneratorTestHelper;
import com.regnosys.rosetta.tests.util.ExpressionJavaEvaluatorService;
import com.regnosys.rosetta.tests.util.ExpressionParser;
import com.regnosys.rosetta.tests.util.ModelHelper;
import com.regnosys.rosetta.types.RObjectFactory;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.stream.Streams;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;

public class RosettaTestModelService {
    @Inject
    private ModelHelper modelHelper;
    @Inject
    private ValidationTestHelper validationHelper;
    @Inject
    private ExpressionParser expressionParser;
    @Inject
    private CodeGeneratorTestHelper codeGeneratorHelper;
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private JavaTypeTranslator typeTranslator;
    @Inject
    private ExpressionJavaEvaluatorService evaluatorService;
    @Inject
    private Injector injector;
    @Inject
    private IResourceDescriptionsProvider indexAccess;

    public RosettaTestModel toTestModel(CharSequence source, CharSequence ... other) {
        return this.toTestModel(source, true, other);
    }

    public RosettaTestModel toTestModel(CharSequence source, boolean assertNoIssues, CharSequence ... other) {
        CharSequence[] sources = new CharSequence[other.length + 1];
        sources[0] = source;
        System.arraycopy(other, 0, sources, 1, other.length);
        RosettaModel model = assertNoIssues ? this.modelHelper.parseRosettaWithNoIssues(sources).getFirst() : this.modelHelper.parseRosetta(sources).getFirst();
        return new RosettaTestModel(source, model, this.indexAccess, this.expressionParser);
    }

    public RosettaTestModel loadTestModelFromResources(String resourceFolderOrFile) throws IOException {
        Path resourcePath;
        ResourceSet resourceSet = this.modelHelper.testResourceSet();
        ArrayList resources = new ArrayList();
        URL resourceURL = this.getClass().getResource(resourceFolderOrFile);
        try {
            resourcePath = Path.of(resourceURL.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        (Files.isDirectory(resourcePath, new LinkOption[0]) ? Files.walk(resourcePath, 1, new FileVisitOption[0]) : Streams.of((Object[])new Path[]{resourcePath})).filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> URI.createURI((String)p.toUri().toString())).filter(uri -> uri.fileExtension().equals("rosetta")).forEach(uri -> {
            Resource res = resourceSet.getResource(uri, true);
            resources.add(res);
        });
        resources.forEach(res -> {
            EcoreUtil2.resolveAll((Resource)res);
            this.validationHelper.assertNoIssues(res);
        });
        if (resources.size() != 1) {
            throw new IllegalArgumentException("Expecting 1 rosetta file at " + resourceFolderOrFile + ", but found " + resources.size());
        }
        XtextResource resource = (XtextResource)resources.get(0);
        String source = CharStreams.toString((Readable)new InputStreamReader(resourceSet.getURIConverter().createInputStream(resource.getURI(), resourceSet.getLoadOptions()), StandardCharsets.UTF_8));
        RosettaModel model = (RosettaModel)resource.getContents().get(0);
        return new RosettaTestModel(source, model, this.indexAccess, this.expressionParser);
    }

    public JavaTestModel toJavaTestModel(CharSequence source, CharSequence ... other) {
        RosettaTestModel rosettaModel = this.toTestModel(source, other);
        Map<String, String> javaCode = this.codeGeneratorHelper.generateCode((List<Resource>)rosettaModel.getResourceSet().getResources());
        return new JavaTestModel(rosettaModel, javaCode, this.rObjectFactory, this.typeTranslator, this.evaluatorService, this.injector);
    }

    public RosettaExpression parseExpression(CharSequence expressionSource, String ... attributes) {
        return this.expressionParser.parseExpression(expressionSource, List.of(attributes));
    }

    public JavaTestModel loadJavaTestModelFromResources(String resourceFolderOrFile) throws IOException {
        RosettaTestModel rosettaModel = this.loadTestModelFromResources(resourceFolderOrFile);
        Map<String, String> javaCode = this.codeGeneratorHelper.generateCode(rosettaModel.getModel());
        return new JavaTestModel(rosettaModel, javaCode, this.rObjectFactory, this.typeTranslator, this.evaluatorService, this.injector);
    }

    public <T> T evaluateExpression(Class<T> resultType, CharSequence expr) {
        return resultType.cast(this.evaluateExpression(JavaType.from(resultType), expr));
    }

    public Object evaluateExpression(JavaType resultType, CharSequence expr) {
        return this.evaluatorService.evaluate(this.expressionParser.parseExpression(expr), resultType, this.getClass().getClassLoader());
    }
}

