/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.compiler;

import com.regnosys.rosetta.tests.compiler.CompilationException;
import com.regnosys.rosetta.tests.compiler.CompiledCode;
import com.regnosys.rosetta.tests.compiler.DynamicClassLoaderWithCompiledResources;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJavacCompiler {
    private static Logger LOGGER = LoggerFactory.getLogger(InMemoryJavacCompiler.class);
    private JavaCompiler javac;
    private DynamicClassLoaderWithCompiledResources classLoader;
    private Iterable<String> options;
    private Map<String, SourceCode> sourceCodes = new HashMap<String, SourceCode>();

    public static InMemoryJavacCompiler newInstance() {
        return new InMemoryJavacCompiler();
    }

    private InMemoryJavacCompiler() {
        this.javac = ToolProvider.getSystemJavaCompiler();
        this.classLoader = new DynamicClassLoaderWithCompiledResources(ClassLoader.getSystemClassLoader());
    }

    public InMemoryJavacCompiler useParentClassLoader(ClassLoader parent) {
        this.classLoader = new DynamicClassLoaderWithCompiledResources(parent);
        return this;
    }

    public ClassLoader getClassloader() {
        return this.classLoader;
    }

    public InMemoryJavacCompiler useOptions(String ... options) {
        this.options = Arrays.asList(options);
        return this;
    }

    public Map<String, Class<?>> compileAll() {
        if (this.sourceCodes.size() == 0) {
            return Collections.emptyMap();
        }
        Collection<SourceCode> compilationUnits = this.sourceCodes.values();
        DiagnosticCollector collector = new DiagnosticCollector();
        ExtendedStandardJavaFileManager fileManager = new ExtendedStandardJavaFileManager(this.javac.getStandardFileManager(null, null, StandardCharsets.UTF_8), this.classLoader);
        JavaCompiler.CompilationTask task = this.javac.getTask(null, fileManager, collector, this.options, null, compilationUnits);
        boolean result = task.call();
        Map<String, List<Diagnostic<? extends JavaFileObject>>> diagnosticsPerClass = collector.getDiagnostics().stream().collect(Collectors.groupingBy(d -> d.getSource() == null ? "unknown class" : ((JavaFileObject)d.getSource()).getName().substring(1).replace(".java", "").replace('/', '.')));
        diagnosticsPerClass.values().forEach(ds -> ds.sort(Comparator.comparing(Diagnostic::getKind)));
        if (!result || !diagnosticsPerClass.isEmpty()) {
            boolean hasErrors = diagnosticsPerClass.values().stream().anyMatch(ds -> ds.stream().anyMatch(d -> d.getKind() == Diagnostic.Kind.ERROR || d.getKind() == Diagnostic.Kind.OTHER));
            StringBuilder exceptionMsg = new StringBuilder();
            boolean hasWarnings = false;
            for (Map.Entry<String, List<Diagnostic>> diagnosticsOfClass : diagnosticsPerClass.entrySet()) {
                String className = diagnosticsOfClass.getKey();
                List<Diagnostic> diagnostics = diagnosticsOfClass.getValue();
                if (hasErrors && diagnostics.stream().noneMatch(d -> d.getKind() == Diagnostic.Kind.ERROR || d.getKind() == Diagnostic.Kind.OTHER)) continue;
                exceptionMsg.append("\n").append("Class ").append(className);
                int number = 0;
                block6: for (Diagnostic d2 : diagnostics) {
                    switch (d2.getKind()) {
                        case NOTE: 
                        case MANDATORY_WARNING: 
                        case WARNING: {
                            hasWarnings = true;
                            if (!hasErrors) break;
                            continue block6;
                        }
                    }
                    exceptionMsg.append("\n").append(++number).append(". ").append(d2);
                }
            }
            if (hasErrors) {
                throw new CompilationException("Java code compiled with errors:" + exceptionMsg.toString(), diagnosticsPerClass);
            }
            if (hasWarnings) {
                // empty if block
            }
        }
        HashMap classes = new HashMap();
        try {
            for (String className : this.sourceCodes.keySet()) {
                classes.put(className, this.classLoader.loadClass(className));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    public Class<?> compile(String className, String sourceCode) {
        return this.addSource(className, sourceCode).compileAll().get(className);
    }

    public InMemoryJavacCompiler addSource(String className, String sourceCode) {
        String normalizedSource = sourceCode.replace("\r\n", "\n").replace("\t", "    ");
        this.sourceCodes.put(className, new SourceCode(className, normalizedSource));
        return this;
    }

    private static class ExtendedStandardJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private DynamicClassLoaderWithCompiledResources cl;

        protected ExtendedStandardJavaFileManager(JavaFileManager fileManager, DynamicClassLoaderWithCompiledResources cl) {
            super(fileManager);
            this.cl = cl;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            try {
                CompiledCode innerClass = new CompiledCode(className);
                this.cl.addCode(innerClass);
                return innerClass;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while creating in-memory output file for " + className, e);
            }
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.cl;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof JavaFileObjectWithName) {
                return ((JavaFileObjectWithName)file).getClassName();
            }
            if (file instanceof CompiledCode) {
                return ((CompiledCode)file).getClassName();
            }
            return super.inferBinaryName(location, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            return this.find(packageName);
        }

        private List<JavaFileObject> find(String packageName) throws IOException {
            String javaPackageName = packageName.replaceAll("\\.", "/");
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            Enumeration<URL> urlEnumeration = this.cl.getResources(javaPackageName);
            while (urlEnumeration.hasMoreElements()) {
                URL packageFolderURL = urlEnumeration.nextElement();
                result.addAll(this.listUnder(packageName, packageFolderURL));
            }
            result.addAll(this.cl.getCompiledCode(packageName));
            return result;
        }

        private Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL) {
            File directory = new File(packageFolderURL.getFile());
            if (directory.isDirectory()) {
                return this.processDir(packageName, directory);
            }
            return this.processJar(packageFolderURL);
        }

        private List<JavaFileObject> processJar(URL packageFolderURL) {
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            try {
                String jarUri = packageFolderURL.toExternalForm().split("!")[0];
                JarURLConnection jarConn = (JarURLConnection)packageFolderURL.openConnection();
                String rootEntryName = jarConn.getEntryName();
                int rootEnd = rootEntryName.length() + 1;
                Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
                while (entryEnum.hasMoreElements()) {
                    JarEntry jarEntry = entryEnum.nextElement();
                    String name = jarEntry.getName();
                    if (!name.startsWith(rootEntryName) || name.indexOf(47, rootEnd) != -1 || !name.endsWith(".class")) continue;
                    URI uri = URI.create(jarUri + "!/" + name);
                    String binaryName = name.replaceAll("/", ".");
                    binaryName = binaryName.replaceAll(".class$", "");
                    result.add(new JavaFileObjectWithName(binaryName, uri));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Wasn't able to open " + String.valueOf(packageFolderURL) + " as a jar file", e);
            }
            return result;
        }

        private List<JavaFileObject> processDir(String packageName, File directory) {
            File[] childFiles;
            ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
            for (File childFile : childFiles = directory.listFiles()) {
                if (!childFile.isFile() || !childFile.getName().endsWith(".class")) continue;
                Object binaryName = packageName + "." + childFile.getName();
                binaryName = ((String)binaryName).replaceAll(".class$", "");
                result.add(new JavaFileObjectWithName((String)binaryName, childFile.toURI()));
            }
            return result;
        }
    }

    private static class SourceCode
    extends SimpleJavaFileObject {
        private String contents = null;
        private String className;

        public SourceCode(String className, String contents) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.contents = contents;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.contents;
        }
    }

    private static class JavaFileObjectWithName
    implements JavaFileObject {
        private final URI uri;
        private final String className;

        public JavaFileObjectWithName(String className, URI uri) {
            this.uri = uri;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public URI toUri() {
            return this.uri;
        }

        @Override
        public String getName() {
            return this.toUri().getPath() == null ? this.toUri().getSchemeSpecificPart() : this.toUri().getPath();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.toUri().toURL().openStream();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer buffer;
            CharSequence charContent = this.getCharContent(ignoreEncodingErrors);
            if (charContent == null) {
                throw new UnsupportedOperationException();
            }
            if (charContent instanceof CharBuffer && (buffer = (CharBuffer)charContent).hasArray()) {
                return new CharArrayReader(buffer.array());
            }
            return new StringReader(charContent.toString());
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() throws IOException {
            return new OutputStreamWriter(this.openOutputStream());
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean delete() {
            return false;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return JavaFileObject.Kind.CLASS;
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            String baseName = simpleName + kind.extension;
            return kind.equals((Object)this.getKind()) && (baseName.equals(this.toUri().getPath()) || this.toUri().getPath().endsWith("/" + baseName));
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "[" + String.valueOf(this.toUri()) + "]";
        }
    }
}

