/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.compiler;

import com.regnosys.rosetta.tests.compiler.CompiledCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DynamicClassLoaderWithCompiledResources
extends ClassLoader {
    private final ClassLoader parent;
    private final Map<String, CompiledCode> customCompiledCode = new HashMap<String, CompiledCode>();

    public DynamicClassLoaderWithCompiledResources(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    public void addCode(CompiledCode cc) {
        this.customCompiledCode.put(cc.getName(), cc);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        CompiledCode cc = this.customCompiledCode.get(name);
        if (cc == null) {
            return super.findClass(name);
        }
        byte[] byteCode = cc.getByteCode();
        return this.defineClass(name, byteCode, 0, byteCode.length);
    }

    public List<CompiledCode> getCompiledCode(String packageName) {
        ArrayList<CompiledCode> result = new ArrayList<CompiledCode>();
        if (this.parent instanceof DynamicClassLoaderWithCompiledResources) {
            result.addAll(((DynamicClassLoaderWithCompiledResources)this.parent).getCompiledCode(packageName));
        }
        result.addAll(this.customCompiledCode.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(packageName)).map(e -> (CompiledCode)e.getValue()).collect(Collectors.toList()));
        return result;
    }
}

