/*
 * Decompiled with CFR 0.152.
 */
package fpml.custom.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.shared.Product;
import fpml.custom.ProductChoice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ToProductChoiceDefault.class)
public abstract class ToProductChoice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ProductChoice evaluate(Product product) {
        ProductChoice productChoice;
        ProductChoice.ProductChoiceBuilder productChoiceBuilder = this.doEvaluate(product);
        if (productChoiceBuilder == null) {
            productChoice = null;
        } else {
            productChoice = productChoiceBuilder.build();
            this.objectValidator.validate(ProductChoice.class, (RosettaModelObject)productChoice);
        }
        return productChoice;
    }

    protected abstract ProductChoice.ProductChoiceBuilder doEvaluate(Product var1);

    public static class ToProductChoiceDefault
    extends ToProductChoice {
        @Override
        protected ProductChoice.ProductChoiceBuilder doEvaluate(Product product) {
            ProductChoice.ProductChoiceBuilder productChoice = ProductChoice.builder();
            return this.assignOutput(productChoice, product);
        }

        protected ProductChoice.ProductChoiceBuilder assignOutput(ProductChoice.ProductChoiceBuilder productChoice, Product product) {
            return Optional.ofNullable(productChoice).map(o -> o.prune()).orElse(null);
        }
    }
}

