/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.valuation.ValuationSet;
import fpml.consolidated.valuation.fpmlreporting.Portfolio;
import fpml.consolidated.valuation.fpmlreporting.TradeValuationItem;
import fpml.consolidated.valuation.fpmlreporting.meta.PortfolioValuationItemMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PortfolioValuationItem", builder=PortfolioValuationItemBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PortfolioValuationItem", model="fpml", builder=PortfolioValuationItemBuilderImpl.class, version="1.1.0")
public interface PortfolioValuationItem
extends RosettaModelObject {
    public static final PortfolioValuationItemMeta metaData = new PortfolioValuationItemMeta();

    public Portfolio getPortfolio();

    public List<? extends TradeValuationItem> getTradeValuationItem();

    public ValuationSet getValuationSet();

    public PortfolioValuationItem build();

    public PortfolioValuationItemBuilder toBuilder();

    public static PortfolioValuationItemBuilder builder() {
        return new PortfolioValuationItemBuilderImpl();
    }

    default public RosettaMetaData<? extends PortfolioValuationItem> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PortfolioValuationItem> getType() {
        return PortfolioValuationItem.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.class, this.getPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeValuationItem"), processor, TradeValuationItem.class, this.getTradeValuationItem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationSet"), processor, ValuationSet.class, this.getValuationSet(), new AttributeMeta[0]);
    }

    public static class PortfolioValuationItemBuilderImpl
    implements PortfolioValuationItemBuilder {
        protected Portfolio.PortfolioBuilder portfolio;
        protected List<TradeValuationItem.TradeValuationItemBuilder> tradeValuationItem = new ArrayList<TradeValuationItem.TradeValuationItemBuilder>();
        protected ValuationSet.ValuationSetBuilder valuationSet;

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public Portfolio.PortfolioBuilder getPortfolio() {
            return this.portfolio;
        }

        @Override
        public Portfolio.PortfolioBuilder getOrCreatePortfolio() {
            Portfolio.PortfolioBuilder result = this.portfolio != null ? this.portfolio : (this.portfolio = Portfolio.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeValuationItem")
        @RuneAttribute(value="tradeValuationItem")
        public List<? extends TradeValuationItem.TradeValuationItemBuilder> getTradeValuationItem() {
            return this.tradeValuationItem;
        }

        @Override
        public TradeValuationItem.TradeValuationItemBuilder getOrCreateTradeValuationItem(int index) {
            if (this.tradeValuationItem == null) {
                this.tradeValuationItem = new ArrayList<TradeValuationItem.TradeValuationItemBuilder>();
            }
            return (TradeValuationItem.TradeValuationItemBuilder)this.getIndex(this.tradeValuationItem, index, () -> {
                TradeValuationItem.TradeValuationItemBuilder newTradeValuationItem = TradeValuationItem.builder();
                return newTradeValuationItem;
            });
        }

        @Override
        @RosettaAttribute(value="valuationSet")
        @RuneAttribute(value="valuationSet")
        public ValuationSet.ValuationSetBuilder getValuationSet() {
            return this.valuationSet;
        }

        @Override
        public ValuationSet.ValuationSetBuilder getOrCreateValuationSet() {
            ValuationSet.ValuationSetBuilder result = this.valuationSet != null ? this.valuationSet : (this.valuationSet = ValuationSet.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public PortfolioValuationItemBuilder setPortfolio(Portfolio _portfolio) {
            this.portfolio = _portfolio == null ? null : _portfolio.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeValuationItem")
        @RuneAttribute(value="tradeValuationItem")
        public PortfolioValuationItemBuilder addTradeValuationItem(TradeValuationItem _tradeValuationItem) {
            if (_tradeValuationItem != null) {
                this.tradeValuationItem.add(_tradeValuationItem.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioValuationItemBuilder addTradeValuationItem(TradeValuationItem _tradeValuationItem, int idx) {
            this.getIndex(this.tradeValuationItem, idx, () -> _tradeValuationItem.toBuilder());
            return this;
        }

        @Override
        public PortfolioValuationItemBuilder addTradeValuationItem(List<? extends TradeValuationItem> tradeValuationItems) {
            if (tradeValuationItems != null) {
                for (TradeValuationItem tradeValuationItem : tradeValuationItems) {
                    this.tradeValuationItem.add(tradeValuationItem.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeValuationItem")
        public PortfolioValuationItemBuilder setTradeValuationItem(List<? extends TradeValuationItem> tradeValuationItems) {
            this.tradeValuationItem = tradeValuationItems == null ? new ArrayList<TradeValuationItem.TradeValuationItemBuilder>() : (List)tradeValuationItems.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationSet")
        @RuneAttribute(value="valuationSet")
        public PortfolioValuationItemBuilder setValuationSet(ValuationSet _valuationSet) {
            this.valuationSet = _valuationSet == null ? null : _valuationSet.toBuilder();
            return this;
        }

        @Override
        public PortfolioValuationItem build() {
            return new PortfolioValuationItemImpl(this);
        }

        @Override
        public PortfolioValuationItemBuilder toBuilder() {
            return this;
        }

        @Override
        public PortfolioValuationItemBuilder prune() {
            if (this.portfolio != null && !this.portfolio.prune().hasData()) {
                this.portfolio = null;
            }
            this.tradeValuationItem = this.tradeValuationItem.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.valuationSet != null && !this.valuationSet.prune().hasData()) {
                this.valuationSet = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPortfolio() != null && this.getPortfolio().hasData()) {
                return true;
            }
            if (this.getTradeValuationItem() != null && this.getTradeValuationItem().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getValuationSet() != null && this.getValuationSet().hasData();
        }

        public PortfolioValuationItemBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PortfolioValuationItemBuilder o = (PortfolioValuationItemBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolio(), (RosettaModelObjectBuilder)o.getPortfolio(), this::setPortfolio);
            merger.mergeRosetta(this.getTradeValuationItem(), o.getTradeValuationItem(), this::getOrCreateTradeValuationItem);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationSet(), (RosettaModelObjectBuilder)o.getValuationSet(), this::setValuationSet);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PortfolioValuationItem _that = this.getType().cast(o);
            if (!Objects.equals(this.portfolio, _that.getPortfolio())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeValuationItem, _that.getTradeValuationItem())) {
                return false;
            }
            return Objects.equals(this.valuationSet, _that.getValuationSet());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.portfolio != null ? this.portfolio.hashCode() : 0);
            _result = 31 * _result + (this.tradeValuationItem != null ? this.tradeValuationItem.hashCode() : 0);
            _result = 31 * _result + (this.valuationSet != null ? this.valuationSet.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PortfolioValuationItemBuilder {portfolio=" + this.portfolio + ", tradeValuationItem=" + this.tradeValuationItem + ", valuationSet=" + this.valuationSet + '}';
        }
    }

    public static interface PortfolioValuationItemBuilder
    extends PortfolioValuationItem,
    RosettaModelObjectBuilder {
        public Portfolio.PortfolioBuilder getOrCreatePortfolio();

        @Override
        public Portfolio.PortfolioBuilder getPortfolio();

        public TradeValuationItem.TradeValuationItemBuilder getOrCreateTradeValuationItem(int var1);

        public List<? extends TradeValuationItem.TradeValuationItemBuilder> getTradeValuationItem();

        public ValuationSet.ValuationSetBuilder getOrCreateValuationSet();

        @Override
        public ValuationSet.ValuationSetBuilder getValuationSet();

        public PortfolioValuationItemBuilder setPortfolio(Portfolio var1);

        public PortfolioValuationItemBuilder addTradeValuationItem(TradeValuationItem var1);

        public PortfolioValuationItemBuilder addTradeValuationItem(TradeValuationItem var1, int var2);

        public PortfolioValuationItemBuilder addTradeValuationItem(List<? extends TradeValuationItem> var1);

        public PortfolioValuationItemBuilder setTradeValuationItem(List<? extends TradeValuationItem> var1);

        public PortfolioValuationItemBuilder setValuationSet(ValuationSet var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.PortfolioBuilder.class, this.getPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeValuationItem"), processor, TradeValuationItem.TradeValuationItemBuilder.class, this.getTradeValuationItem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationSet"), processor, ValuationSet.ValuationSetBuilder.class, this.getValuationSet(), new AttributeMeta[0]);
        }

        public PortfolioValuationItemBuilder prune();
    }

    public static class PortfolioValuationItemImpl
    implements PortfolioValuationItem {
        private final Portfolio portfolio;
        private final List<? extends TradeValuationItem> tradeValuationItem;
        private final ValuationSet valuationSet;

        protected PortfolioValuationItemImpl(PortfolioValuationItemBuilder builder) {
            this.portfolio = Optional.ofNullable(builder.getPortfolio()).map(f -> f.build()).orElse(null);
            this.tradeValuationItem = Optional.ofNullable(builder.getTradeValuationItem()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.valuationSet = Optional.ofNullable(builder.getValuationSet()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public Portfolio getPortfolio() {
            return this.portfolio;
        }

        @Override
        @RosettaAttribute(value="tradeValuationItem")
        @RuneAttribute(value="tradeValuationItem")
        public List<? extends TradeValuationItem> getTradeValuationItem() {
            return this.tradeValuationItem;
        }

        @Override
        @RosettaAttribute(value="valuationSet")
        @RuneAttribute(value="valuationSet")
        public ValuationSet getValuationSet() {
            return this.valuationSet;
        }

        @Override
        public PortfolioValuationItem build() {
            return this;
        }

        @Override
        public PortfolioValuationItemBuilder toBuilder() {
            PortfolioValuationItemBuilder builder = PortfolioValuationItem.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PortfolioValuationItemBuilder builder) {
            Optional.ofNullable(this.getPortfolio()).ifPresent(builder::setPortfolio);
            Optional.ofNullable(this.getTradeValuationItem()).ifPresent(builder::setTradeValuationItem);
            Optional.ofNullable(this.getValuationSet()).ifPresent(builder::setValuationSet);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PortfolioValuationItem _that = this.getType().cast(o);
            if (!Objects.equals(this.portfolio, _that.getPortfolio())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeValuationItem, _that.getTradeValuationItem())) {
                return false;
            }
            return Objects.equals(this.valuationSet, _that.getValuationSet());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.portfolio != null ? this.portfolio.hashCode() : 0);
            _result = 31 * _result + (this.tradeValuationItem != null ? this.tradeValuationItem.hashCode() : 0);
            _result = 31 * _result + (this.valuationSet != null ? this.valuationSet.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PortfolioValuationItem {portfolio=" + this.portfolio + ", tradeValuationItem=" + this.tradeValuationItem + ", valuationSet=" + this.valuationSet + '}';
        }
    }
}

