/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import fpml.consolidated.X509DataType;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class X509DataTypeOnlyExistsValidator
implements ValidatorWithArg<X509DataType, Set<String>> {
    public <T2 extends X509DataType> ValidationResult<X509DataType> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"x509DataTypeSequence", (Object)ExistenceChecker.isSet(o.getX509DataTypeSequence())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"X509DataType", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"X509DataType", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"X509DataType", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"X509DataType", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

