/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.SignatureMethodType;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SignatureMethodTypeTypeFormatValidator
implements Validator<SignatureMethodType> {
    private List<ComparisonResult> getComparisonResults(SignatureMethodType o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkNumber((String)"hmacOutputLength", (Integer)o.getHmacOutputLength(), Optional.empty(), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"algorithm", (String)o.getAlgorithm(), (int)0, Optional.empty(), Optional.of(Pattern.compile("\\w+:(\\/?\\/?)[^\\s]+")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, SignatureMethodType o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"SignatureMethodType", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"SignatureMethodType", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"SignatureMethodType", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"SignatureMethodType", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

