/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.LegalEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegalEntityChoice")
@ImplementedBy(value=Default.class)
public interface LegalEntityChoice
extends Validator<LegalEntity> {
    public static final String NAME = "LegalEntityChoice";
    public static final String DEFINITION = "required choice legalEntitySequence, entityId";

    public static class NoOp
    implements LegalEntityChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalEntity legalEntity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegalEntityChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegalEntity legalEntity) {
            ComparisonResult result = this.executeDataRule(legalEntity);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegalEntityChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalEntity", (RosettaPath)path, (String)LegalEntityChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegalEntityChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalEntity", (RosettaPath)path, (String)LegalEntityChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegalEntity legalEntity) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)legalEntity), Arrays.asList("legalEntitySequence", "entityId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

