/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.meta.StreetAddressMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="StreetAddress", builder=StreetAddressBuilderImpl.class, version="1.1.0")
@RuneDataType(value="StreetAddress", model="fpml", builder=StreetAddressBuilderImpl.class, version="1.1.0")
public interface StreetAddress
extends RosettaModelObject {
    public static final StreetAddressMeta metaData = new StreetAddressMeta();

    public List<String> getStreetLine();

    public StreetAddress build();

    public StreetAddressBuilder toBuilder();

    public static StreetAddressBuilder builder() {
        return new StreetAddressBuilderImpl();
    }

    default public RosettaMetaData<? extends StreetAddress> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StreetAddress> getType() {
        return StreetAddress.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("streetLine"), String.class, this.getStreetLine(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class StreetAddressBuilderImpl
    implements StreetAddressBuilder {
        protected List<String> streetLine = new ArrayList<String>();

        @Override
        @RosettaAttribute(value="streetLine")
        @RuneAttribute(value="streetLine")
        public List<String> getStreetLine() {
            return this.streetLine;
        }

        @Override
        @RosettaAttribute(value="streetLine")
        @RuneAttribute(value="streetLine")
        public StreetAddressBuilder addStreetLine(String _streetLine) {
            if (_streetLine != null) {
                this.streetLine.add(_streetLine);
            }
            return this;
        }

        @Override
        public StreetAddressBuilder addStreetLine(String _streetLine, int idx) {
            this.getIndex(this.streetLine, idx, () -> _streetLine);
            return this;
        }

        @Override
        public StreetAddressBuilder addStreetLine(List<String> streetLines) {
            if (streetLines != null) {
                for (String toAdd : streetLines) {
                    this.streetLine.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="streetLine")
        public StreetAddressBuilder setStreetLine(List<String> streetLines) {
            this.streetLine = streetLines == null ? new ArrayList<String>() : (List)streetLines.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public StreetAddress build() {
            return new StreetAddressImpl(this);
        }

        @Override
        public StreetAddressBuilder toBuilder() {
            return this;
        }

        @Override
        public StreetAddressBuilder prune() {
            return this;
        }

        public boolean hasData() {
            return this.getStreetLine() != null && !this.getStreetLine().isEmpty();
        }

        public StreetAddressBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StreetAddressBuilder o = (StreetAddressBuilder)other;
            merger.mergeBasic(this.getStreetLine(), o.getStreetLine(), this::addStreetLine);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StreetAddress _that = this.getType().cast(o);
            return ListEquals.listEquals(this.streetLine, _that.getStreetLine());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.streetLine != null ? this.streetLine.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StreetAddressBuilder {streetLine=" + this.streetLine + '}';
        }
    }

    public static interface StreetAddressBuilder
    extends StreetAddress,
    RosettaModelObjectBuilder {
        public StreetAddressBuilder addStreetLine(String var1);

        public StreetAddressBuilder addStreetLine(String var1, int var2);

        public StreetAddressBuilder addStreetLine(List<String> var1);

        public StreetAddressBuilder setStreetLine(List<String> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("streetLine"), String.class, this.getStreetLine(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public StreetAddressBuilder prune();
    }

    public static class StreetAddressImpl
    implements StreetAddress {
        private final List<String> streetLine;

        protected StreetAddressImpl(StreetAddressBuilder builder) {
            this.streetLine = Optional.ofNullable(builder.getStreetLine()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="streetLine")
        @RuneAttribute(value="streetLine")
        public List<String> getStreetLine() {
            return this.streetLine;
        }

        @Override
        public StreetAddress build() {
            return this;
        }

        @Override
        public StreetAddressBuilder toBuilder() {
            StreetAddressBuilder builder = StreetAddress.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StreetAddressBuilder builder) {
            Optional.ofNullable(this.getStreetLine()).ifPresent(builder::setStreetLine);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StreetAddress _that = this.getType().cast(o);
            return ListEquals.listEquals(this.streetLine, _that.getStreetLine());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.streetLine != null ? this.streetLine.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StreetAddress {streetLine=" + this.streetLine + '}';
        }
    }
}

