/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.meta.PricingStructureMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PricingStructure", builder=PricingStructureBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PricingStructure", model="fpml", builder=PricingStructureBuilderImpl.class, version="1.1.0")
public interface PricingStructure
extends RosettaModelObject {
    public static final PricingStructureMeta metaData = new PricingStructureMeta();

    public String getName();

    public Currency getCurrency();

    public String getId();

    public PricingStructure build();

    public PricingStructureBuilder toBuilder();

    public static PricingStructureBuilder builder() {
        return new PricingStructureBuilderImpl();
    }

    default public RosettaMetaData<? extends PricingStructure> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PricingStructure> getType() {
        return PricingStructure.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PricingStructureBuilderImpl
    implements PricingStructureBuilder {
        protected String name;
        protected Currency.CurrencyBuilder currency;
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public PricingStructureBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public PricingStructureBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PricingStructureBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public PricingStructure build() {
            return new PricingStructureImpl(this);
        }

        @Override
        public PricingStructureBuilder toBuilder() {
            return this;
        }

        @Override
        public PricingStructureBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public PricingStructureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PricingStructureBuilder o = (PricingStructureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricingStructure _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricingStructureBuilder {name=" + this.name + ", currency=" + this.currency + ", id=" + this.id + '}';
        }
    }

    public static interface PricingStructureBuilder
    extends PricingStructure,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public PricingStructureBuilder setName(String var1);

        public PricingStructureBuilder setCurrency(Currency var1);

        public PricingStructureBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PricingStructureBuilder prune();
    }

    public static class PricingStructureImpl
    implements PricingStructure {
        private final String name;
        private final Currency currency;
        private final String id;

        protected PricingStructureImpl(PricingStructureBuilder builder) {
            this.name = builder.getName();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public PricingStructure build() {
            return this;
        }

        @Override
        public PricingStructureBuilder toBuilder() {
            PricingStructureBuilder builder = PricingStructure.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PricingStructureBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricingStructure _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricingStructure {name=" + this.name + ", currency=" + this.currency + ", id=" + this.id + '}';
        }
    }
}

