/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.FormulaComponent;
import fpml.consolidated.shared.Math;
import fpml.consolidated.shared.meta.FormulaMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Formula", builder=FormulaBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Formula", model="fpml", builder=FormulaBuilderImpl.class, version="1.1.0")
public interface Formula
extends RosettaModelObject {
    public static final FormulaMeta metaData = new FormulaMeta();

    public String getFormulaDescription();

    public Math getMath();

    public List<? extends FormulaComponent> getFormulaComponent();

    public Formula build();

    public FormulaBuilder toBuilder();

    public static FormulaBuilder builder() {
        return new FormulaBuilderImpl();
    }

    default public RosettaMetaData<? extends Formula> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Formula> getType() {
        return Formula.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("formulaDescription"), String.class, (Object)this.getFormulaDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("math"), processor, Math.class, this.getMath(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("formulaComponent"), processor, FormulaComponent.class, this.getFormulaComponent(), new AttributeMeta[0]);
    }

    public static class FormulaBuilderImpl
    implements FormulaBuilder {
        protected String formulaDescription;
        protected Math.MathBuilder math;
        protected List<FormulaComponent.FormulaComponentBuilder> formulaComponent = new ArrayList<FormulaComponent.FormulaComponentBuilder>();

        @Override
        @RosettaAttribute(value="formulaDescription")
        @RuneAttribute(value="formulaDescription")
        public String getFormulaDescription() {
            return this.formulaDescription;
        }

        @Override
        @RosettaAttribute(value="math")
        @RuneAttribute(value="math")
        public Math.MathBuilder getMath() {
            return this.math;
        }

        @Override
        public Math.MathBuilder getOrCreateMath() {
            Math.MathBuilder result = this.math != null ? this.math : (this.math = Math.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="formulaComponent")
        @RuneAttribute(value="formulaComponent")
        public List<? extends FormulaComponent.FormulaComponentBuilder> getFormulaComponent() {
            return this.formulaComponent;
        }

        @Override
        public FormulaComponent.FormulaComponentBuilder getOrCreateFormulaComponent(int index) {
            if (this.formulaComponent == null) {
                this.formulaComponent = new ArrayList<FormulaComponent.FormulaComponentBuilder>();
            }
            return (FormulaComponent.FormulaComponentBuilder)this.getIndex(this.formulaComponent, index, () -> {
                FormulaComponent.FormulaComponentBuilder newFormulaComponent = FormulaComponent.builder();
                return newFormulaComponent;
            });
        }

        @Override
        @RosettaAttribute(value="formulaDescription")
        @RuneAttribute(value="formulaDescription")
        public FormulaBuilder setFormulaDescription(String _formulaDescription) {
            this.formulaDescription = _formulaDescription == null ? null : _formulaDescription;
            return this;
        }

        @Override
        @RosettaAttribute(value="math")
        @RuneAttribute(value="math")
        public FormulaBuilder setMath(Math _math) {
            this.math = _math == null ? null : _math.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="formulaComponent")
        @RuneAttribute(value="formulaComponent")
        public FormulaBuilder addFormulaComponent(FormulaComponent _formulaComponent) {
            if (_formulaComponent != null) {
                this.formulaComponent.add(_formulaComponent.toBuilder());
            }
            return this;
        }

        @Override
        public FormulaBuilder addFormulaComponent(FormulaComponent _formulaComponent, int idx) {
            this.getIndex(this.formulaComponent, idx, () -> _formulaComponent.toBuilder());
            return this;
        }

        @Override
        public FormulaBuilder addFormulaComponent(List<? extends FormulaComponent> formulaComponents) {
            if (formulaComponents != null) {
                for (FormulaComponent formulaComponent : formulaComponents) {
                    this.formulaComponent.add(formulaComponent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="formulaComponent")
        public FormulaBuilder setFormulaComponent(List<? extends FormulaComponent> formulaComponents) {
            this.formulaComponent = formulaComponents == null ? new ArrayList<FormulaComponent.FormulaComponentBuilder>() : (List)formulaComponents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Formula build() {
            return new FormulaImpl(this);
        }

        @Override
        public FormulaBuilder toBuilder() {
            return this;
        }

        @Override
        public FormulaBuilder prune() {
            if (this.math != null && !this.math.prune().hasData()) {
                this.math = null;
            }
            this.formulaComponent = this.formulaComponent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFormulaDescription() != null) {
                return true;
            }
            if (this.getMath() != null && this.getMath().hasData()) {
                return true;
            }
            return this.getFormulaComponent() != null && this.getFormulaComponent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FormulaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FormulaBuilder o = (FormulaBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMath(), (RosettaModelObjectBuilder)o.getMath(), this::setMath);
            merger.mergeRosetta(this.getFormulaComponent(), o.getFormulaComponent(), this::getOrCreateFormulaComponent);
            merger.mergeBasic((Object)this.getFormulaDescription(), (Object)o.getFormulaDescription(), this::setFormulaDescription, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Formula _that = this.getType().cast(o);
            if (!Objects.equals(this.formulaDescription, _that.getFormulaDescription())) {
                return false;
            }
            if (!Objects.equals(this.math, _that.getMath())) {
                return false;
            }
            return ListEquals.listEquals(this.formulaComponent, _that.getFormulaComponent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.formulaDescription != null ? this.formulaDescription.hashCode() : 0);
            _result = 31 * _result + (this.math != null ? this.math.hashCode() : 0);
            _result = 31 * _result + (this.formulaComponent != null ? this.formulaComponent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FormulaBuilder {formulaDescription=" + this.formulaDescription + ", math=" + this.math + ", formulaComponent=" + this.formulaComponent + '}';
        }
    }

    public static interface FormulaBuilder
    extends Formula,
    RosettaModelObjectBuilder {
        public Math.MathBuilder getOrCreateMath();

        @Override
        public Math.MathBuilder getMath();

        public FormulaComponent.FormulaComponentBuilder getOrCreateFormulaComponent(int var1);

        public List<? extends FormulaComponent.FormulaComponentBuilder> getFormulaComponent();

        public FormulaBuilder setFormulaDescription(String var1);

        public FormulaBuilder setMath(Math var1);

        public FormulaBuilder addFormulaComponent(FormulaComponent var1);

        public FormulaBuilder addFormulaComponent(FormulaComponent var1, int var2);

        public FormulaBuilder addFormulaComponent(List<? extends FormulaComponent> var1);

        public FormulaBuilder setFormulaComponent(List<? extends FormulaComponent> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("formulaDescription"), String.class, (Object)this.getFormulaDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("math"), processor, Math.MathBuilder.class, this.getMath(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("formulaComponent"), processor, FormulaComponent.FormulaComponentBuilder.class, this.getFormulaComponent(), new AttributeMeta[0]);
        }

        public FormulaBuilder prune();
    }

    public static class FormulaImpl
    implements Formula {
        private final String formulaDescription;
        private final Math math;
        private final List<? extends FormulaComponent> formulaComponent;

        protected FormulaImpl(FormulaBuilder builder) {
            this.formulaDescription = builder.getFormulaDescription();
            this.math = Optional.ofNullable(builder.getMath()).map(f -> f.build()).orElse(null);
            this.formulaComponent = Optional.ofNullable(builder.getFormulaComponent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="formulaDescription")
        @RuneAttribute(value="formulaDescription")
        public String getFormulaDescription() {
            return this.formulaDescription;
        }

        @Override
        @RosettaAttribute(value="math")
        @RuneAttribute(value="math")
        public Math getMath() {
            return this.math;
        }

        @Override
        @RosettaAttribute(value="formulaComponent")
        @RuneAttribute(value="formulaComponent")
        public List<? extends FormulaComponent> getFormulaComponent() {
            return this.formulaComponent;
        }

        @Override
        public Formula build() {
            return this;
        }

        @Override
        public FormulaBuilder toBuilder() {
            FormulaBuilder builder = Formula.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FormulaBuilder builder) {
            Optional.ofNullable(this.getFormulaDescription()).ifPresent(builder::setFormulaDescription);
            Optional.ofNullable(this.getMath()).ifPresent(builder::setMath);
            Optional.ofNullable(this.getFormulaComponent()).ifPresent(builder::setFormulaComponent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Formula _that = this.getType().cast(o);
            if (!Objects.equals(this.formulaDescription, _that.getFormulaDescription())) {
                return false;
            }
            if (!Objects.equals(this.math, _that.getMath())) {
                return false;
            }
            return ListEquals.listEquals(this.formulaComponent, _that.getFormulaComponent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.formulaDescription != null ? this.formulaDescription.hashCode() : 0);
            _result = 31 * _result + (this.math != null ? this.math.hashCode() : 0);
            _result = 31 * _result + (this.formulaComponent != null ? this.formulaComponent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Formula {formulaDescription=" + this.formulaDescription + ", math=" + this.math + ", formulaComponent=" + this.formulaComponent + '}';
        }
    }
}

