/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.AdjustableOrRelativeDates;
import fpml.consolidated.shared.BusinessCenterTime;
import fpml.consolidated.shared.Exercise;
import fpml.consolidated.shared.ExerciseFee;
import fpml.consolidated.shared.PartialExercise;
import fpml.consolidated.shared.meta.EuropeanExerciseMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EuropeanExercise", builder=EuropeanExerciseBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EuropeanExercise", model="fpml", builder=EuropeanExerciseBuilderImpl.class, version="1.1.0")
public interface EuropeanExercise
extends Exercise {
    public static final EuropeanExerciseMeta metaData = new EuropeanExerciseMeta();

    public AdjustableOrRelativeDate getExpirationDate();

    public AdjustableOrRelativeDates getRelevantUnderlyingDate();

    public BusinessCenterTime getEarliestExerciseTime();

    public BusinessCenterTime getExpirationTime();

    public PartialExercise getPartialExercise();

    public ExerciseFee getExerciseFee();

    @Override
    public EuropeanExercise build();

    @Override
    public EuropeanExerciseBuilder toBuilder();

    public static EuropeanExerciseBuilder builder() {
        return new EuropeanExerciseBuilderImpl();
    }

    default public RosettaMetaData<? extends EuropeanExercise> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EuropeanExercise> getType() {
        return EuropeanExercise.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.class, this.getExpirationTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.class, this.getPartialExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.class, this.getExerciseFee(), new AttributeMeta[0]);
    }

    public static class EuropeanExerciseBuilderImpl
    extends Exercise.ExerciseBuilderImpl
    implements EuropeanExerciseBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder expirationDate;
        protected AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder relevantUnderlyingDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder earliestExerciseTime;
        protected BusinessCenterTime.BusinessCenterTimeBuilder expirationTime;
        protected PartialExercise.PartialExerciseBuilder partialExercise;
        protected ExerciseFee.ExerciseFeeBuilder exerciseFee;

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.expirationDate != null ? this.expirationDate : (this.expirationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate() {
            AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder result = this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate : (this.relevantUnderlyingDate = AdjustableOrRelativeDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.earliestExerciseTime != null ? this.earliestExerciseTime : (this.earliestExerciseTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.expirationTime != null ? this.expirationTime : (this.expirationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public PartialExercise.PartialExerciseBuilder getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise() {
            PartialExercise.PartialExerciseBuilder result = this.partialExercise != null ? this.partialExercise : (this.partialExercise = PartialExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee() {
            ExerciseFee.ExerciseFeeBuilder result = this.exerciseFee != null ? this.exerciseFee : (this.exerciseFee = ExerciseFee.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EuropeanExerciseBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public EuropeanExerciseBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public EuropeanExerciseBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates _relevantUnderlyingDate) {
            this.relevantUnderlyingDate = _relevantUnderlyingDate == null ? null : _relevantUnderlyingDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public EuropeanExerciseBuilder setEarliestExerciseTime(BusinessCenterTime _earliestExerciseTime) {
            this.earliestExerciseTime = _earliestExerciseTime == null ? null : _earliestExerciseTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public EuropeanExerciseBuilder setExpirationTime(BusinessCenterTime _expirationTime) {
            this.expirationTime = _expirationTime == null ? null : _expirationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public EuropeanExerciseBuilder setPartialExercise(PartialExercise _partialExercise) {
            this.partialExercise = _partialExercise == null ? null : _partialExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public EuropeanExerciseBuilder setExerciseFee(ExerciseFee _exerciseFee) {
            this.exerciseFee = _exerciseFee == null ? null : _exerciseFee.toBuilder();
            return this;
        }

        @Override
        public EuropeanExercise build() {
            return new EuropeanExerciseImpl(this);
        }

        @Override
        public EuropeanExerciseBuilder toBuilder() {
            return this;
        }

        @Override
        public EuropeanExerciseBuilder prune() {
            super.prune();
            if (this.expirationDate != null && !this.expirationDate.prune().hasData()) {
                this.expirationDate = null;
            }
            if (this.relevantUnderlyingDate != null && !this.relevantUnderlyingDate.prune().hasData()) {
                this.relevantUnderlyingDate = null;
            }
            if (this.earliestExerciseTime != null && !this.earliestExerciseTime.prune().hasData()) {
                this.earliestExerciseTime = null;
            }
            if (this.expirationTime != null && !this.expirationTime.prune().hasData()) {
                this.expirationTime = null;
            }
            if (this.partialExercise != null && !this.partialExercise.prune().hasData()) {
                this.partialExercise = null;
            }
            if (this.exerciseFee != null && !this.exerciseFee.prune().hasData()) {
                this.exerciseFee = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExpirationDate() != null && this.getExpirationDate().hasData()) {
                return true;
            }
            if (this.getRelevantUnderlyingDate() != null && this.getRelevantUnderlyingDate().hasData()) {
                return true;
            }
            if (this.getEarliestExerciseTime() != null && this.getEarliestExerciseTime().hasData()) {
                return true;
            }
            if (this.getExpirationTime() != null && this.getExpirationTime().hasData()) {
                return true;
            }
            if (this.getPartialExercise() != null && this.getPartialExercise().hasData()) {
                return true;
            }
            return this.getExerciseFee() != null && this.getExerciseFee().hasData();
        }

        @Override
        public EuropeanExerciseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EuropeanExerciseBuilder o = (EuropeanExerciseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationDate(), (RosettaModelObjectBuilder)o.getExpirationDate(), this::setExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRelevantUnderlyingDate(), (RosettaModelObjectBuilder)o.getRelevantUnderlyingDate(), this::setRelevantUnderlyingDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestExerciseTime(), (RosettaModelObjectBuilder)o.getEarliestExerciseTime(), this::setEarliestExerciseTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationTime(), (RosettaModelObjectBuilder)o.getExpirationTime(), this::setExpirationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartialExercise(), (RosettaModelObjectBuilder)o.getPartialExercise(), this::setPartialExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFee(), (RosettaModelObjectBuilder)o.getExerciseFee(), this::setExerciseFee);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EuropeanExercise _that = (EuropeanExercise)this.getType().cast(o);
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate())) {
                return false;
            }
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            return Objects.equals(this.exerciseFee, _that.getExerciseFee());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EuropeanExerciseBuilder {expirationDate=" + this.expirationDate + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + ", earliestExerciseTime=" + this.earliestExerciseTime + ", expirationTime=" + this.expirationTime + ", partialExercise=" + this.partialExercise + ", exerciseFee=" + this.exerciseFee + '}' + " " + super.toString();
        }
    }

    public static interface EuropeanExerciseBuilder
    extends EuropeanExercise,
    Exercise.ExerciseBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate();

        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate();

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime();

        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise();

        @Override
        public PartialExercise.PartialExerciseBuilder getPartialExercise();

        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee();

        @Override
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee();

        @Override
        public EuropeanExerciseBuilder setId(String var1);

        public EuropeanExerciseBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        public EuropeanExerciseBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates var1);

        public EuropeanExerciseBuilder setEarliestExerciseTime(BusinessCenterTime var1);

        public EuropeanExerciseBuilder setExpirationTime(BusinessCenterTime var1);

        public EuropeanExerciseBuilder setPartialExercise(PartialExercise var1);

        public EuropeanExerciseBuilder setExerciseFee(ExerciseFee var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getExpirationTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.PartialExerciseBuilder.class, this.getPartialExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.ExerciseFeeBuilder.class, this.getExerciseFee(), new AttributeMeta[0]);
        }

        @Override
        public EuropeanExerciseBuilder prune();
    }

    public static class EuropeanExerciseImpl
    extends Exercise.ExerciseImpl
    implements EuropeanExercise {
        private final AdjustableOrRelativeDate expirationDate;
        private final AdjustableOrRelativeDates relevantUnderlyingDate;
        private final BusinessCenterTime earliestExerciseTime;
        private final BusinessCenterTime expirationTime;
        private final PartialExercise partialExercise;
        private final ExerciseFee exerciseFee;

        protected EuropeanExerciseImpl(EuropeanExerciseBuilder builder) {
            super(builder);
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).map(f -> f.build()).orElse(null);
            this.relevantUnderlyingDate = Optional.ofNullable(builder.getRelevantUnderlyingDate()).map(f -> f.build()).orElse(null);
            this.earliestExerciseTime = Optional.ofNullable(builder.getEarliestExerciseTime()).map(f -> f.build()).orElse(null);
            this.expirationTime = Optional.ofNullable(builder.getExpirationTime()).map(f -> f.build()).orElse(null);
            this.partialExercise = Optional.ofNullable(builder.getPartialExercise()).map(f -> f.build()).orElse(null);
            this.exerciseFee = Optional.ofNullable(builder.getExerciseFee()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public AdjustableOrRelativeDate getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="relevantUnderlyingDate")
        @RuneAttribute(value="relevantUnderlyingDate")
        public AdjustableOrRelativeDates getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        @RosettaAttribute(value="earliestExerciseTime")
        @RuneAttribute(value="earliestExerciseTime")
        public BusinessCenterTime getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        @RosettaAttribute(value="expirationTime")
        @RuneAttribute(value="expirationTime")
        public BusinessCenterTime getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        @RosettaAttribute(value="partialExercise")
        @RuneAttribute(value="partialExercise")
        public PartialExercise getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        @RosettaAttribute(value="exerciseFee")
        @RuneAttribute(value="exerciseFee")
        public ExerciseFee getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        public EuropeanExercise build() {
            return this;
        }

        @Override
        public EuropeanExerciseBuilder toBuilder() {
            EuropeanExerciseBuilder builder = EuropeanExercise.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EuropeanExerciseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getRelevantUnderlyingDate()).ifPresent(builder::setRelevantUnderlyingDate);
            Optional.ofNullable(this.getEarliestExerciseTime()).ifPresent(builder::setEarliestExerciseTime);
            Optional.ofNullable(this.getExpirationTime()).ifPresent(builder::setExpirationTime);
            Optional.ofNullable(this.getPartialExercise()).ifPresent(builder::setPartialExercise);
            Optional.ofNullable(this.getExerciseFee()).ifPresent(builder::setExerciseFee);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EuropeanExercise _that = (EuropeanExercise)this.getType().cast(o);
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate())) {
                return false;
            }
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            return Objects.equals(this.exerciseFee, _that.getExerciseFee());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EuropeanExercise {expirationDate=" + this.expirationDate + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + ", earliestExerciseTime=" + this.earliestExerciseTime + ", expirationTime=" + this.expirationTime + ", partialExercise=" + this.partialExercise + ", exerciseFee=" + this.exerciseFee + '}' + " " + super.toString();
        }
    }
}

