/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.AccountId;
import fpml.consolidated.shared.AccountName;
import fpml.consolidated.shared.AccountSequence;
import fpml.consolidated.shared.AccountType;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.meta.AccountMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Account", builder=AccountBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Account", model="fpml", builder=AccountBuilderImpl.class, version="1.1.0")
public interface Account
extends RosettaModelObject {
    public static final AccountMeta metaData = new AccountMeta();

    public List<? extends AccountId> getAccountId();

    public AccountName getAccountName();

    public AccountType getAccountType();

    public AccountSequence getAccountSequence();

    public String getId();

    public PartyReference getServicingParty();

    public Account build();

    public AccountBuilder toBuilder();

    public static AccountBuilder builder() {
        return new AccountBuilderImpl();
    }

    default public RosettaMetaData<? extends Account> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Account> getType() {
        return Account.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accountId"), processor, AccountId.class, this.getAccountId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountName"), processor, AccountName.class, this.getAccountName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountType"), processor, AccountType.class, this.getAccountType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accountSequence"), processor, AccountSequence.class, this.getAccountSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("servicingParty"), processor, PartyReference.class, this.getServicingParty(), new AttributeMeta[0]);
    }

    public static class AccountBuilderImpl
    implements AccountBuilder {
        protected List<AccountId.AccountIdBuilder> accountId = new ArrayList<AccountId.AccountIdBuilder>();
        protected AccountName.AccountNameBuilder accountName;
        protected AccountType.AccountTypeBuilder accountType;
        protected AccountSequence.AccountSequenceBuilder accountSequence;
        protected String id;
        protected PartyReference.PartyReferenceBuilder servicingParty;

        @Override
        @RosettaAttribute(value="accountId")
        @RuneAttribute(value="accountId")
        public List<? extends AccountId.AccountIdBuilder> getAccountId() {
            return this.accountId;
        }

        @Override
        public AccountId.AccountIdBuilder getOrCreateAccountId(int index) {
            if (this.accountId == null) {
                this.accountId = new ArrayList<AccountId.AccountIdBuilder>();
            }
            return (AccountId.AccountIdBuilder)this.getIndex(this.accountId, index, () -> {
                AccountId.AccountIdBuilder newAccountId = AccountId.builder();
                return newAccountId;
            });
        }

        @Override
        @RosettaAttribute(value="accountName")
        @RuneAttribute(value="accountName")
        public AccountName.AccountNameBuilder getAccountName() {
            return this.accountName;
        }

        @Override
        public AccountName.AccountNameBuilder getOrCreateAccountName() {
            AccountName.AccountNameBuilder result = this.accountName != null ? this.accountName : (this.accountName = AccountName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accountType")
        @RuneAttribute(value="accountType")
        public AccountType.AccountTypeBuilder getAccountType() {
            return this.accountType;
        }

        @Override
        public AccountType.AccountTypeBuilder getOrCreateAccountType() {
            AccountType.AccountTypeBuilder result = this.accountType != null ? this.accountType : (this.accountType = AccountType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accountSequence")
        @RuneAttribute(value="accountSequence")
        public AccountSequence.AccountSequenceBuilder getAccountSequence() {
            return this.accountSequence;
        }

        @Override
        public AccountSequence.AccountSequenceBuilder getOrCreateAccountSequence() {
            AccountSequence.AccountSequenceBuilder result = this.accountSequence != null ? this.accountSequence : (this.accountSequence = AccountSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="servicingParty")
        @RuneAttribute(value="servicingParty")
        public PartyReference.PartyReferenceBuilder getServicingParty() {
            return this.servicingParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateServicingParty() {
            PartyReference.PartyReferenceBuilder result = this.servicingParty != null ? this.servicingParty : (this.servicingParty = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accountId")
        @RuneAttribute(value="accountId")
        public AccountBuilder addAccountId(AccountId _accountId) {
            if (_accountId != null) {
                this.accountId.add(_accountId.toBuilder());
            }
            return this;
        }

        @Override
        public AccountBuilder addAccountId(AccountId _accountId, int idx) {
            this.getIndex(this.accountId, idx, () -> _accountId.toBuilder());
            return this;
        }

        @Override
        public AccountBuilder addAccountId(List<? extends AccountId> accountIds) {
            if (accountIds != null) {
                for (AccountId accountId : accountIds) {
                    this.accountId.add(accountId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accountId")
        public AccountBuilder setAccountId(List<? extends AccountId> accountIds) {
            this.accountId = accountIds == null ? new ArrayList<AccountId.AccountIdBuilder>() : (List)accountIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="accountName")
        @RuneAttribute(value="accountName")
        public AccountBuilder setAccountName(AccountName _accountName) {
            this.accountName = _accountName == null ? null : _accountName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accountType")
        @RuneAttribute(value="accountType")
        public AccountBuilder setAccountType(AccountType _accountType) {
            this.accountType = _accountType == null ? null : _accountType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accountSequence")
        @RuneAttribute(value="accountSequence")
        public AccountBuilder setAccountSequence(AccountSequence _accountSequence) {
            this.accountSequence = _accountSequence == null ? null : _accountSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public AccountBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="servicingParty")
        @RuneAttribute(value="servicingParty")
        public AccountBuilder setServicingParty(PartyReference _servicingParty) {
            this.servicingParty = _servicingParty == null ? null : _servicingParty.toBuilder();
            return this;
        }

        @Override
        public Account build() {
            return new AccountImpl(this);
        }

        @Override
        public AccountBuilder toBuilder() {
            return this;
        }

        @Override
        public AccountBuilder prune() {
            this.accountId = this.accountId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.accountName != null && !this.accountName.prune().hasData()) {
                this.accountName = null;
            }
            if (this.accountType != null && !this.accountType.prune().hasData()) {
                this.accountType = null;
            }
            if (this.accountSequence != null && !this.accountSequence.prune().hasData()) {
                this.accountSequence = null;
            }
            if (this.servicingParty != null && !this.servicingParty.prune().hasData()) {
                this.servicingParty = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccountId() != null && this.getAccountId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAccountName() != null && this.getAccountName().hasData()) {
                return true;
            }
            if (this.getAccountType() != null && this.getAccountType().hasData()) {
                return true;
            }
            if (this.getAccountSequence() != null && this.getAccountSequence().hasData()) {
                return true;
            }
            if (this.getId() != null) {
                return true;
            }
            return this.getServicingParty() != null && this.getServicingParty().hasData();
        }

        public AccountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AccountBuilder o = (AccountBuilder)other;
            merger.mergeRosetta(this.getAccountId(), o.getAccountId(), this::getOrCreateAccountId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountName(), (RosettaModelObjectBuilder)o.getAccountName(), this::setAccountName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountType(), (RosettaModelObjectBuilder)o.getAccountType(), this::setAccountType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccountSequence(), (RosettaModelObjectBuilder)o.getAccountSequence(), this::setAccountSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getServicingParty(), (RosettaModelObjectBuilder)o.getServicingParty(), this::setServicingParty);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Account _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.accountId, _that.getAccountId())) {
                return false;
            }
            if (!Objects.equals(this.accountName, _that.getAccountName())) {
                return false;
            }
            if (!Objects.equals(this.accountType, _that.getAccountType())) {
                return false;
            }
            if (!Objects.equals(this.accountSequence, _that.getAccountSequence())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.servicingParty, _that.getServicingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accountId != null ? this.accountId.hashCode() : 0);
            _result = 31 * _result + (this.accountName != null ? this.accountName.hashCode() : 0);
            _result = 31 * _result + (this.accountType != null ? this.accountType.hashCode() : 0);
            _result = 31 * _result + (this.accountSequence != null ? this.accountSequence.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.servicingParty != null ? this.servicingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AccountBuilder {accountId=" + this.accountId + ", accountName=" + this.accountName + ", accountType=" + this.accountType + ", accountSequence=" + this.accountSequence + ", id=" + this.id + ", servicingParty=" + this.servicingParty + '}';
        }
    }

    public static interface AccountBuilder
    extends Account,
    RosettaModelObjectBuilder {
        public AccountId.AccountIdBuilder getOrCreateAccountId(int var1);

        public List<? extends AccountId.AccountIdBuilder> getAccountId();

        public AccountName.AccountNameBuilder getOrCreateAccountName();

        @Override
        public AccountName.AccountNameBuilder getAccountName();

        public AccountType.AccountTypeBuilder getOrCreateAccountType();

        @Override
        public AccountType.AccountTypeBuilder getAccountType();

        public AccountSequence.AccountSequenceBuilder getOrCreateAccountSequence();

        @Override
        public AccountSequence.AccountSequenceBuilder getAccountSequence();

        public PartyReference.PartyReferenceBuilder getOrCreateServicingParty();

        @Override
        public PartyReference.PartyReferenceBuilder getServicingParty();

        public AccountBuilder addAccountId(AccountId var1);

        public AccountBuilder addAccountId(AccountId var1, int var2);

        public AccountBuilder addAccountId(List<? extends AccountId> var1);

        public AccountBuilder setAccountId(List<? extends AccountId> var1);

        public AccountBuilder setAccountName(AccountName var1);

        public AccountBuilder setAccountType(AccountType var1);

        public AccountBuilder setAccountSequence(AccountSequence var1);

        public AccountBuilder setId(String var1);

        public AccountBuilder setServicingParty(PartyReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accountId"), processor, AccountId.AccountIdBuilder.class, this.getAccountId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountName"), processor, AccountName.AccountNameBuilder.class, this.getAccountName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountType"), processor, AccountType.AccountTypeBuilder.class, this.getAccountType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accountSequence"), processor, AccountSequence.AccountSequenceBuilder.class, this.getAccountSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("servicingParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getServicingParty(), new AttributeMeta[0]);
        }

        public AccountBuilder prune();
    }

    public static class AccountImpl
    implements Account {
        private final List<? extends AccountId> accountId;
        private final AccountName accountName;
        private final AccountType accountType;
        private final AccountSequence accountSequence;
        private final String id;
        private final PartyReference servicingParty;

        protected AccountImpl(AccountBuilder builder) {
            this.accountId = Optional.ofNullable(builder.getAccountId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.accountName = Optional.ofNullable(builder.getAccountName()).map(f -> f.build()).orElse(null);
            this.accountType = Optional.ofNullable(builder.getAccountType()).map(f -> f.build()).orElse(null);
            this.accountSequence = Optional.ofNullable(builder.getAccountSequence()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
            this.servicingParty = Optional.ofNullable(builder.getServicingParty()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="accountId")
        @RuneAttribute(value="accountId")
        public List<? extends AccountId> getAccountId() {
            return this.accountId;
        }

        @Override
        @RosettaAttribute(value="accountName")
        @RuneAttribute(value="accountName")
        public AccountName getAccountName() {
            return this.accountName;
        }

        @Override
        @RosettaAttribute(value="accountType")
        @RuneAttribute(value="accountType")
        public AccountType getAccountType() {
            return this.accountType;
        }

        @Override
        @RosettaAttribute(value="accountSequence")
        @RuneAttribute(value="accountSequence")
        public AccountSequence getAccountSequence() {
            return this.accountSequence;
        }

        @Override
        @RosettaAttribute(value="id", isRequired=true)
        @RuneAttribute(value="id", isRequired=true)
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="servicingParty")
        @RuneAttribute(value="servicingParty")
        public PartyReference getServicingParty() {
            return this.servicingParty;
        }

        @Override
        public Account build() {
            return this;
        }

        @Override
        public AccountBuilder toBuilder() {
            AccountBuilder builder = Account.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccountBuilder builder) {
            Optional.ofNullable(this.getAccountId()).ifPresent(builder::setAccountId);
            Optional.ofNullable(this.getAccountName()).ifPresent(builder::setAccountName);
            Optional.ofNullable(this.getAccountType()).ifPresent(builder::setAccountType);
            Optional.ofNullable(this.getAccountSequence()).ifPresent(builder::setAccountSequence);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
            Optional.ofNullable(this.getServicingParty()).ifPresent(builder::setServicingParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Account _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.accountId, _that.getAccountId())) {
                return false;
            }
            if (!Objects.equals(this.accountName, _that.getAccountName())) {
                return false;
            }
            if (!Objects.equals(this.accountType, _that.getAccountType())) {
                return false;
            }
            if (!Objects.equals(this.accountSequence, _that.getAccountSequence())) {
                return false;
            }
            if (!Objects.equals(this.id, _that.getId())) {
                return false;
            }
            return Objects.equals(this.servicingParty, _that.getServicingParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accountId != null ? this.accountId.hashCode() : 0);
            _result = 31 * _result + (this.accountName != null ? this.accountName.hashCode() : 0);
            _result = 31 * _result + (this.accountType != null ? this.accountType.hashCode() : 0);
            _result = 31 * _result + (this.accountSequence != null ? this.accountSequence.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            _result = 31 * _result + (this.servicingParty != null ? this.servicingParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Account {accountId=" + this.accountId + ", accountName=" + this.accountName + ", accountType=" + this.accountType + ", accountSequence=" + this.accountSequence + ", id=" + this.id + ", servicingParty=" + this.servicingParty + '}';
        }
    }
}

