/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.doc.ReportingPurpose;
import fpml.consolidated.doc.ReportingRole;
import fpml.consolidated.reg.fpmlreporting.shared.PublicDissemination;
import fpml.consolidated.reg.fpmlreporting.shared.RegulationName;
import fpml.consolidated.reg.fpmlreporting.shared.RegulatorReportingStatusCode;
import fpml.consolidated.reg.fpmlreporting.shared.meta.ReportingStatusMeta;
import fpml.consolidated.shared.ReportingRegimeName;
import fpml.consolidated.shared.SupervisoryBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportingStatus", builder=ReportingStatusBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ReportingStatus", model="fpml", builder=ReportingStatusBuilderImpl.class, version="1.1.0")
public interface ReportingStatus
extends RosettaModelObject {
    public static final ReportingStatusMeta metaData = new ReportingStatusMeta();

    public ReportingRegimeName getRegimeName();

    public SupervisoryBody getSupervisoryBody();

    public RegulationName getRegulation();

    public ReportingRole getReportingRole();

    public List<? extends ReportingPurpose> getReportingPurpose();

    public RegulatorReportingStatusCode getStatus();

    public List<? extends PublicDissemination> getPublicDissemination();

    public List<? extends Reason> getReason();

    public ReportingStatus build();

    public ReportingStatusBuilder toBuilder();

    public static ReportingStatusBuilder builder() {
        return new ReportingStatusBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportingStatus> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportingStatus> getType() {
        return ReportingStatus.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("regimeName"), processor, ReportingRegimeName.class, this.getRegimeName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("supervisoryBody"), processor, SupervisoryBody.class, this.getSupervisoryBody(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulation"), processor, RegulationName.class, this.getRegulation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRole"), processor, ReportingRole.class, this.getReportingRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingPurpose"), processor, ReportingPurpose.class, this.getReportingPurpose(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("status"), processor, RegulatorReportingStatusCode.class, this.getStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publicDissemination"), processor, PublicDissemination.class, this.getPublicDissemination(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class ReportingStatusBuilderImpl
    implements ReportingStatusBuilder {
        protected ReportingRegimeName.ReportingRegimeNameBuilder regimeName;
        protected SupervisoryBody.SupervisoryBodyBuilder supervisoryBody;
        protected RegulationName.RegulationNameBuilder regulation;
        protected ReportingRole.ReportingRoleBuilder reportingRole;
        protected List<ReportingPurpose.ReportingPurposeBuilder> reportingPurpose = new ArrayList<ReportingPurpose.ReportingPurposeBuilder>();
        protected RegulatorReportingStatusCode.RegulatorReportingStatusCodeBuilder status;
        protected List<PublicDissemination.PublicDisseminationBuilder> publicDissemination = new ArrayList<PublicDissemination.PublicDisseminationBuilder>();
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();

        @Override
        @RosettaAttribute(value="regimeName")
        @RuneAttribute(value="regimeName")
        public ReportingRegimeName.ReportingRegimeNameBuilder getRegimeName() {
            return this.regimeName;
        }

        @Override
        public ReportingRegimeName.ReportingRegimeNameBuilder getOrCreateRegimeName() {
            ReportingRegimeName.ReportingRegimeNameBuilder result = this.regimeName != null ? this.regimeName : (this.regimeName = ReportingRegimeName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public SupervisoryBody.SupervisoryBodyBuilder getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        public SupervisoryBody.SupervisoryBodyBuilder getOrCreateSupervisoryBody() {
            SupervisoryBody.SupervisoryBodyBuilder result = this.supervisoryBody != null ? this.supervisoryBody : (this.supervisoryBody = SupervisoryBody.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public RegulationName.RegulationNameBuilder getRegulation() {
            return this.regulation;
        }

        @Override
        public RegulationName.RegulationNameBuilder getOrCreateRegulation() {
            RegulationName.RegulationNameBuilder result = this.regulation != null ? this.regulation : (this.regulation = RegulationName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingRole.ReportingRoleBuilder getReportingRole() {
            return this.reportingRole;
        }

        @Override
        public ReportingRole.ReportingRoleBuilder getOrCreateReportingRole() {
            ReportingRole.ReportingRoleBuilder result = this.reportingRole != null ? this.reportingRole : (this.reportingRole = ReportingRole.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingPurpose")
        @RuneAttribute(value="reportingPurpose")
        public List<? extends ReportingPurpose.ReportingPurposeBuilder> getReportingPurpose() {
            return this.reportingPurpose;
        }

        @Override
        public ReportingPurpose.ReportingPurposeBuilder getOrCreateReportingPurpose(int index) {
            if (this.reportingPurpose == null) {
                this.reportingPurpose = new ArrayList<ReportingPurpose.ReportingPurposeBuilder>();
            }
            return (ReportingPurpose.ReportingPurposeBuilder)this.getIndex(this.reportingPurpose, index, () -> {
                ReportingPurpose.ReportingPurposeBuilder newReportingPurpose = ReportingPurpose.builder();
                return newReportingPurpose;
            });
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public RegulatorReportingStatusCode.RegulatorReportingStatusCodeBuilder getStatus() {
            return this.status;
        }

        @Override
        public RegulatorReportingStatusCode.RegulatorReportingStatusCodeBuilder getOrCreateStatus() {
            RegulatorReportingStatusCode.RegulatorReportingStatusCodeBuilder result = this.status != null ? this.status : (this.status = RegulatorReportingStatusCode.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="publicDissemination")
        @RuneAttribute(value="publicDissemination")
        public List<? extends PublicDissemination.PublicDisseminationBuilder> getPublicDissemination() {
            return this.publicDissemination;
        }

        @Override
        public PublicDissemination.PublicDisseminationBuilder getOrCreatePublicDissemination(int index) {
            if (this.publicDissemination == null) {
                this.publicDissemination = new ArrayList<PublicDissemination.PublicDisseminationBuilder>();
            }
            return (PublicDissemination.PublicDisseminationBuilder)this.getIndex(this.publicDissemination, index, () -> {
                PublicDissemination.PublicDisseminationBuilder newPublicDissemination = PublicDissemination.builder();
                return newPublicDissemination;
            });
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="regimeName")
        @RuneAttribute(value="regimeName")
        public ReportingStatusBuilder setRegimeName(ReportingRegimeName _regimeName) {
            this.regimeName = _regimeName == null ? null : _regimeName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public ReportingStatusBuilder setSupervisoryBody(SupervisoryBody _supervisoryBody) {
            this.supervisoryBody = _supervisoryBody == null ? null : _supervisoryBody.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public ReportingStatusBuilder setRegulation(RegulationName _regulation) {
            this.regulation = _regulation == null ? null : _regulation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingStatusBuilder setReportingRole(ReportingRole _reportingRole) {
            this.reportingRole = _reportingRole == null ? null : _reportingRole.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingPurpose")
        @RuneAttribute(value="reportingPurpose")
        public ReportingStatusBuilder addReportingPurpose(ReportingPurpose _reportingPurpose) {
            if (_reportingPurpose != null) {
                this.reportingPurpose.add(_reportingPurpose.toBuilder());
            }
            return this;
        }

        @Override
        public ReportingStatusBuilder addReportingPurpose(ReportingPurpose _reportingPurpose, int idx) {
            this.getIndex(this.reportingPurpose, idx, () -> _reportingPurpose.toBuilder());
            return this;
        }

        @Override
        public ReportingStatusBuilder addReportingPurpose(List<? extends ReportingPurpose> reportingPurposes) {
            if (reportingPurposes != null) {
                for (ReportingPurpose reportingPurpose : reportingPurposes) {
                    this.reportingPurpose.add(reportingPurpose.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reportingPurpose")
        public ReportingStatusBuilder setReportingPurpose(List<? extends ReportingPurpose> reportingPurposes) {
            this.reportingPurpose = reportingPurposes == null ? new ArrayList<ReportingPurpose.ReportingPurposeBuilder>() : (List)reportingPurposes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public ReportingStatusBuilder setStatus(RegulatorReportingStatusCode _status) {
            this.status = _status == null ? null : _status.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="publicDissemination")
        @RuneAttribute(value="publicDissemination")
        public ReportingStatusBuilder addPublicDissemination(PublicDissemination _publicDissemination) {
            if (_publicDissemination != null) {
                this.publicDissemination.add(_publicDissemination.toBuilder());
            }
            return this;
        }

        @Override
        public ReportingStatusBuilder addPublicDissemination(PublicDissemination _publicDissemination, int idx) {
            this.getIndex(this.publicDissemination, idx, () -> _publicDissemination.toBuilder());
            return this;
        }

        @Override
        public ReportingStatusBuilder addPublicDissemination(List<? extends PublicDissemination> publicDisseminations) {
            if (publicDisseminations != null) {
                for (PublicDissemination publicDissemination : publicDisseminations) {
                    this.publicDissemination.add(publicDissemination.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="publicDissemination")
        public ReportingStatusBuilder setPublicDissemination(List<? extends PublicDissemination> publicDisseminations) {
            this.publicDissemination = publicDisseminations == null ? new ArrayList<PublicDissemination.PublicDisseminationBuilder>() : (List)publicDisseminations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public ReportingStatusBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public ReportingStatusBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public ReportingStatusBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public ReportingStatusBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ReportingStatus build() {
            return new ReportingStatusImpl(this);
        }

        @Override
        public ReportingStatusBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportingStatusBuilder prune() {
            if (this.regimeName != null && !this.regimeName.prune().hasData()) {
                this.regimeName = null;
            }
            if (this.supervisoryBody != null && !this.supervisoryBody.prune().hasData()) {
                this.supervisoryBody = null;
            }
            if (this.regulation != null && !this.regulation.prune().hasData()) {
                this.regulation = null;
            }
            if (this.reportingRole != null && !this.reportingRole.prune().hasData()) {
                this.reportingRole = null;
            }
            this.reportingPurpose = this.reportingPurpose.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.status != null && !this.status.prune().hasData()) {
                this.status = null;
            }
            this.publicDissemination = this.publicDissemination.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getRegimeName() != null && this.getRegimeName().hasData()) {
                return true;
            }
            if (this.getSupervisoryBody() != null && this.getSupervisoryBody().hasData()) {
                return true;
            }
            if (this.getRegulation() != null && this.getRegulation().hasData()) {
                return true;
            }
            if (this.getReportingRole() != null && this.getReportingRole().hasData()) {
                return true;
            }
            if (this.getReportingPurpose() != null && this.getReportingPurpose().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStatus() != null && this.getStatus().hasData()) {
                return true;
            }
            if (this.getPublicDissemination() != null && this.getPublicDissemination().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ReportingStatusBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportingStatusBuilder o = (ReportingStatusBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegimeName(), (RosettaModelObjectBuilder)o.getRegimeName(), this::setRegimeName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSupervisoryBody(), (RosettaModelObjectBuilder)o.getSupervisoryBody(), this::setSupervisoryBody);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegulation(), (RosettaModelObjectBuilder)o.getRegulation(), this::setRegulation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingRole(), (RosettaModelObjectBuilder)o.getReportingRole(), this::setReportingRole);
            merger.mergeRosetta(this.getReportingPurpose(), o.getReportingPurpose(), this::getOrCreateReportingPurpose);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStatus(), (RosettaModelObjectBuilder)o.getStatus(), this::setStatus);
            merger.mergeRosetta(this.getPublicDissemination(), o.getPublicDissemination(), this::getOrCreatePublicDissemination);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportingStatus _that = this.getType().cast(o);
            if (!Objects.equals(this.regimeName, _that.getRegimeName())) {
                return false;
            }
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.regulation, _that.getRegulation())) {
                return false;
            }
            if (!Objects.equals(this.reportingRole, _that.getReportingRole())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingPurpose, _that.getReportingPurpose())) {
                return false;
            }
            if (!Objects.equals(this.status, _that.getStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publicDissemination, _that.getPublicDissemination())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regimeName != null ? this.regimeName.hashCode() : 0);
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.regulation != null ? this.regulation.hashCode() : 0);
            _result = 31 * _result + (this.reportingRole != null ? this.reportingRole.hashCode() : 0);
            _result = 31 * _result + (this.reportingPurpose != null ? this.reportingPurpose.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? this.status.hashCode() : 0);
            _result = 31 * _result + (this.publicDissemination != null ? this.publicDissemination.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportingStatusBuilder {regimeName=" + this.regimeName + ", supervisoryBody=" + this.supervisoryBody + ", regulation=" + this.regulation + ", reportingRole=" + this.reportingRole + ", reportingPurpose=" + this.reportingPurpose + ", status=" + this.status + ", publicDissemination=" + this.publicDissemination + ", reason=" + this.reason + '}';
        }
    }

    public static interface ReportingStatusBuilder
    extends ReportingStatus,
    RosettaModelObjectBuilder {
        public ReportingRegimeName.ReportingRegimeNameBuilder getOrCreateRegimeName();

        @Override
        public ReportingRegimeName.ReportingRegimeNameBuilder getRegimeName();

        public SupervisoryBody.SupervisoryBodyBuilder getOrCreateSupervisoryBody();

        @Override
        public SupervisoryBody.SupervisoryBodyBuilder getSupervisoryBody();

        public RegulationName.RegulationNameBuilder getOrCreateRegulation();

        @Override
        public RegulationName.RegulationNameBuilder getRegulation();

        public ReportingRole.ReportingRoleBuilder getOrCreateReportingRole();

        @Override
        public ReportingRole.ReportingRoleBuilder getReportingRole();

        public ReportingPurpose.ReportingPurposeBuilder getOrCreateReportingPurpose(int var1);

        public List<? extends ReportingPurpose.ReportingPurposeBuilder> getReportingPurpose();

        public RegulatorReportingStatusCode.RegulatorReportingStatusCodeBuilder getOrCreateStatus();

        @Override
        public RegulatorReportingStatusCode.RegulatorReportingStatusCodeBuilder getStatus();

        public PublicDissemination.PublicDisseminationBuilder getOrCreatePublicDissemination(int var1);

        public List<? extends PublicDissemination.PublicDisseminationBuilder> getPublicDissemination();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        public ReportingStatusBuilder setRegimeName(ReportingRegimeName var1);

        public ReportingStatusBuilder setSupervisoryBody(SupervisoryBody var1);

        public ReportingStatusBuilder setRegulation(RegulationName var1);

        public ReportingStatusBuilder setReportingRole(ReportingRole var1);

        public ReportingStatusBuilder addReportingPurpose(ReportingPurpose var1);

        public ReportingStatusBuilder addReportingPurpose(ReportingPurpose var1, int var2);

        public ReportingStatusBuilder addReportingPurpose(List<? extends ReportingPurpose> var1);

        public ReportingStatusBuilder setReportingPurpose(List<? extends ReportingPurpose> var1);

        public ReportingStatusBuilder setStatus(RegulatorReportingStatusCode var1);

        public ReportingStatusBuilder addPublicDissemination(PublicDissemination var1);

        public ReportingStatusBuilder addPublicDissemination(PublicDissemination var1, int var2);

        public ReportingStatusBuilder addPublicDissemination(List<? extends PublicDissemination> var1);

        public ReportingStatusBuilder setPublicDissemination(List<? extends PublicDissemination> var1);

        public ReportingStatusBuilder addReason(Reason var1);

        public ReportingStatusBuilder addReason(Reason var1, int var2);

        public ReportingStatusBuilder addReason(List<? extends Reason> var1);

        public ReportingStatusBuilder setReason(List<? extends Reason> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("regimeName"), processor, ReportingRegimeName.ReportingRegimeNameBuilder.class, this.getRegimeName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("supervisoryBody"), processor, SupervisoryBody.SupervisoryBodyBuilder.class, this.getSupervisoryBody(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulation"), processor, RegulationName.RegulationNameBuilder.class, this.getRegulation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRole"), processor, ReportingRole.ReportingRoleBuilder.class, this.getReportingRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingPurpose"), processor, ReportingPurpose.ReportingPurposeBuilder.class, this.getReportingPurpose(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("status"), processor, RegulatorReportingStatusCode.RegulatorReportingStatusCodeBuilder.class, this.getStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publicDissemination"), processor, PublicDissemination.PublicDisseminationBuilder.class, this.getPublicDissemination(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        public ReportingStatusBuilder prune();
    }

    public static class ReportingStatusImpl
    implements ReportingStatus {
        private final ReportingRegimeName regimeName;
        private final SupervisoryBody supervisoryBody;
        private final RegulationName regulation;
        private final ReportingRole reportingRole;
        private final List<? extends ReportingPurpose> reportingPurpose;
        private final RegulatorReportingStatusCode status;
        private final List<? extends PublicDissemination> publicDissemination;
        private final List<? extends Reason> reason;

        protected ReportingStatusImpl(ReportingStatusBuilder builder) {
            this.regimeName = Optional.ofNullable(builder.getRegimeName()).map(f -> f.build()).orElse(null);
            this.supervisoryBody = Optional.ofNullable(builder.getSupervisoryBody()).map(f -> f.build()).orElse(null);
            this.regulation = Optional.ofNullable(builder.getRegulation()).map(f -> f.build()).orElse(null);
            this.reportingRole = Optional.ofNullable(builder.getReportingRole()).map(f -> f.build()).orElse(null);
            this.reportingPurpose = Optional.ofNullable(builder.getReportingPurpose()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.status = Optional.ofNullable(builder.getStatus()).map(f -> f.build()).orElse(null);
            this.publicDissemination = Optional.ofNullable(builder.getPublicDissemination()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regimeName")
        @RuneAttribute(value="regimeName")
        public ReportingRegimeName getRegimeName() {
            return this.regimeName;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public SupervisoryBody getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public RegulationName getRegulation() {
            return this.regulation;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingRole getReportingRole() {
            return this.reportingRole;
        }

        @Override
        @RosettaAttribute(value="reportingPurpose")
        @RuneAttribute(value="reportingPurpose")
        public List<? extends ReportingPurpose> getReportingPurpose() {
            return this.reportingPurpose;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public RegulatorReportingStatusCode getStatus() {
            return this.status;
        }

        @Override
        @RosettaAttribute(value="publicDissemination")
        @RuneAttribute(value="publicDissemination")
        public List<? extends PublicDissemination> getPublicDissemination() {
            return this.publicDissemination;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        public ReportingStatus build() {
            return this;
        }

        @Override
        public ReportingStatusBuilder toBuilder() {
            ReportingStatusBuilder builder = ReportingStatus.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportingStatusBuilder builder) {
            Optional.ofNullable(this.getRegimeName()).ifPresent(builder::setRegimeName);
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getRegulation()).ifPresent(builder::setRegulation);
            Optional.ofNullable(this.getReportingRole()).ifPresent(builder::setReportingRole);
            Optional.ofNullable(this.getReportingPurpose()).ifPresent(builder::setReportingPurpose);
            Optional.ofNullable(this.getStatus()).ifPresent(builder::setStatus);
            Optional.ofNullable(this.getPublicDissemination()).ifPresent(builder::setPublicDissemination);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportingStatus _that = this.getType().cast(o);
            if (!Objects.equals(this.regimeName, _that.getRegimeName())) {
                return false;
            }
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.regulation, _that.getRegulation())) {
                return false;
            }
            if (!Objects.equals(this.reportingRole, _that.getReportingRole())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingPurpose, _that.getReportingPurpose())) {
                return false;
            }
            if (!Objects.equals(this.status, _that.getStatus())) {
                return false;
            }
            if (!ListEquals.listEquals(this.publicDissemination, _that.getPublicDissemination())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regimeName != null ? this.regimeName.hashCode() : 0);
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.regulation != null ? this.regulation.hashCode() : 0);
            _result = 31 * _result + (this.reportingRole != null ? this.reportingRole.hashCode() : 0);
            _result = 31 * _result + (this.reportingPurpose != null ? this.reportingPurpose.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? this.status.hashCode() : 0);
            _result = 31 * _result + (this.publicDissemination != null ? this.publicDissemination.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportingStatus {regimeName=" + this.regimeName + ", supervisoryBody=" + this.supervisoryBody + ", regulation=" + this.regulation + ", reportingRole=" + this.reportingRole + ", reportingPurpose=" + this.reportingPurpose + ", status=" + this.status + ", publicDissemination=" + this.publicDissemination + ", reason=" + this.reason + '}';
        }
    }
}

