/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.reg.fpmlreporting.shared.RegulationName;
import fpml.consolidated.reg.fpmlreporting.shared.ReportingAndCounterPartyModel;
import fpml.consolidated.reg.fpmlreporting.shared.meta.RegulatorApplicabilityMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatorApplicability", builder=RegulatorApplicabilityBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RegulatorApplicability", model="fpml", builder=RegulatorApplicabilityBuilderImpl.class, version="1.1.0")
public interface RegulatorApplicability
extends RosettaModelObject {
    public static final RegulatorApplicabilityMeta metaData = new RegulatorApplicabilityMeta();

    public String getSupervisoryBody();

    public List<? extends RegulationName> getRegulation();

    public ReportingAndCounterPartyModel getReportingAndCounterPartyModel();

    public RegulatorApplicability build();

    public RegulatorApplicabilityBuilder toBuilder();

    public static RegulatorApplicabilityBuilder builder() {
        return new RegulatorApplicabilityBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatorApplicability> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatorApplicability> getType() {
        return RegulatorApplicability.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("supervisoryBody"), String.class, (Object)this.getSupervisoryBody(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulation"), processor, RegulationName.class, this.getRegulation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingAndCounterPartyModel"), processor, ReportingAndCounterPartyModel.class, this.getReportingAndCounterPartyModel(), new AttributeMeta[0]);
    }

    public static class RegulatorApplicabilityBuilderImpl
    implements RegulatorApplicabilityBuilder {
        protected String supervisoryBody;
        protected List<RegulationName.RegulationNameBuilder> regulation = new ArrayList<RegulationName.RegulationNameBuilder>();
        protected ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder reportingAndCounterPartyModel;

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public String getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public List<? extends RegulationName.RegulationNameBuilder> getRegulation() {
            return this.regulation;
        }

        @Override
        public RegulationName.RegulationNameBuilder getOrCreateRegulation(int index) {
            if (this.regulation == null) {
                this.regulation = new ArrayList<RegulationName.RegulationNameBuilder>();
            }
            return (RegulationName.RegulationNameBuilder)this.getIndex(this.regulation, index, () -> {
                RegulationName.RegulationNameBuilder newRegulation = RegulationName.builder();
                return newRegulation;
            });
        }

        @Override
        @RosettaAttribute(value="reportingAndCounterPartyModel")
        @RuneAttribute(value="reportingAndCounterPartyModel")
        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getReportingAndCounterPartyModel() {
            return this.reportingAndCounterPartyModel;
        }

        @Override
        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getOrCreateReportingAndCounterPartyModel() {
            ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder result = this.reportingAndCounterPartyModel != null ? this.reportingAndCounterPartyModel : (this.reportingAndCounterPartyModel = ReportingAndCounterPartyModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public RegulatorApplicabilityBuilder setSupervisoryBody(String _supervisoryBody) {
            this.supervisoryBody = _supervisoryBody == null ? null : _supervisoryBody;
            return this;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public RegulatorApplicabilityBuilder addRegulation(RegulationName _regulation) {
            if (_regulation != null) {
                this.regulation.add(_regulation.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatorApplicabilityBuilder addRegulation(RegulationName _regulation, int idx) {
            this.getIndex(this.regulation, idx, () -> _regulation.toBuilder());
            return this;
        }

        @Override
        public RegulatorApplicabilityBuilder addRegulation(List<? extends RegulationName> regulations) {
            if (regulations != null) {
                for (RegulationName regulationName : regulations) {
                    this.regulation.add(regulationName.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regulation")
        public RegulatorApplicabilityBuilder setRegulation(List<? extends RegulationName> regulations) {
            this.regulation = regulations == null ? new ArrayList<RegulationName.RegulationNameBuilder>() : (List)regulations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingAndCounterPartyModel")
        @RuneAttribute(value="reportingAndCounterPartyModel")
        public RegulatorApplicabilityBuilder setReportingAndCounterPartyModel(ReportingAndCounterPartyModel _reportingAndCounterPartyModel) {
            this.reportingAndCounterPartyModel = _reportingAndCounterPartyModel == null ? null : _reportingAndCounterPartyModel.toBuilder();
            return this;
        }

        @Override
        public RegulatorApplicability build() {
            return new RegulatorApplicabilityImpl(this);
        }

        @Override
        public RegulatorApplicabilityBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatorApplicabilityBuilder prune() {
            this.regulation = this.regulation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.reportingAndCounterPartyModel != null && !this.reportingAndCounterPartyModel.prune().hasData()) {
                this.reportingAndCounterPartyModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSupervisoryBody() != null) {
                return true;
            }
            if (this.getRegulation() != null && this.getRegulation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getReportingAndCounterPartyModel() != null && this.getReportingAndCounterPartyModel().hasData();
        }

        public RegulatorApplicabilityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegulatorApplicabilityBuilder o = (RegulatorApplicabilityBuilder)other;
            merger.mergeRosetta(this.getRegulation(), o.getRegulation(), this::getOrCreateRegulation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingAndCounterPartyModel(), (RosettaModelObjectBuilder)o.getReportingAndCounterPartyModel(), this::setReportingAndCounterPartyModel);
            merger.mergeBasic((Object)this.getSupervisoryBody(), (Object)o.getSupervisoryBody(), this::setSupervisoryBody, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatorApplicability _that = this.getType().cast(o);
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!ListEquals.listEquals(this.regulation, _that.getRegulation())) {
                return false;
            }
            return Objects.equals(this.reportingAndCounterPartyModel, _that.getReportingAndCounterPartyModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.regulation != null ? this.regulation.hashCode() : 0);
            _result = 31 * _result + (this.reportingAndCounterPartyModel != null ? this.reportingAndCounterPartyModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatorApplicabilityBuilder {supervisoryBody=" + this.supervisoryBody + ", regulation=" + this.regulation + ", reportingAndCounterPartyModel=" + this.reportingAndCounterPartyModel + '}';
        }
    }

    public static interface RegulatorApplicabilityBuilder
    extends RegulatorApplicability,
    RosettaModelObjectBuilder {
        public RegulationName.RegulationNameBuilder getOrCreateRegulation(int var1);

        public List<? extends RegulationName.RegulationNameBuilder> getRegulation();

        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getOrCreateReportingAndCounterPartyModel();

        @Override
        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getReportingAndCounterPartyModel();

        public RegulatorApplicabilityBuilder setSupervisoryBody(String var1);

        public RegulatorApplicabilityBuilder addRegulation(RegulationName var1);

        public RegulatorApplicabilityBuilder addRegulation(RegulationName var1, int var2);

        public RegulatorApplicabilityBuilder addRegulation(List<? extends RegulationName> var1);

        public RegulatorApplicabilityBuilder setRegulation(List<? extends RegulationName> var1);

        public RegulatorApplicabilityBuilder setReportingAndCounterPartyModel(ReportingAndCounterPartyModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("supervisoryBody"), String.class, (Object)this.getSupervisoryBody(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulation"), processor, RegulationName.RegulationNameBuilder.class, this.getRegulation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingAndCounterPartyModel"), processor, ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder.class, this.getReportingAndCounterPartyModel(), new AttributeMeta[0]);
        }

        public RegulatorApplicabilityBuilder prune();
    }

    public static class RegulatorApplicabilityImpl
    implements RegulatorApplicability {
        private final String supervisoryBody;
        private final List<? extends RegulationName> regulation;
        private final ReportingAndCounterPartyModel reportingAndCounterPartyModel;

        protected RegulatorApplicabilityImpl(RegulatorApplicabilityBuilder builder) {
            this.supervisoryBody = builder.getSupervisoryBody();
            this.regulation = Optional.ofNullable(builder.getRegulation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.reportingAndCounterPartyModel = Optional.ofNullable(builder.getReportingAndCounterPartyModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public String getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public List<? extends RegulationName> getRegulation() {
            return this.regulation;
        }

        @Override
        @RosettaAttribute(value="reportingAndCounterPartyModel")
        @RuneAttribute(value="reportingAndCounterPartyModel")
        public ReportingAndCounterPartyModel getReportingAndCounterPartyModel() {
            return this.reportingAndCounterPartyModel;
        }

        @Override
        public RegulatorApplicability build() {
            return this;
        }

        @Override
        public RegulatorApplicabilityBuilder toBuilder() {
            RegulatorApplicabilityBuilder builder = RegulatorApplicability.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatorApplicabilityBuilder builder) {
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getRegulation()).ifPresent(builder::setRegulation);
            Optional.ofNullable(this.getReportingAndCounterPartyModel()).ifPresent(builder::setReportingAndCounterPartyModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatorApplicability _that = this.getType().cast(o);
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!ListEquals.listEquals(this.regulation, _that.getRegulation())) {
                return false;
            }
            return Objects.equals(this.reportingAndCounterPartyModel, _that.getReportingAndCounterPartyModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.regulation != null ? this.regulation.hashCode() : 0);
            _result = 31 * _result + (this.reportingAndCounterPartyModel != null ? this.reportingAndCounterPartyModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatorApplicability {supervisoryBody=" + this.supervisoryBody + ", regulation=" + this.regulation + ", reportingAndCounterPartyModel=" + this.reportingAndCounterPartyModel + '}';
        }
    }
}

