/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.product;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.reg.fpmlreporting.product.RegReportingPayment;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingNonCDEOptionDetails;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingNonCDEProductCommodityDetails;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductCalculationTerms;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductCreditDetails;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductDates;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductNonCDEFxDetails;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductParties;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductPriceTerms;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductSettlementDetails;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductSizes;
import fpml.consolidated.reg.fpmlreporting.product.RegulatoryReportingProductUnderlyers;
import fpml.consolidated.reg.fpmlreporting.product.meta.RegulatoryReportingProductMeta;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryReportingProduct", builder=RegulatoryReportingProductBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RegulatoryReportingProduct", model="fpml", builder=RegulatoryReportingProductBuilderImpl.class, version="1.1.0")
public interface RegulatoryReportingProduct
extends Product {
    public static final RegulatoryReportingProductMeta metaData = new RegulatoryReportingProductMeta();

    public RegulatoryReportingProductParties getParties();

    public RegulatoryReportingProductDates getDates();

    public RegulatoryReportingProductSizes getSizes();

    public RegulatoryReportingProductUnderlyers getUnderlyers();

    public RegulatoryReportingProductPriceTerms getPriceTerms();

    public RegulatoryReportingProductCalculationTerms getOtherCalculationTerms();

    public RegulatoryReportingNonCDEOptionDetails getOptionDetails();

    public RegulatoryReportingProductSettlementDetails getSettlementDetails();

    public List<? extends RegReportingPayment> getOtherPayment();

    public RegulatoryReportingProductCreditDetails getCreditDetails();

    public RegulatoryReportingProductNonCDEFxDetails getFxDetails();

    public RegulatoryReportingNonCDEProductCommodityDetails getCommodityDetails();

    @Override
    public RegulatoryReportingProduct build();

    @Override
    public RegulatoryReportingProductBuilder toBuilder();

    public static RegulatoryReportingProductBuilder builder() {
        return new RegulatoryReportingProductBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryReportingProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryReportingProduct> getType() {
        return RegulatoryReportingProduct.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("parties"), processor, RegulatoryReportingProductParties.class, this.getParties(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dates"), processor, RegulatoryReportingProductDates.class, this.getDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sizes"), processor, RegulatoryReportingProductSizes.class, this.getSizes(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyers"), processor, RegulatoryReportingProductUnderlyers.class, this.getUnderlyers(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceTerms"), processor, RegulatoryReportingProductPriceTerms.class, this.getPriceTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherCalculationTerms"), processor, RegulatoryReportingProductCalculationTerms.class, this.getOtherCalculationTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionDetails"), processor, RegulatoryReportingNonCDEOptionDetails.class, this.getOptionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDetails"), processor, RegulatoryReportingProductSettlementDetails.class, this.getSettlementDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, RegReportingPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditDetails"), processor, RegulatoryReportingProductCreditDetails.class, this.getCreditDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxDetails"), processor, RegulatoryReportingProductNonCDEFxDetails.class, this.getFxDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityDetails"), processor, RegulatoryReportingNonCDEProductCommodityDetails.class, this.getCommodityDetails(), new AttributeMeta[0]);
    }

    public static class RegulatoryReportingProductBuilderImpl
    extends Product.ProductBuilderImpl
    implements RegulatoryReportingProductBuilder {
        protected RegulatoryReportingProductParties.RegulatoryReportingProductPartiesBuilder parties;
        protected RegulatoryReportingProductDates.RegulatoryReportingProductDatesBuilder dates;
        protected RegulatoryReportingProductSizes.RegulatoryReportingProductSizesBuilder sizes;
        protected RegulatoryReportingProductUnderlyers.RegulatoryReportingProductUnderlyersBuilder underlyers;
        protected RegulatoryReportingProductPriceTerms.RegulatoryReportingProductPriceTermsBuilder priceTerms;
        protected RegulatoryReportingProductCalculationTerms.RegulatoryReportingProductCalculationTermsBuilder otherCalculationTerms;
        protected RegulatoryReportingNonCDEOptionDetails.RegulatoryReportingNonCDEOptionDetailsBuilder optionDetails;
        protected RegulatoryReportingProductSettlementDetails.RegulatoryReportingProductSettlementDetailsBuilder settlementDetails;
        protected List<RegReportingPayment.RegReportingPaymentBuilder> otherPayment = new ArrayList<RegReportingPayment.RegReportingPaymentBuilder>();
        protected RegulatoryReportingProductCreditDetails.RegulatoryReportingProductCreditDetailsBuilder creditDetails;
        protected RegulatoryReportingProductNonCDEFxDetails.RegulatoryReportingProductNonCDEFxDetailsBuilder fxDetails;
        protected RegulatoryReportingNonCDEProductCommodityDetails.RegulatoryReportingNonCDEProductCommodityDetailsBuilder commodityDetails;

        @Override
        @RosettaAttribute(value="parties")
        @RuneAttribute(value="parties")
        public RegulatoryReportingProductParties.RegulatoryReportingProductPartiesBuilder getParties() {
            return this.parties;
        }

        @Override
        public RegulatoryReportingProductParties.RegulatoryReportingProductPartiesBuilder getOrCreateParties() {
            RegulatoryReportingProductParties.RegulatoryReportingProductPartiesBuilder result = this.parties != null ? this.parties : (this.parties = RegulatoryReportingProductParties.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dates")
        @RuneAttribute(value="dates")
        public RegulatoryReportingProductDates.RegulatoryReportingProductDatesBuilder getDates() {
            return this.dates;
        }

        @Override
        public RegulatoryReportingProductDates.RegulatoryReportingProductDatesBuilder getOrCreateDates() {
            RegulatoryReportingProductDates.RegulatoryReportingProductDatesBuilder result = this.dates != null ? this.dates : (this.dates = RegulatoryReportingProductDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sizes")
        @RuneAttribute(value="sizes")
        public RegulatoryReportingProductSizes.RegulatoryReportingProductSizesBuilder getSizes() {
            return this.sizes;
        }

        @Override
        public RegulatoryReportingProductSizes.RegulatoryReportingProductSizesBuilder getOrCreateSizes() {
            RegulatoryReportingProductSizes.RegulatoryReportingProductSizesBuilder result = this.sizes != null ? this.sizes : (this.sizes = RegulatoryReportingProductSizes.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyers")
        @RuneAttribute(value="underlyers")
        public RegulatoryReportingProductUnderlyers.RegulatoryReportingProductUnderlyersBuilder getUnderlyers() {
            return this.underlyers;
        }

        @Override
        public RegulatoryReportingProductUnderlyers.RegulatoryReportingProductUnderlyersBuilder getOrCreateUnderlyers() {
            RegulatoryReportingProductUnderlyers.RegulatoryReportingProductUnderlyersBuilder result = this.underlyers != null ? this.underlyers : (this.underlyers = RegulatoryReportingProductUnderlyers.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceTerms")
        @RuneAttribute(value="priceTerms")
        public RegulatoryReportingProductPriceTerms.RegulatoryReportingProductPriceTermsBuilder getPriceTerms() {
            return this.priceTerms;
        }

        @Override
        public RegulatoryReportingProductPriceTerms.RegulatoryReportingProductPriceTermsBuilder getOrCreatePriceTerms() {
            RegulatoryReportingProductPriceTerms.RegulatoryReportingProductPriceTermsBuilder result = this.priceTerms != null ? this.priceTerms : (this.priceTerms = RegulatoryReportingProductPriceTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="otherCalculationTerms")
        @RuneAttribute(value="otherCalculationTerms")
        public RegulatoryReportingProductCalculationTerms.RegulatoryReportingProductCalculationTermsBuilder getOtherCalculationTerms() {
            return this.otherCalculationTerms;
        }

        @Override
        public RegulatoryReportingProductCalculationTerms.RegulatoryReportingProductCalculationTermsBuilder getOrCreateOtherCalculationTerms() {
            RegulatoryReportingProductCalculationTerms.RegulatoryReportingProductCalculationTermsBuilder result = this.otherCalculationTerms != null ? this.otherCalculationTerms : (this.otherCalculationTerms = RegulatoryReportingProductCalculationTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionDetails")
        @RuneAttribute(value="optionDetails")
        public RegulatoryReportingNonCDEOptionDetails.RegulatoryReportingNonCDEOptionDetailsBuilder getOptionDetails() {
            return this.optionDetails;
        }

        @Override
        public RegulatoryReportingNonCDEOptionDetails.RegulatoryReportingNonCDEOptionDetailsBuilder getOrCreateOptionDetails() {
            RegulatoryReportingNonCDEOptionDetails.RegulatoryReportingNonCDEOptionDetailsBuilder result = this.optionDetails != null ? this.optionDetails : (this.optionDetails = RegulatoryReportingNonCDEOptionDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDetails")
        @RuneAttribute(value="settlementDetails")
        public RegulatoryReportingProductSettlementDetails.RegulatoryReportingProductSettlementDetailsBuilder getSettlementDetails() {
            return this.settlementDetails;
        }

        @Override
        public RegulatoryReportingProductSettlementDetails.RegulatoryReportingProductSettlementDetailsBuilder getOrCreateSettlementDetails() {
            RegulatoryReportingProductSettlementDetails.RegulatoryReportingProductSettlementDetailsBuilder result = this.settlementDetails != null ? this.settlementDetails : (this.settlementDetails = RegulatoryReportingProductSettlementDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends RegReportingPayment.RegReportingPaymentBuilder> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        public RegReportingPayment.RegReportingPaymentBuilder getOrCreateOtherPayment(int index) {
            if (this.otherPayment == null) {
                this.otherPayment = new ArrayList<RegReportingPayment.RegReportingPaymentBuilder>();
            }
            return (RegReportingPayment.RegReportingPaymentBuilder)this.getIndex(this.otherPayment, index, () -> {
                RegReportingPayment.RegReportingPaymentBuilder newOtherPayment = RegReportingPayment.builder();
                return newOtherPayment;
            });
        }

        @Override
        @RosettaAttribute(value="creditDetails")
        @RuneAttribute(value="creditDetails")
        public RegulatoryReportingProductCreditDetails.RegulatoryReportingProductCreditDetailsBuilder getCreditDetails() {
            return this.creditDetails;
        }

        @Override
        public RegulatoryReportingProductCreditDetails.RegulatoryReportingProductCreditDetailsBuilder getOrCreateCreditDetails() {
            RegulatoryReportingProductCreditDetails.RegulatoryReportingProductCreditDetailsBuilder result = this.creditDetails != null ? this.creditDetails : (this.creditDetails = RegulatoryReportingProductCreditDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxDetails")
        @RuneAttribute(value="fxDetails")
        public RegulatoryReportingProductNonCDEFxDetails.RegulatoryReportingProductNonCDEFxDetailsBuilder getFxDetails() {
            return this.fxDetails;
        }

        @Override
        public RegulatoryReportingProductNonCDEFxDetails.RegulatoryReportingProductNonCDEFxDetailsBuilder getOrCreateFxDetails() {
            RegulatoryReportingProductNonCDEFxDetails.RegulatoryReportingProductNonCDEFxDetailsBuilder result = this.fxDetails != null ? this.fxDetails : (this.fxDetails = RegulatoryReportingProductNonCDEFxDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityDetails")
        @RuneAttribute(value="commodityDetails")
        public RegulatoryReportingNonCDEProductCommodityDetails.RegulatoryReportingNonCDEProductCommodityDetailsBuilder getCommodityDetails() {
            return this.commodityDetails;
        }

        @Override
        public RegulatoryReportingNonCDEProductCommodityDetails.RegulatoryReportingNonCDEProductCommodityDetailsBuilder getOrCreateCommodityDetails() {
            RegulatoryReportingNonCDEProductCommodityDetails.RegulatoryReportingNonCDEProductCommodityDetailsBuilder result = this.commodityDetails != null ? this.commodityDetails : (this.commodityDetails = RegulatoryReportingNonCDEProductCommodityDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public RegulatoryReportingProductBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public RegulatoryReportingProductBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="parties")
        @RuneAttribute(value="parties")
        public RegulatoryReportingProductBuilder setParties(RegulatoryReportingProductParties _parties) {
            this.parties = _parties == null ? null : _parties.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dates")
        @RuneAttribute(value="dates")
        public RegulatoryReportingProductBuilder setDates(RegulatoryReportingProductDates _dates) {
            this.dates = _dates == null ? null : _dates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sizes")
        @RuneAttribute(value="sizes")
        public RegulatoryReportingProductBuilder setSizes(RegulatoryReportingProductSizes _sizes) {
            this.sizes = _sizes == null ? null : _sizes.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyers")
        @RuneAttribute(value="underlyers")
        public RegulatoryReportingProductBuilder setUnderlyers(RegulatoryReportingProductUnderlyers _underlyers) {
            this.underlyers = _underlyers == null ? null : _underlyers.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceTerms")
        @RuneAttribute(value="priceTerms")
        public RegulatoryReportingProductBuilder setPriceTerms(RegulatoryReportingProductPriceTerms _priceTerms) {
            this.priceTerms = _priceTerms == null ? null : _priceTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherCalculationTerms")
        @RuneAttribute(value="otherCalculationTerms")
        public RegulatoryReportingProductBuilder setOtherCalculationTerms(RegulatoryReportingProductCalculationTerms _otherCalculationTerms) {
            this.otherCalculationTerms = _otherCalculationTerms == null ? null : _otherCalculationTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionDetails")
        @RuneAttribute(value="optionDetails")
        public RegulatoryReportingProductBuilder setOptionDetails(RegulatoryReportingNonCDEOptionDetails _optionDetails) {
            this.optionDetails = _optionDetails == null ? null : _optionDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDetails")
        @RuneAttribute(value="settlementDetails")
        public RegulatoryReportingProductBuilder setSettlementDetails(RegulatoryReportingProductSettlementDetails _settlementDetails) {
            this.settlementDetails = _settlementDetails == null ? null : _settlementDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public RegulatoryReportingProductBuilder addOtherPayment(RegReportingPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductBuilder addOtherPayment(RegReportingPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductBuilder addOtherPayment(List<? extends RegReportingPayment> otherPayments) {
            if (otherPayments != null) {
                for (RegReportingPayment regReportingPayment : otherPayments) {
                    this.otherPayment.add(regReportingPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public RegulatoryReportingProductBuilder setOtherPayment(List<? extends RegReportingPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList<RegReportingPayment.RegReportingPaymentBuilder>() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creditDetails")
        @RuneAttribute(value="creditDetails")
        public RegulatoryReportingProductBuilder setCreditDetails(RegulatoryReportingProductCreditDetails _creditDetails) {
            this.creditDetails = _creditDetails == null ? null : _creditDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxDetails")
        @RuneAttribute(value="fxDetails")
        public RegulatoryReportingProductBuilder setFxDetails(RegulatoryReportingProductNonCDEFxDetails _fxDetails) {
            this.fxDetails = _fxDetails == null ? null : _fxDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityDetails")
        @RuneAttribute(value="commodityDetails")
        public RegulatoryReportingProductBuilder setCommodityDetails(RegulatoryReportingNonCDEProductCommodityDetails _commodityDetails) {
            this.commodityDetails = _commodityDetails == null ? null : _commodityDetails.toBuilder();
            return this;
        }

        @Override
        public RegulatoryReportingProduct build() {
            return new RegulatoryReportingProductImpl(this);
        }

        @Override
        public RegulatoryReportingProductBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryReportingProductBuilder prune() {
            super.prune();
            if (this.parties != null && !this.parties.prune().hasData()) {
                this.parties = null;
            }
            if (this.dates != null && !this.dates.prune().hasData()) {
                this.dates = null;
            }
            if (this.sizes != null && !this.sizes.prune().hasData()) {
                this.sizes = null;
            }
            if (this.underlyers != null && !this.underlyers.prune().hasData()) {
                this.underlyers = null;
            }
            if (this.priceTerms != null && !this.priceTerms.prune().hasData()) {
                this.priceTerms = null;
            }
            if (this.otherCalculationTerms != null && !this.otherCalculationTerms.prune().hasData()) {
                this.otherCalculationTerms = null;
            }
            if (this.optionDetails != null && !this.optionDetails.prune().hasData()) {
                this.optionDetails = null;
            }
            if (this.settlementDetails != null && !this.settlementDetails.prune().hasData()) {
                this.settlementDetails = null;
            }
            this.otherPayment = this.otherPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.creditDetails != null && !this.creditDetails.prune().hasData()) {
                this.creditDetails = null;
            }
            if (this.fxDetails != null && !this.fxDetails.prune().hasData()) {
                this.fxDetails = null;
            }
            if (this.commodityDetails != null && !this.commodityDetails.prune().hasData()) {
                this.commodityDetails = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getParties() != null && this.getParties().hasData()) {
                return true;
            }
            if (this.getDates() != null && this.getDates().hasData()) {
                return true;
            }
            if (this.getSizes() != null && this.getSizes().hasData()) {
                return true;
            }
            if (this.getUnderlyers() != null && this.getUnderlyers().hasData()) {
                return true;
            }
            if (this.getPriceTerms() != null && this.getPriceTerms().hasData()) {
                return true;
            }
            if (this.getOtherCalculationTerms() != null && this.getOtherCalculationTerms().hasData()) {
                return true;
            }
            if (this.getOptionDetails() != null && this.getOptionDetails().hasData()) {
                return true;
            }
            if (this.getSettlementDetails() != null && this.getSettlementDetails().hasData()) {
                return true;
            }
            if (this.getOtherPayment() != null && this.getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCreditDetails() != null && this.getCreditDetails().hasData()) {
                return true;
            }
            if (this.getFxDetails() != null && this.getFxDetails().hasData()) {
                return true;
            }
            return this.getCommodityDetails() != null && this.getCommodityDetails().hasData();
        }

        @Override
        public RegulatoryReportingProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryReportingProductBuilder o = (RegulatoryReportingProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParties(), (RosettaModelObjectBuilder)o.getParties(), this::setParties);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDates(), (RosettaModelObjectBuilder)o.getDates(), this::setDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSizes(), (RosettaModelObjectBuilder)o.getSizes(), this::setSizes);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyers(), (RosettaModelObjectBuilder)o.getUnderlyers(), this::setUnderlyers);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceTerms(), (RosettaModelObjectBuilder)o.getPriceTerms(), this::setPriceTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOtherCalculationTerms(), (RosettaModelObjectBuilder)o.getOtherCalculationTerms(), this::setOtherCalculationTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionDetails(), (RosettaModelObjectBuilder)o.getOptionDetails(), this::setOptionDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDetails(), (RosettaModelObjectBuilder)o.getSettlementDetails(), this::setSettlementDetails);
            merger.mergeRosetta(this.getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditDetails(), (RosettaModelObjectBuilder)o.getCreditDetails(), this::setCreditDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxDetails(), (RosettaModelObjectBuilder)o.getFxDetails(), this::setFxDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityDetails(), (RosettaModelObjectBuilder)o.getCommodityDetails(), this::setCommodityDetails);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryReportingProduct _that = (RegulatoryReportingProduct)this.getType().cast(o);
            if (!Objects.equals(this.parties, _that.getParties())) {
                return false;
            }
            if (!Objects.equals(this.dates, _that.getDates())) {
                return false;
            }
            if (!Objects.equals(this.sizes, _that.getSizes())) {
                return false;
            }
            if (!Objects.equals(this.underlyers, _that.getUnderlyers())) {
                return false;
            }
            if (!Objects.equals(this.priceTerms, _that.getPriceTerms())) {
                return false;
            }
            if (!Objects.equals(this.otherCalculationTerms, _that.getOtherCalculationTerms())) {
                return false;
            }
            if (!Objects.equals(this.optionDetails, _that.getOptionDetails())) {
                return false;
            }
            if (!Objects.equals(this.settlementDetails, _that.getSettlementDetails())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.creditDetails, _that.getCreditDetails())) {
                return false;
            }
            if (!Objects.equals(this.fxDetails, _that.getFxDetails())) {
                return false;
            }
            return Objects.equals(this.commodityDetails, _that.getCommodityDetails());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            _result = 31 * _result + (this.dates != null ? this.dates.hashCode() : 0);
            _result = 31 * _result + (this.sizes != null ? this.sizes.hashCode() : 0);
            _result = 31 * _result + (this.underlyers != null ? this.underlyers.hashCode() : 0);
            _result = 31 * _result + (this.priceTerms != null ? this.priceTerms.hashCode() : 0);
            _result = 31 * _result + (this.otherCalculationTerms != null ? this.otherCalculationTerms.hashCode() : 0);
            _result = 31 * _result + (this.optionDetails != null ? this.optionDetails.hashCode() : 0);
            _result = 31 * _result + (this.settlementDetails != null ? this.settlementDetails.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.creditDetails != null ? this.creditDetails.hashCode() : 0);
            _result = 31 * _result + (this.fxDetails != null ? this.fxDetails.hashCode() : 0);
            _result = 31 * _result + (this.commodityDetails != null ? this.commodityDetails.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryReportingProductBuilder {parties=" + this.parties + ", dates=" + this.dates + ", sizes=" + this.sizes + ", underlyers=" + this.underlyers + ", priceTerms=" + this.priceTerms + ", otherCalculationTerms=" + this.otherCalculationTerms + ", optionDetails=" + this.optionDetails + ", settlementDetails=" + this.settlementDetails + ", otherPayment=" + this.otherPayment + ", creditDetails=" + this.creditDetails + ", fxDetails=" + this.fxDetails + ", commodityDetails=" + this.commodityDetails + '}' + " " + super.toString();
        }
    }

    public static interface RegulatoryReportingProductBuilder
    extends RegulatoryReportingProduct,
    Product.ProductBuilder {
        public RegulatoryReportingProductParties.RegulatoryReportingProductPartiesBuilder getOrCreateParties();

        @Override
        public RegulatoryReportingProductParties.RegulatoryReportingProductPartiesBuilder getParties();

        public RegulatoryReportingProductDates.RegulatoryReportingProductDatesBuilder getOrCreateDates();

        @Override
        public RegulatoryReportingProductDates.RegulatoryReportingProductDatesBuilder getDates();

        public RegulatoryReportingProductSizes.RegulatoryReportingProductSizesBuilder getOrCreateSizes();

        @Override
        public RegulatoryReportingProductSizes.RegulatoryReportingProductSizesBuilder getSizes();

        public RegulatoryReportingProductUnderlyers.RegulatoryReportingProductUnderlyersBuilder getOrCreateUnderlyers();

        @Override
        public RegulatoryReportingProductUnderlyers.RegulatoryReportingProductUnderlyersBuilder getUnderlyers();

        public RegulatoryReportingProductPriceTerms.RegulatoryReportingProductPriceTermsBuilder getOrCreatePriceTerms();

        @Override
        public RegulatoryReportingProductPriceTerms.RegulatoryReportingProductPriceTermsBuilder getPriceTerms();

        public RegulatoryReportingProductCalculationTerms.RegulatoryReportingProductCalculationTermsBuilder getOrCreateOtherCalculationTerms();

        @Override
        public RegulatoryReportingProductCalculationTerms.RegulatoryReportingProductCalculationTermsBuilder getOtherCalculationTerms();

        public RegulatoryReportingNonCDEOptionDetails.RegulatoryReportingNonCDEOptionDetailsBuilder getOrCreateOptionDetails();

        @Override
        public RegulatoryReportingNonCDEOptionDetails.RegulatoryReportingNonCDEOptionDetailsBuilder getOptionDetails();

        public RegulatoryReportingProductSettlementDetails.RegulatoryReportingProductSettlementDetailsBuilder getOrCreateSettlementDetails();

        @Override
        public RegulatoryReportingProductSettlementDetails.RegulatoryReportingProductSettlementDetailsBuilder getSettlementDetails();

        public RegReportingPayment.RegReportingPaymentBuilder getOrCreateOtherPayment(int var1);

        public List<? extends RegReportingPayment.RegReportingPaymentBuilder> getOtherPayment();

        public RegulatoryReportingProductCreditDetails.RegulatoryReportingProductCreditDetailsBuilder getOrCreateCreditDetails();

        @Override
        public RegulatoryReportingProductCreditDetails.RegulatoryReportingProductCreditDetailsBuilder getCreditDetails();

        public RegulatoryReportingProductNonCDEFxDetails.RegulatoryReportingProductNonCDEFxDetailsBuilder getOrCreateFxDetails();

        @Override
        public RegulatoryReportingProductNonCDEFxDetails.RegulatoryReportingProductNonCDEFxDetailsBuilder getFxDetails();

        public RegulatoryReportingNonCDEProductCommodityDetails.RegulatoryReportingNonCDEProductCommodityDetailsBuilder getOrCreateCommodityDetails();

        @Override
        public RegulatoryReportingNonCDEProductCommodityDetails.RegulatoryReportingNonCDEProductCommodityDetailsBuilder getCommodityDetails();

        @Override
        public RegulatoryReportingProductBuilder setProductModel(ProductModel var1);

        @Override
        public RegulatoryReportingProductBuilder setId(String var1);

        public RegulatoryReportingProductBuilder setParties(RegulatoryReportingProductParties var1);

        public RegulatoryReportingProductBuilder setDates(RegulatoryReportingProductDates var1);

        public RegulatoryReportingProductBuilder setSizes(RegulatoryReportingProductSizes var1);

        public RegulatoryReportingProductBuilder setUnderlyers(RegulatoryReportingProductUnderlyers var1);

        public RegulatoryReportingProductBuilder setPriceTerms(RegulatoryReportingProductPriceTerms var1);

        public RegulatoryReportingProductBuilder setOtherCalculationTerms(RegulatoryReportingProductCalculationTerms var1);

        public RegulatoryReportingProductBuilder setOptionDetails(RegulatoryReportingNonCDEOptionDetails var1);

        public RegulatoryReportingProductBuilder setSettlementDetails(RegulatoryReportingProductSettlementDetails var1);

        public RegulatoryReportingProductBuilder addOtherPayment(RegReportingPayment var1);

        public RegulatoryReportingProductBuilder addOtherPayment(RegReportingPayment var1, int var2);

        public RegulatoryReportingProductBuilder addOtherPayment(List<? extends RegReportingPayment> var1);

        public RegulatoryReportingProductBuilder setOtherPayment(List<? extends RegReportingPayment> var1);

        public RegulatoryReportingProductBuilder setCreditDetails(RegulatoryReportingProductCreditDetails var1);

        public RegulatoryReportingProductBuilder setFxDetails(RegulatoryReportingProductNonCDEFxDetails var1);

        public RegulatoryReportingProductBuilder setCommodityDetails(RegulatoryReportingNonCDEProductCommodityDetails var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("parties"), processor, RegulatoryReportingProductParties.RegulatoryReportingProductPartiesBuilder.class, this.getParties(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dates"), processor, RegulatoryReportingProductDates.RegulatoryReportingProductDatesBuilder.class, this.getDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sizes"), processor, RegulatoryReportingProductSizes.RegulatoryReportingProductSizesBuilder.class, this.getSizes(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyers"), processor, RegulatoryReportingProductUnderlyers.RegulatoryReportingProductUnderlyersBuilder.class, this.getUnderlyers(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceTerms"), processor, RegulatoryReportingProductPriceTerms.RegulatoryReportingProductPriceTermsBuilder.class, this.getPriceTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherCalculationTerms"), processor, RegulatoryReportingProductCalculationTerms.RegulatoryReportingProductCalculationTermsBuilder.class, this.getOtherCalculationTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionDetails"), processor, RegulatoryReportingNonCDEOptionDetails.RegulatoryReportingNonCDEOptionDetailsBuilder.class, this.getOptionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDetails"), processor, RegulatoryReportingProductSettlementDetails.RegulatoryReportingProductSettlementDetailsBuilder.class, this.getSettlementDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, RegReportingPayment.RegReportingPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditDetails"), processor, RegulatoryReportingProductCreditDetails.RegulatoryReportingProductCreditDetailsBuilder.class, this.getCreditDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxDetails"), processor, RegulatoryReportingProductNonCDEFxDetails.RegulatoryReportingProductNonCDEFxDetailsBuilder.class, this.getFxDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityDetails"), processor, RegulatoryReportingNonCDEProductCommodityDetails.RegulatoryReportingNonCDEProductCommodityDetailsBuilder.class, this.getCommodityDetails(), new AttributeMeta[0]);
        }

        @Override
        public RegulatoryReportingProductBuilder prune();
    }

    public static class RegulatoryReportingProductImpl
    extends Product.ProductImpl
    implements RegulatoryReportingProduct {
        private final RegulatoryReportingProductParties parties;
        private final RegulatoryReportingProductDates dates;
        private final RegulatoryReportingProductSizes sizes;
        private final RegulatoryReportingProductUnderlyers underlyers;
        private final RegulatoryReportingProductPriceTerms priceTerms;
        private final RegulatoryReportingProductCalculationTerms otherCalculationTerms;
        private final RegulatoryReportingNonCDEOptionDetails optionDetails;
        private final RegulatoryReportingProductSettlementDetails settlementDetails;
        private final List<? extends RegReportingPayment> otherPayment;
        private final RegulatoryReportingProductCreditDetails creditDetails;
        private final RegulatoryReportingProductNonCDEFxDetails fxDetails;
        private final RegulatoryReportingNonCDEProductCommodityDetails commodityDetails;

        protected RegulatoryReportingProductImpl(RegulatoryReportingProductBuilder builder) {
            super(builder);
            this.parties = Optional.ofNullable(builder.getParties()).map(f -> f.build()).orElse(null);
            this.dates = Optional.ofNullable(builder.getDates()).map(f -> f.build()).orElse(null);
            this.sizes = Optional.ofNullable(builder.getSizes()).map(f -> f.build()).orElse(null);
            this.underlyers = Optional.ofNullable(builder.getUnderlyers()).map(f -> f.build()).orElse(null);
            this.priceTerms = Optional.ofNullable(builder.getPriceTerms()).map(f -> f.build()).orElse(null);
            this.otherCalculationTerms = Optional.ofNullable(builder.getOtherCalculationTerms()).map(f -> f.build()).orElse(null);
            this.optionDetails = Optional.ofNullable(builder.getOptionDetails()).map(f -> f.build()).orElse(null);
            this.settlementDetails = Optional.ofNullable(builder.getSettlementDetails()).map(f -> f.build()).orElse(null);
            this.otherPayment = Optional.ofNullable(builder.getOtherPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.creditDetails = Optional.ofNullable(builder.getCreditDetails()).map(f -> f.build()).orElse(null);
            this.fxDetails = Optional.ofNullable(builder.getFxDetails()).map(f -> f.build()).orElse(null);
            this.commodityDetails = Optional.ofNullable(builder.getCommodityDetails()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="parties")
        @RuneAttribute(value="parties")
        public RegulatoryReportingProductParties getParties() {
            return this.parties;
        }

        @Override
        @RosettaAttribute(value="dates")
        @RuneAttribute(value="dates")
        public RegulatoryReportingProductDates getDates() {
            return this.dates;
        }

        @Override
        @RosettaAttribute(value="sizes")
        @RuneAttribute(value="sizes")
        public RegulatoryReportingProductSizes getSizes() {
            return this.sizes;
        }

        @Override
        @RosettaAttribute(value="underlyers")
        @RuneAttribute(value="underlyers")
        public RegulatoryReportingProductUnderlyers getUnderlyers() {
            return this.underlyers;
        }

        @Override
        @RosettaAttribute(value="priceTerms")
        @RuneAttribute(value="priceTerms")
        public RegulatoryReportingProductPriceTerms getPriceTerms() {
            return this.priceTerms;
        }

        @Override
        @RosettaAttribute(value="otherCalculationTerms")
        @RuneAttribute(value="otherCalculationTerms")
        public RegulatoryReportingProductCalculationTerms getOtherCalculationTerms() {
            return this.otherCalculationTerms;
        }

        @Override
        @RosettaAttribute(value="optionDetails")
        @RuneAttribute(value="optionDetails")
        public RegulatoryReportingNonCDEOptionDetails getOptionDetails() {
            return this.optionDetails;
        }

        @Override
        @RosettaAttribute(value="settlementDetails")
        @RuneAttribute(value="settlementDetails")
        public RegulatoryReportingProductSettlementDetails getSettlementDetails() {
            return this.settlementDetails;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends RegReportingPayment> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        @RosettaAttribute(value="creditDetails")
        @RuneAttribute(value="creditDetails")
        public RegulatoryReportingProductCreditDetails getCreditDetails() {
            return this.creditDetails;
        }

        @Override
        @RosettaAttribute(value="fxDetails")
        @RuneAttribute(value="fxDetails")
        public RegulatoryReportingProductNonCDEFxDetails getFxDetails() {
            return this.fxDetails;
        }

        @Override
        @RosettaAttribute(value="commodityDetails")
        @RuneAttribute(value="commodityDetails")
        public RegulatoryReportingNonCDEProductCommodityDetails getCommodityDetails() {
            return this.commodityDetails;
        }

        @Override
        public RegulatoryReportingProduct build() {
            return this;
        }

        @Override
        public RegulatoryReportingProductBuilder toBuilder() {
            RegulatoryReportingProductBuilder builder = RegulatoryReportingProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryReportingProductBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getParties()).ifPresent(builder::setParties);
            Optional.ofNullable(this.getDates()).ifPresent(builder::setDates);
            Optional.ofNullable(this.getSizes()).ifPresent(builder::setSizes);
            Optional.ofNullable(this.getUnderlyers()).ifPresent(builder::setUnderlyers);
            Optional.ofNullable(this.getPriceTerms()).ifPresent(builder::setPriceTerms);
            Optional.ofNullable(this.getOtherCalculationTerms()).ifPresent(builder::setOtherCalculationTerms);
            Optional.ofNullable(this.getOptionDetails()).ifPresent(builder::setOptionDetails);
            Optional.ofNullable(this.getSettlementDetails()).ifPresent(builder::setSettlementDetails);
            Optional.ofNullable(this.getOtherPayment()).ifPresent(builder::setOtherPayment);
            Optional.ofNullable(this.getCreditDetails()).ifPresent(builder::setCreditDetails);
            Optional.ofNullable(this.getFxDetails()).ifPresent(builder::setFxDetails);
            Optional.ofNullable(this.getCommodityDetails()).ifPresent(builder::setCommodityDetails);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryReportingProduct _that = (RegulatoryReportingProduct)this.getType().cast(o);
            if (!Objects.equals(this.parties, _that.getParties())) {
                return false;
            }
            if (!Objects.equals(this.dates, _that.getDates())) {
                return false;
            }
            if (!Objects.equals(this.sizes, _that.getSizes())) {
                return false;
            }
            if (!Objects.equals(this.underlyers, _that.getUnderlyers())) {
                return false;
            }
            if (!Objects.equals(this.priceTerms, _that.getPriceTerms())) {
                return false;
            }
            if (!Objects.equals(this.otherCalculationTerms, _that.getOtherCalculationTerms())) {
                return false;
            }
            if (!Objects.equals(this.optionDetails, _that.getOptionDetails())) {
                return false;
            }
            if (!Objects.equals(this.settlementDetails, _that.getSettlementDetails())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.creditDetails, _that.getCreditDetails())) {
                return false;
            }
            if (!Objects.equals(this.fxDetails, _that.getFxDetails())) {
                return false;
            }
            return Objects.equals(this.commodityDetails, _that.getCommodityDetails());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.parties != null ? this.parties.hashCode() : 0);
            _result = 31 * _result + (this.dates != null ? this.dates.hashCode() : 0);
            _result = 31 * _result + (this.sizes != null ? this.sizes.hashCode() : 0);
            _result = 31 * _result + (this.underlyers != null ? this.underlyers.hashCode() : 0);
            _result = 31 * _result + (this.priceTerms != null ? this.priceTerms.hashCode() : 0);
            _result = 31 * _result + (this.otherCalculationTerms != null ? this.otherCalculationTerms.hashCode() : 0);
            _result = 31 * _result + (this.optionDetails != null ? this.optionDetails.hashCode() : 0);
            _result = 31 * _result + (this.settlementDetails != null ? this.settlementDetails.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.creditDetails != null ? this.creditDetails.hashCode() : 0);
            _result = 31 * _result + (this.fxDetails != null ? this.fxDetails.hashCode() : 0);
            _result = 31 * _result + (this.commodityDetails != null ? this.commodityDetails.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryReportingProduct {parties=" + this.parties + ", dates=" + this.dates + ", sizes=" + this.sizes + ", underlyers=" + this.underlyers + ", priceTerms=" + this.priceTerms + ", otherCalculationTerms=" + this.otherCalculationTerms + ", optionDetails=" + this.optionDetails + ", settlementDetails=" + this.settlementDetails + ", otherPayment=" + this.otherPayment + ", creditDetails=" + this.creditDetails + ", fxDetails=" + this.fxDetails + ", commodityDetails=" + this.commodityDetails + '}' + " " + super.toString();
        }
    }
}

