/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.recordkeeping.processes.ESMAProductUnderlyer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ESMAProductUnderlyerChoice")
@ImplementedBy(value=Default.class)
public interface ESMAProductUnderlyerChoice
extends Validator<ESMAProductUnderlyer> {
    public static final String NAME = "ESMAProductUnderlyerChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ESMAProductUnderlyerChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAProductUnderlyer eSMAProductUnderlyer) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAProductUnderlyerChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAProductUnderlyer eSMAProductUnderlyer) {
            ComparisonResult result = this.executeDataRule(eSMAProductUnderlyer);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAProductUnderlyerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAProductUnderlyer", (RosettaPath)path, (String)ESMAProductUnderlyerChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAProductUnderlyerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAProductUnderlyer", (RosettaPath)path, (String)ESMAProductUnderlyerChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAProductUnderlyer eSMAProductUnderlyer) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)eSMAProductUnderlyer), Arrays.asList("esmaProductUnderlyerSequence", "maturityDate"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

