/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.recordkeeping.processes.meta.NonpublicExecutionReportRetractedSequenceMeta;
import fpml.consolidated.shared.AssetClass;
import fpml.consolidated.shared.RelatedParty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="NonpublicExecutionReportRetractedSequence", builder=NonpublicExecutionReportRetractedSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="NonpublicExecutionReportRetractedSequence", model="fpml", builder=NonpublicExecutionReportRetractedSequenceBuilderImpl.class, version="1.1.0")
public interface NonpublicExecutionReportRetractedSequence
extends RosettaModelObject {
    public static final NonpublicExecutionReportRetractedSequenceMeta metaData = new NonpublicExecutionReportRetractedSequenceMeta();

    public AssetClass getPrimaryAssetClass();

    public PartyTradeIdentifier getTradeIdentifier();

    public List<? extends BusinessEventIdentifier> getEventIdentifier();

    public List<? extends RelatedParty> getRelatedParty();

    public NonpublicExecutionReportRetractedSequence build();

    public NonpublicExecutionReportRetractedSequenceBuilder toBuilder();

    public static NonpublicExecutionReportRetractedSequenceBuilder builder() {
        return new NonpublicExecutionReportRetractedSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends NonpublicExecutionReportRetractedSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonpublicExecutionReportRetractedSequence> getType() {
        return NonpublicExecutionReportRetractedSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
    }

    public static class NonpublicExecutionReportRetractedSequenceBuilderImpl
    implements NonpublicExecutionReportRetractedSequenceBuilder {
        protected AssetClass.AssetClassBuilder primaryAssetClass;
        protected PartyTradeIdentifier.PartyTradeIdentifierBuilder tradeIdentifier;
        protected List<BusinessEventIdentifier.BusinessEventIdentifierBuilder> eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass.AssetClassBuilder getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass() {
            AssetClass.AssetClassBuilder result = this.primaryAssetClass != null ? this.primaryAssetClass : (this.primaryAssetClass = AssetClass.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier() {
            PartyTradeIdentifier.PartyTradeIdentifierBuilder result = this.tradeIdentifier != null ? this.tradeIdentifier : (this.tradeIdentifier = PartyTradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int index) {
            if (this.eventIdentifier == null) {
                this.eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();
            }
            return (BusinessEventIdentifier.BusinessEventIdentifierBuilder)this.getIndex(this.eventIdentifier, index, () -> {
                BusinessEventIdentifier.BusinessEventIdentifierBuilder newEventIdentifier = BusinessEventIdentifier.builder();
                return newEventIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public NonpublicExecutionReportRetractedSequenceBuilder setPrimaryAssetClass(AssetClass _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public NonpublicExecutionReportRetractedSequenceBuilder setTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            this.tradeIdentifier = _tradeIdentifier == null ? null : _tradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public NonpublicExecutionReportRetractedSequenceBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedSequenceBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedSequenceBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public NonpublicExecutionReportRetractedSequenceBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public NonpublicExecutionReportRetractedSequenceBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedSequenceBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedSequenceBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public NonpublicExecutionReportRetractedSequenceBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedSequence build() {
            return new NonpublicExecutionReportRetractedSequenceImpl(this);
        }

        @Override
        public NonpublicExecutionReportRetractedSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedSequenceBuilder prune() {
            if (this.primaryAssetClass != null && !this.primaryAssetClass.prune().hasData()) {
                this.primaryAssetClass = null;
            }
            if (this.tradeIdentifier != null && !this.tradeIdentifier.prune().hasData()) {
                this.tradeIdentifier = null;
            }
            this.eventIdentifier = this.eventIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPrimaryAssetClass() != null && this.getPrimaryAssetClass().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getEventIdentifier() != null && this.getEventIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public NonpublicExecutionReportRetractedSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NonpublicExecutionReportRetractedSequenceBuilder o = (NonpublicExecutionReportRetractedSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)o.getPrimaryAssetClass(), this::setPrimaryAssetClass);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeIdentifier(), (RosettaModelObjectBuilder)o.getTradeIdentifier(), this::setTradeIdentifier);
            merger.mergeRosetta(this.getEventIdentifier(), o.getEventIdentifier(), this::getOrCreateEventIdentifier);
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonpublicExecutionReportRetractedSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedParty, _that.getRelatedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonpublicExecutionReportRetractedSequenceBuilder {primaryAssetClass=" + this.primaryAssetClass + ", tradeIdentifier=" + this.tradeIdentifier + ", eventIdentifier=" + this.eventIdentifier + ", relatedParty=" + this.relatedParty + '}';
        }
    }

    public static interface NonpublicExecutionReportRetractedSequenceBuilder
    extends NonpublicExecutionReportRetractedSequence,
    RosettaModelObjectBuilder {
        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass();

        @Override
        public AssetClass.AssetClassBuilder getPrimaryAssetClass();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier();

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getTradeIdentifier();

        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int var1);

        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier();

        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public NonpublicExecutionReportRetractedSequenceBuilder setPrimaryAssetClass(AssetClass var1);

        public NonpublicExecutionReportRetractedSequenceBuilder setTradeIdentifier(PartyTradeIdentifier var1);

        public NonpublicExecutionReportRetractedSequenceBuilder addEventIdentifier(BusinessEventIdentifier var1);

        public NonpublicExecutionReportRetractedSequenceBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        public NonpublicExecutionReportRetractedSequenceBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public NonpublicExecutionReportRetractedSequenceBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public NonpublicExecutionReportRetractedSequenceBuilder addRelatedParty(RelatedParty var1);

        public NonpublicExecutionReportRetractedSequenceBuilder addRelatedParty(RelatedParty var1, int var2);

        public NonpublicExecutionReportRetractedSequenceBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public NonpublicExecutionReportRetractedSequenceBuilder setRelatedParty(List<? extends RelatedParty> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.AssetClassBuilder.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
        }

        public NonpublicExecutionReportRetractedSequenceBuilder prune();
    }

    public static class NonpublicExecutionReportRetractedSequenceImpl
    implements NonpublicExecutionReportRetractedSequence {
        private final AssetClass primaryAssetClass;
        private final PartyTradeIdentifier tradeIdentifier;
        private final List<? extends BusinessEventIdentifier> eventIdentifier;
        private final List<? extends RelatedParty> relatedParty;

        protected NonpublicExecutionReportRetractedSequenceImpl(NonpublicExecutionReportRetractedSequenceBuilder builder) {
            this.primaryAssetClass = Optional.ofNullable(builder.getPrimaryAssetClass()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.eventIdentifier = Optional.ofNullable(builder.getEventIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public PartyTradeIdentifier getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends BusinessEventIdentifier> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public NonpublicExecutionReportRetractedSequence build() {
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedSequenceBuilder toBuilder() {
            NonpublicExecutionReportRetractedSequenceBuilder builder = NonpublicExecutionReportRetractedSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonpublicExecutionReportRetractedSequenceBuilder builder) {
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonpublicExecutionReportRetractedSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedParty, _that.getRelatedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonpublicExecutionReportRetractedSequence {primaryAssetClass=" + this.primaryAssetClass + ", tradeIdentifier=" + this.tradeIdentifier + ", eventIdentifier=" + this.eventIdentifier + ", relatedParty=" + this.relatedParty + '}';
        }
    }
}

