/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.option.shared.OptionNumericStrike;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="OptionNumericStrikeChoice")
@ImplementedBy(value=Default.class)
public interface OptionNumericStrikeChoice
extends Validator<OptionNumericStrike> {
    public static final String NAME = "OptionNumericStrikeChoice";
    public static final String DEFINITION = "optional choice strikePrice, strikePercentage";

    public static class NoOp
    implements OptionNumericStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionNumericStrike optionNumericStrike) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements OptionNumericStrikeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionNumericStrike optionNumericStrike) {
            ComparisonResult result = this.executeDataRule(optionNumericStrike);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)OptionNumericStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionNumericStrike", (RosettaPath)path, (String)OptionNumericStrikeChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)OptionNumericStrikeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"OptionNumericStrike", (RosettaPath)path, (String)OptionNumericStrikeChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(OptionNumericStrike optionNumericStrike) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)optionNumericStrike), Arrays.asList("strikePrice", "strikePercentage"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

