/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.option.shared.FeaturePayment;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FeaturePaymentChoice")
@ImplementedBy(value=Default.class)
public interface FeaturePaymentChoice
extends Validator<FeaturePayment> {
    public static final String NAME = "FeaturePaymentChoice";
    public static final String DEFINITION = "optional choice levelPercentage, amount";

    public static class NoOp
    implements FeaturePaymentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FeaturePayment featurePayment) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FeaturePaymentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FeaturePayment featurePayment) {
            ComparisonResult result = this.executeDataRule(featurePayment);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FeaturePaymentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FeaturePayment", (RosettaPath)path, (String)FeaturePaymentChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FeaturePaymentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FeaturePayment", (RosettaPath)path, (String)FeaturePaymentChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FeaturePayment featurePayment) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)featurePayment), Arrays.asList("levelPercentage", "amount"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

