/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.option.shared.meta.ClassifiablePaymentMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.NonNegativePayment;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.PaymentType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ClassifiablePayment", builder=ClassifiablePaymentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ClassifiablePayment", model="fpml", builder=ClassifiablePaymentBuilderImpl.class, version="1.1.0")
public interface ClassifiablePayment
extends NonNegativePayment {
    public static final ClassifiablePaymentMeta metaData = new ClassifiablePaymentMeta();

    public List<? extends PaymentType> getPaymentType();

    @Override
    public ClassifiablePayment build();

    @Override
    public ClassifiablePaymentBuilder toBuilder();

    public static ClassifiablePaymentBuilder builder() {
        return new ClassifiablePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends ClassifiablePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ClassifiablePayment> getType() {
        return ClassifiablePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentType"), processor, PaymentType.class, this.getPaymentType(), new AttributeMeta[0]);
    }

    public static class ClassifiablePaymentBuilderImpl
    extends NonNegativePayment.NonNegativePaymentBuilderImpl
    implements ClassifiablePaymentBuilder {
        protected List<PaymentType.PaymentTypeBuilder> paymentType = new ArrayList<PaymentType.PaymentTypeBuilder>();

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public List<? extends PaymentType.PaymentTypeBuilder> getPaymentType() {
            return this.paymentType;
        }

        @Override
        public PaymentType.PaymentTypeBuilder getOrCreatePaymentType(int index) {
            if (this.paymentType == null) {
                this.paymentType = new ArrayList<PaymentType.PaymentTypeBuilder>();
            }
            return (PaymentType.PaymentTypeBuilder)this.getIndex(this.paymentType, index, () -> {
                PaymentType.PaymentTypeBuilder newPaymentType = PaymentType.builder();
                return newPaymentType;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ClassifiablePaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public ClassifiablePaymentBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public ClassifiablePaymentBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public ClassifiablePaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public ClassifiablePaymentBuilder addPaymentType(PaymentType _paymentType) {
            if (_paymentType != null) {
                this.paymentType.add(_paymentType.toBuilder());
            }
            return this;
        }

        @Override
        public ClassifiablePaymentBuilder addPaymentType(PaymentType _paymentType, int idx) {
            this.getIndex(this.paymentType, idx, () -> _paymentType.toBuilder());
            return this;
        }

        @Override
        public ClassifiablePaymentBuilder addPaymentType(List<? extends PaymentType> paymentTypes) {
            if (paymentTypes != null) {
                for (PaymentType paymentType : paymentTypes) {
                    this.paymentType.add(paymentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentType")
        public ClassifiablePaymentBuilder setPaymentType(List<? extends PaymentType> paymentTypes) {
            this.paymentType = paymentTypes == null ? new ArrayList<PaymentType.PaymentTypeBuilder>() : (List)paymentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ClassifiablePayment build() {
            return new ClassifiablePaymentImpl(this);
        }

        @Override
        public ClassifiablePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public ClassifiablePaymentBuilder prune() {
            super.prune();
            this.paymentType = this.paymentType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPaymentType() != null && this.getPaymentType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ClassifiablePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ClassifiablePaymentBuilder o = (ClassifiablePaymentBuilder)other;
            merger.mergeRosetta(this.getPaymentType(), o.getPaymentType(), this::getOrCreatePaymentType);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClassifiablePayment _that = (ClassifiablePayment)this.getType().cast(o);
            return ListEquals.listEquals(this.paymentType, _that.getPaymentType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentType != null ? this.paymentType.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClassifiablePaymentBuilder {paymentType=" + this.paymentType + '}' + " " + super.toString();
        }
    }

    public static interface ClassifiablePaymentBuilder
    extends ClassifiablePayment,
    NonNegativePayment.NonNegativePaymentBuilder {
        public PaymentType.PaymentTypeBuilder getOrCreatePaymentType(int var1);

        public List<? extends PaymentType.PaymentTypeBuilder> getPaymentType();

        @Override
        public ClassifiablePaymentBuilder setId(String var1);

        @Override
        public ClassifiablePaymentBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public ClassifiablePaymentBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        @Override
        public ClassifiablePaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        public ClassifiablePaymentBuilder addPaymentType(PaymentType var1);

        public ClassifiablePaymentBuilder addPaymentType(PaymentType var1, int var2);

        public ClassifiablePaymentBuilder addPaymentType(List<? extends PaymentType> var1);

        public ClassifiablePaymentBuilder setPaymentType(List<? extends PaymentType> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentType"), processor, PaymentType.PaymentTypeBuilder.class, this.getPaymentType(), new AttributeMeta[0]);
        }

        @Override
        public ClassifiablePaymentBuilder prune();
    }

    public static class ClassifiablePaymentImpl
    extends NonNegativePayment.NonNegativePaymentImpl
    implements ClassifiablePayment {
        private final List<? extends PaymentType> paymentType;

        protected ClassifiablePaymentImpl(ClassifiablePaymentBuilder builder) {
            super(builder);
            this.paymentType = Optional.ofNullable(builder.getPaymentType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public List<? extends PaymentType> getPaymentType() {
            return this.paymentType;
        }

        @Override
        public ClassifiablePayment build() {
            return this;
        }

        @Override
        public ClassifiablePaymentBuilder toBuilder() {
            ClassifiablePaymentBuilder builder = ClassifiablePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClassifiablePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentType()).ifPresent(builder::setPaymentType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClassifiablePayment _that = (ClassifiablePayment)this.getType().cast(o);
            return ListEquals.listEquals(this.paymentType, _that.getPaymentType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentType != null ? this.paymentType.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ClassifiablePayment {paymentType=" + this.paymentType + '}' + " " + super.toString();
        }
    }
}

