/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.msg;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.msg.ImplementationSpecificationVersion;
import fpml.consolidated.msg.meta.ImplementationSpecificationMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ImplementationSpecification", builder=ImplementationSpecificationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ImplementationSpecification", model="fpml", builder=ImplementationSpecificationBuilderImpl.class, version="1.1.0")
public interface ImplementationSpecification
extends RosettaModelObject {
    public static final ImplementationSpecificationMeta metaData = new ImplementationSpecificationMeta();

    public String getName();

    public ImplementationSpecificationVersion getVersion();

    public ZonedDateTime getDate();

    public ImplementationSpecification build();

    public ImplementationSpecificationBuilder toBuilder();

    public static ImplementationSpecificationBuilder builder() {
        return new ImplementationSpecificationBuilderImpl();
    }

    default public RosettaMetaData<? extends ImplementationSpecification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ImplementationSpecification> getType() {
        return ImplementationSpecification.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("version"), processor, ImplementationSpecificationVersion.class, this.getVersion(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ImplementationSpecificationBuilderImpl
    implements ImplementationSpecificationBuilder {
        protected String name;
        protected ImplementationSpecificationVersion.ImplementationSpecificationVersionBuilder version;
        protected ZonedDateTime date;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public ImplementationSpecificationVersion.ImplementationSpecificationVersionBuilder getVersion() {
            return this.version;
        }

        @Override
        public ImplementationSpecificationVersion.ImplementationSpecificationVersionBuilder getOrCreateVersion() {
            ImplementationSpecificationVersion.ImplementationSpecificationVersionBuilder result = this.version != null ? this.version : (this.version = ImplementationSpecificationVersion.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public ImplementationSpecificationBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public ImplementationSpecificationBuilder setVersion(ImplementationSpecificationVersion _version) {
            this.version = _version == null ? null : _version.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ImplementationSpecificationBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        public ImplementationSpecification build() {
            return new ImplementationSpecificationImpl(this);
        }

        @Override
        public ImplementationSpecificationBuilder toBuilder() {
            return this;
        }

        @Override
        public ImplementationSpecificationBuilder prune() {
            if (this.version != null && !this.version.prune().hasData()) {
                this.version = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getVersion() != null && this.getVersion().hasData()) {
                return true;
            }
            return this.getDate() != null;
        }

        public ImplementationSpecificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ImplementationSpecificationBuilder o = (ImplementationSpecificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVersion(), (RosettaModelObjectBuilder)o.getVersion(), this::setVersion);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ImplementationSpecification _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.version, _that.getVersion())) {
                return false;
            }
            return Objects.equals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ImplementationSpecificationBuilder {name=" + this.name + ", version=" + this.version + ", date=" + this.date + '}';
        }
    }

    public static interface ImplementationSpecificationBuilder
    extends ImplementationSpecification,
    RosettaModelObjectBuilder {
        public ImplementationSpecificationVersion.ImplementationSpecificationVersionBuilder getOrCreateVersion();

        @Override
        public ImplementationSpecificationVersion.ImplementationSpecificationVersionBuilder getVersion();

        public ImplementationSpecificationBuilder setName(String var1);

        public ImplementationSpecificationBuilder setVersion(ImplementationSpecificationVersion var1);

        public ImplementationSpecificationBuilder setDate(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("version"), processor, ImplementationSpecificationVersion.ImplementationSpecificationVersionBuilder.class, this.getVersion(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ImplementationSpecificationBuilder prune();
    }

    public static class ImplementationSpecificationImpl
    implements ImplementationSpecification {
        private final String name;
        private final ImplementationSpecificationVersion version;
        private final ZonedDateTime date;

        protected ImplementationSpecificationImpl(ImplementationSpecificationBuilder builder) {
            this.name = builder.getName();
            this.version = Optional.ofNullable(builder.getVersion()).map(f -> f.build()).orElse(null);
            this.date = builder.getDate();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public ImplementationSpecificationVersion getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        public ImplementationSpecification build() {
            return this;
        }

        @Override
        public ImplementationSpecificationBuilder toBuilder() {
            ImplementationSpecificationBuilder builder = ImplementationSpecification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ImplementationSpecificationBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ImplementationSpecification _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.version, _that.getVersion())) {
                return false;
            }
            return Objects.equals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ImplementationSpecification {name=" + this.name + ", version=" + this.version + ", date=" + this.date + '}';
        }
    }
}

