/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CreditEntityModel;
import fpml.consolidated.cd.DeliverableObligations;
import fpml.consolidated.cd.Obligations;
import fpml.consolidated.mktenv.meta.CreditCurveCharacteristicsModelMeta;
import fpml.consolidated.option.shared.CreditEvents;
import fpml.consolidated.shared.CreditSeniority;
import fpml.consolidated.shared.Currency;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CreditCurveCharacteristicsModel", builder=CreditCurveCharacteristicsModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CreditCurveCharacteristicsModel", model="fpml", builder=CreditCurveCharacteristicsModelBuilderImpl.class, version="1.1.0")
public interface CreditCurveCharacteristicsModel
extends RosettaModelObject {
    public static final CreditCurveCharacteristicsModelMeta metaData = new CreditCurveCharacteristicsModelMeta();

    public CreditEntityModel getCreditEntityModel();

    public CreditEvents getCreditEvents();

    public CreditSeniority getSeniority();

    public Boolean getSecured();

    public Currency getObligationCurrency();

    public Obligations getObligations();

    public DeliverableObligations getDeliverableObligations();

    public CreditCurveCharacteristicsModel build();

    public CreditCurveCharacteristicsModelBuilder toBuilder();

    public static CreditCurveCharacteristicsModelBuilder builder() {
        return new CreditCurveCharacteristicsModelBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditCurveCharacteristicsModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditCurveCharacteristicsModel> getType() {
        return CreditCurveCharacteristicsModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("creditEntityModel"), processor, CreditEntityModel.class, this.getCreditEntityModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEvents"), processor, CreditEvents.class, this.getCreditEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.class, this.getSeniority(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secured"), Boolean.class, (Object)this.getSecured(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("obligationCurrency"), processor, Currency.class, this.getObligationCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("obligations"), processor, Obligations.class, this.getObligations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliverableObligations"), processor, DeliverableObligations.class, this.getDeliverableObligations(), new AttributeMeta[0]);
    }

    public static class CreditCurveCharacteristicsModelBuilderImpl
    implements CreditCurveCharacteristicsModelBuilder {
        protected CreditEntityModel.CreditEntityModelBuilder creditEntityModel;
        protected CreditEvents.CreditEventsBuilder creditEvents;
        protected CreditSeniority.CreditSeniorityBuilder seniority;
        protected Boolean secured;
        protected Currency.CurrencyBuilder obligationCurrency;
        protected Obligations.ObligationsBuilder obligations;
        protected DeliverableObligations.DeliverableObligationsBuilder deliverableObligations;

        @Override
        @RosettaAttribute(value="creditEntityModel", isRequired=true)
        @RuneAttribute(value="creditEntityModel", isRequired=true)
        public CreditEntityModel.CreditEntityModelBuilder getCreditEntityModel() {
            return this.creditEntityModel;
        }

        @Override
        public CreditEntityModel.CreditEntityModelBuilder getOrCreateCreditEntityModel() {
            CreditEntityModel.CreditEntityModelBuilder result = this.creditEntityModel != null ? this.creditEntityModel : (this.creditEntityModel = CreditEntityModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditEvents")
        @RuneAttribute(value="creditEvents")
        public CreditEvents.CreditEventsBuilder getCreditEvents() {
            return this.creditEvents;
        }

        @Override
        public CreditEvents.CreditEventsBuilder getOrCreateCreditEvents() {
            CreditEvents.CreditEventsBuilder result = this.creditEvents != null ? this.creditEvents : (this.creditEvents = CreditEvents.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority.CreditSeniorityBuilder getSeniority() {
            return this.seniority;
        }

        @Override
        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority() {
            CreditSeniority.CreditSeniorityBuilder result = this.seniority != null ? this.seniority : (this.seniority = CreditSeniority.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="secured")
        @RuneAttribute(value="secured")
        public Boolean getSecured() {
            return this.secured;
        }

        @Override
        @RosettaAttribute(value="obligationCurrency")
        @RuneAttribute(value="obligationCurrency")
        public Currency.CurrencyBuilder getObligationCurrency() {
            return this.obligationCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateObligationCurrency() {
            Currency.CurrencyBuilder result = this.obligationCurrency != null ? this.obligationCurrency : (this.obligationCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="obligations")
        @RuneAttribute(value="obligations")
        public Obligations.ObligationsBuilder getObligations() {
            return this.obligations;
        }

        @Override
        public Obligations.ObligationsBuilder getOrCreateObligations() {
            Obligations.ObligationsBuilder result = this.obligations != null ? this.obligations : (this.obligations = Obligations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliverableObligations")
        @RuneAttribute(value="deliverableObligations")
        public DeliverableObligations.DeliverableObligationsBuilder getDeliverableObligations() {
            return this.deliverableObligations;
        }

        @Override
        public DeliverableObligations.DeliverableObligationsBuilder getOrCreateDeliverableObligations() {
            DeliverableObligations.DeliverableObligationsBuilder result = this.deliverableObligations != null ? this.deliverableObligations : (this.deliverableObligations = DeliverableObligations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditEntityModel", isRequired=true)
        @RuneAttribute(value="creditEntityModel", isRequired=true)
        public CreditCurveCharacteristicsModelBuilder setCreditEntityModel(CreditEntityModel _creditEntityModel) {
            this.creditEntityModel = _creditEntityModel == null ? null : _creditEntityModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditEvents")
        @RuneAttribute(value="creditEvents")
        public CreditCurveCharacteristicsModelBuilder setCreditEvents(CreditEvents _creditEvents) {
            this.creditEvents = _creditEvents == null ? null : _creditEvents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditCurveCharacteristicsModelBuilder setSeniority(CreditSeniority _seniority) {
            this.seniority = _seniority == null ? null : _seniority.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="secured")
        @RuneAttribute(value="secured")
        public CreditCurveCharacteristicsModelBuilder setSecured(Boolean _secured) {
            this.secured = _secured == null ? null : _secured;
            return this;
        }

        @Override
        @RosettaAttribute(value="obligationCurrency")
        @RuneAttribute(value="obligationCurrency")
        public CreditCurveCharacteristicsModelBuilder setObligationCurrency(Currency _obligationCurrency) {
            this.obligationCurrency = _obligationCurrency == null ? null : _obligationCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="obligations")
        @RuneAttribute(value="obligations")
        public CreditCurveCharacteristicsModelBuilder setObligations(Obligations _obligations) {
            this.obligations = _obligations == null ? null : _obligations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliverableObligations")
        @RuneAttribute(value="deliverableObligations")
        public CreditCurveCharacteristicsModelBuilder setDeliverableObligations(DeliverableObligations _deliverableObligations) {
            this.deliverableObligations = _deliverableObligations == null ? null : _deliverableObligations.toBuilder();
            return this;
        }

        @Override
        public CreditCurveCharacteristicsModel build() {
            return new CreditCurveCharacteristicsModelImpl(this);
        }

        @Override
        public CreditCurveCharacteristicsModelBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditCurveCharacteristicsModelBuilder prune() {
            if (this.creditEntityModel != null && !this.creditEntityModel.prune().hasData()) {
                this.creditEntityModel = null;
            }
            if (this.creditEvents != null && !this.creditEvents.prune().hasData()) {
                this.creditEvents = null;
            }
            if (this.seniority != null && !this.seniority.prune().hasData()) {
                this.seniority = null;
            }
            if (this.obligationCurrency != null && !this.obligationCurrency.prune().hasData()) {
                this.obligationCurrency = null;
            }
            if (this.obligations != null && !this.obligations.prune().hasData()) {
                this.obligations = null;
            }
            if (this.deliverableObligations != null && !this.deliverableObligations.prune().hasData()) {
                this.deliverableObligations = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCreditEntityModel() != null && this.getCreditEntityModel().hasData()) {
                return true;
            }
            if (this.getCreditEvents() != null && this.getCreditEvents().hasData()) {
                return true;
            }
            if (this.getSeniority() != null && this.getSeniority().hasData()) {
                return true;
            }
            if (this.getSecured() != null) {
                return true;
            }
            if (this.getObligationCurrency() != null && this.getObligationCurrency().hasData()) {
                return true;
            }
            if (this.getObligations() != null && this.getObligations().hasData()) {
                return true;
            }
            return this.getDeliverableObligations() != null && this.getDeliverableObligations().hasData();
        }

        public CreditCurveCharacteristicsModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditCurveCharacteristicsModelBuilder o = (CreditCurveCharacteristicsModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEntityModel(), (RosettaModelObjectBuilder)o.getCreditEntityModel(), this::setCreditEntityModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEvents(), (RosettaModelObjectBuilder)o.getCreditEvents(), this::setCreditEvents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeniority(), (RosettaModelObjectBuilder)o.getSeniority(), this::setSeniority);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObligationCurrency(), (RosettaModelObjectBuilder)o.getObligationCurrency(), this::setObligationCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObligations(), (RosettaModelObjectBuilder)o.getObligations(), this::setObligations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliverableObligations(), (RosettaModelObjectBuilder)o.getDeliverableObligations(), this::setDeliverableObligations);
            merger.mergeBasic((Object)this.getSecured(), (Object)o.getSecured(), this::setSecured, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditCurveCharacteristicsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.creditEntityModel, _that.getCreditEntityModel())) {
                return false;
            }
            if (!Objects.equals(this.creditEvents, _that.getCreditEvents())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!Objects.equals(this.secured, _that.getSecured())) {
                return false;
            }
            if (!Objects.equals(this.obligationCurrency, _that.getObligationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.obligations, _that.getObligations())) {
                return false;
            }
            return Objects.equals(this.deliverableObligations, _that.getDeliverableObligations());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditEntityModel != null ? this.creditEntityModel.hashCode() : 0);
            _result = 31 * _result + (this.creditEvents != null ? this.creditEvents.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.secured != null ? this.secured.hashCode() : 0);
            _result = 31 * _result + (this.obligationCurrency != null ? this.obligationCurrency.hashCode() : 0);
            _result = 31 * _result + (this.obligations != null ? this.obligations.hashCode() : 0);
            _result = 31 * _result + (this.deliverableObligations != null ? this.deliverableObligations.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditCurveCharacteristicsModelBuilder {creditEntityModel=" + this.creditEntityModel + ", creditEvents=" + this.creditEvents + ", seniority=" + this.seniority + ", secured=" + this.secured + ", obligationCurrency=" + this.obligationCurrency + ", obligations=" + this.obligations + ", deliverableObligations=" + this.deliverableObligations + '}';
        }
    }

    public static interface CreditCurveCharacteristicsModelBuilder
    extends CreditCurveCharacteristicsModel,
    RosettaModelObjectBuilder {
        public CreditEntityModel.CreditEntityModelBuilder getOrCreateCreditEntityModel();

        @Override
        public CreditEntityModel.CreditEntityModelBuilder getCreditEntityModel();

        public CreditEvents.CreditEventsBuilder getOrCreateCreditEvents();

        @Override
        public CreditEvents.CreditEventsBuilder getCreditEvents();

        public CreditSeniority.CreditSeniorityBuilder getOrCreateSeniority();

        @Override
        public CreditSeniority.CreditSeniorityBuilder getSeniority();

        public Currency.CurrencyBuilder getOrCreateObligationCurrency();

        @Override
        public Currency.CurrencyBuilder getObligationCurrency();

        public Obligations.ObligationsBuilder getOrCreateObligations();

        @Override
        public Obligations.ObligationsBuilder getObligations();

        public DeliverableObligations.DeliverableObligationsBuilder getOrCreateDeliverableObligations();

        @Override
        public DeliverableObligations.DeliverableObligationsBuilder getDeliverableObligations();

        public CreditCurveCharacteristicsModelBuilder setCreditEntityModel(CreditEntityModel var1);

        public CreditCurveCharacteristicsModelBuilder setCreditEvents(CreditEvents var1);

        public CreditCurveCharacteristicsModelBuilder setSeniority(CreditSeniority var1);

        public CreditCurveCharacteristicsModelBuilder setSecured(Boolean var1);

        public CreditCurveCharacteristicsModelBuilder setObligationCurrency(Currency var1);

        public CreditCurveCharacteristicsModelBuilder setObligations(Obligations var1);

        public CreditCurveCharacteristicsModelBuilder setDeliverableObligations(DeliverableObligations var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("creditEntityModel"), processor, CreditEntityModel.CreditEntityModelBuilder.class, this.getCreditEntityModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEvents"), processor, CreditEvents.CreditEventsBuilder.class, this.getCreditEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("seniority"), processor, CreditSeniority.CreditSeniorityBuilder.class, this.getSeniority(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secured"), Boolean.class, (Object)this.getSecured(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("obligationCurrency"), processor, Currency.CurrencyBuilder.class, this.getObligationCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("obligations"), processor, Obligations.ObligationsBuilder.class, this.getObligations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliverableObligations"), processor, DeliverableObligations.DeliverableObligationsBuilder.class, this.getDeliverableObligations(), new AttributeMeta[0]);
        }

        public CreditCurveCharacteristicsModelBuilder prune();
    }

    public static class CreditCurveCharacteristicsModelImpl
    implements CreditCurveCharacteristicsModel {
        private final CreditEntityModel creditEntityModel;
        private final CreditEvents creditEvents;
        private final CreditSeniority seniority;
        private final Boolean secured;
        private final Currency obligationCurrency;
        private final Obligations obligations;
        private final DeliverableObligations deliverableObligations;

        protected CreditCurveCharacteristicsModelImpl(CreditCurveCharacteristicsModelBuilder builder) {
            this.creditEntityModel = Optional.ofNullable(builder.getCreditEntityModel()).map(f -> f.build()).orElse(null);
            this.creditEvents = Optional.ofNullable(builder.getCreditEvents()).map(f -> f.build()).orElse(null);
            this.seniority = Optional.ofNullable(builder.getSeniority()).map(f -> f.build()).orElse(null);
            this.secured = builder.getSecured();
            this.obligationCurrency = Optional.ofNullable(builder.getObligationCurrency()).map(f -> f.build()).orElse(null);
            this.obligations = Optional.ofNullable(builder.getObligations()).map(f -> f.build()).orElse(null);
            this.deliverableObligations = Optional.ofNullable(builder.getDeliverableObligations()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="creditEntityModel", isRequired=true)
        @RuneAttribute(value="creditEntityModel", isRequired=true)
        public CreditEntityModel getCreditEntityModel() {
            return this.creditEntityModel;
        }

        @Override
        @RosettaAttribute(value="creditEvents")
        @RuneAttribute(value="creditEvents")
        public CreditEvents getCreditEvents() {
            return this.creditEvents;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CreditSeniority getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="secured")
        @RuneAttribute(value="secured")
        public Boolean getSecured() {
            return this.secured;
        }

        @Override
        @RosettaAttribute(value="obligationCurrency")
        @RuneAttribute(value="obligationCurrency")
        public Currency getObligationCurrency() {
            return this.obligationCurrency;
        }

        @Override
        @RosettaAttribute(value="obligations")
        @RuneAttribute(value="obligations")
        public Obligations getObligations() {
            return this.obligations;
        }

        @Override
        @RosettaAttribute(value="deliverableObligations")
        @RuneAttribute(value="deliverableObligations")
        public DeliverableObligations getDeliverableObligations() {
            return this.deliverableObligations;
        }

        @Override
        public CreditCurveCharacteristicsModel build() {
            return this;
        }

        @Override
        public CreditCurveCharacteristicsModelBuilder toBuilder() {
            CreditCurveCharacteristicsModelBuilder builder = CreditCurveCharacteristicsModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditCurveCharacteristicsModelBuilder builder) {
            Optional.ofNullable(this.getCreditEntityModel()).ifPresent(builder::setCreditEntityModel);
            Optional.ofNullable(this.getCreditEvents()).ifPresent(builder::setCreditEvents);
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
            Optional.ofNullable(this.getSecured()).ifPresent(builder::setSecured);
            Optional.ofNullable(this.getObligationCurrency()).ifPresent(builder::setObligationCurrency);
            Optional.ofNullable(this.getObligations()).ifPresent(builder::setObligations);
            Optional.ofNullable(this.getDeliverableObligations()).ifPresent(builder::setDeliverableObligations);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditCurveCharacteristicsModel _that = this.getType().cast(o);
            if (!Objects.equals(this.creditEntityModel, _that.getCreditEntityModel())) {
                return false;
            }
            if (!Objects.equals(this.creditEvents, _that.getCreditEvents())) {
                return false;
            }
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            if (!Objects.equals(this.secured, _that.getSecured())) {
                return false;
            }
            if (!Objects.equals(this.obligationCurrency, _that.getObligationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.obligations, _that.getObligations())) {
                return false;
            }
            return Objects.equals(this.deliverableObligations, _that.getDeliverableObligations());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditEntityModel != null ? this.creditEntityModel.hashCode() : 0);
            _result = 31 * _result + (this.creditEvents != null ? this.creditEvents.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.secured != null ? this.secured.hashCode() : 0);
            _result = 31 * _result + (this.obligationCurrency != null ? this.obligationCurrency.hashCode() : 0);
            _result = 31 * _result + (this.obligations != null ? this.obligations.hashCode() : 0);
            _result = 31 * _result + (this.deliverableObligations != null ? this.deliverableObligations.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditCurveCharacteristicsModel {creditEntityModel=" + this.creditEntityModel + ", creditEvents=" + this.creditEvents + ", seniority=" + this.seniority + ", secured=" + this.secured + ", obligationCurrency=" + this.obligationCurrency + ", obligations=" + this.obligations + ", deliverableObligations=" + this.deliverableObligations + '}';
        }
    }
}

