/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.LoanTransferFeePaidByEnum;
import fpml.consolidated.loan.meta.LoanTransferFeeSequenceMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTransferFeeSequence", builder=LoanTransferFeeSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanTransferFeeSequence", model="fpml", builder=LoanTransferFeeSequenceBuilderImpl.class, version="1.1.0")
public interface LoanTransferFeeSequence
extends RosettaModelObject {
    public static final LoanTransferFeeSequenceMeta metaData = new LoanTransferFeeSequenceMeta();

    public LoanTransferFeePaidByEnum getPaidBy();

    public NonNegativeMoney getTotalAmount();

    public LoanTransferFeeSequence build();

    public LoanTransferFeeSequenceBuilder toBuilder();

    public static LoanTransferFeeSequenceBuilder builder() {
        return new LoanTransferFeeSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTransferFeeSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTransferFeeSequence> getType() {
        return LoanTransferFeeSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("paidBy"), LoanTransferFeePaidByEnum.class, (Object)this.getPaidBy(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("totalAmount"), processor, NonNegativeMoney.class, this.getTotalAmount(), new AttributeMeta[0]);
    }

    public static class LoanTransferFeeSequenceBuilderImpl
    implements LoanTransferFeeSequenceBuilder {
        protected LoanTransferFeePaidByEnum paidBy;
        protected NonNegativeMoney.NonNegativeMoneyBuilder totalAmount;

        @Override
        @RosettaAttribute(value="paidBy", isRequired=true)
        @RuneAttribute(value="paidBy", isRequired=true)
        public LoanTransferFeePaidByEnum getPaidBy() {
            return this.paidBy;
        }

        @Override
        @RosettaAttribute(value="totalAmount")
        @RuneAttribute(value="totalAmount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getTotalAmount() {
            return this.totalAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateTotalAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.totalAmount != null ? this.totalAmount : (this.totalAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paidBy", isRequired=true)
        @RuneAttribute(value="paidBy", isRequired=true)
        public LoanTransferFeeSequenceBuilder setPaidBy(LoanTransferFeePaidByEnum _paidBy) {
            this.paidBy = _paidBy == null ? null : _paidBy;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalAmount")
        @RuneAttribute(value="totalAmount")
        public LoanTransferFeeSequenceBuilder setTotalAmount(NonNegativeMoney _totalAmount) {
            this.totalAmount = _totalAmount == null ? null : _totalAmount.toBuilder();
            return this;
        }

        @Override
        public LoanTransferFeeSequence build() {
            return new LoanTransferFeeSequenceImpl(this);
        }

        @Override
        public LoanTransferFeeSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTransferFeeSequenceBuilder prune() {
            if (this.totalAmount != null && !this.totalAmount.prune().hasData()) {
                this.totalAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPaidBy() != null) {
                return true;
            }
            return this.getTotalAmount() != null && this.getTotalAmount().hasData();
        }

        public LoanTransferFeeSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTransferFeeSequenceBuilder o = (LoanTransferFeeSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTotalAmount(), (RosettaModelObjectBuilder)o.getTotalAmount(), this::setTotalAmount);
            merger.mergeBasic((Object)this.getPaidBy(), (Object)o.getPaidBy(), this::setPaidBy, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTransferFeeSequence _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.paidBy, (Object)_that.getPaidBy())) {
                return false;
            }
            return Objects.equals(this.totalAmount, _that.getTotalAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paidBy != null ? ((Object)((Object)this.paidBy)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.totalAmount != null ? this.totalAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTransferFeeSequenceBuilder {paidBy=" + (Object)((Object)this.paidBy) + ", totalAmount=" + this.totalAmount + '}';
        }
    }

    public static interface LoanTransferFeeSequenceBuilder
    extends LoanTransferFeeSequence,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateTotalAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getTotalAmount();

        public LoanTransferFeeSequenceBuilder setPaidBy(LoanTransferFeePaidByEnum var1);

        public LoanTransferFeeSequenceBuilder setTotalAmount(NonNegativeMoney var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("paidBy"), LoanTransferFeePaidByEnum.class, (Object)this.getPaidBy(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("totalAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getTotalAmount(), new AttributeMeta[0]);
        }

        public LoanTransferFeeSequenceBuilder prune();
    }

    public static class LoanTransferFeeSequenceImpl
    implements LoanTransferFeeSequence {
        private final LoanTransferFeePaidByEnum paidBy;
        private final NonNegativeMoney totalAmount;

        protected LoanTransferFeeSequenceImpl(LoanTransferFeeSequenceBuilder builder) {
            this.paidBy = builder.getPaidBy();
            this.totalAmount = Optional.ofNullable(builder.getTotalAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paidBy", isRequired=true)
        @RuneAttribute(value="paidBy", isRequired=true)
        public LoanTransferFeePaidByEnum getPaidBy() {
            return this.paidBy;
        }

        @Override
        @RosettaAttribute(value="totalAmount")
        @RuneAttribute(value="totalAmount")
        public NonNegativeMoney getTotalAmount() {
            return this.totalAmount;
        }

        @Override
        public LoanTransferFeeSequence build() {
            return this;
        }

        @Override
        public LoanTransferFeeSequenceBuilder toBuilder() {
            LoanTransferFeeSequenceBuilder builder = LoanTransferFeeSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTransferFeeSequenceBuilder builder) {
            Optional.ofNullable(this.getPaidBy()).ifPresent(builder::setPaidBy);
            Optional.ofNullable(this.getTotalAmount()).ifPresent(builder::setTotalAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTransferFeeSequence _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.paidBy, (Object)_that.getPaidBy())) {
                return false;
            }
            return Objects.equals(this.totalAmount, _that.getTotalAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paidBy != null ? ((Object)((Object)this.paidBy)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.totalAmount != null ? this.totalAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTransferFeeSequence {paidBy=" + (Object)((Object)this.paidBy) + ", totalAmount=" + this.totalAmount + '}';
        }
    }
}

