/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.LoanSimplePayment;
import fpml.consolidated.loan.LoanTradeReference;
import fpml.consolidated.loan.SimplePayerReceiverModel;
import fpml.consolidated.loan.meta.LoanTradePaymentMeta;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.SettlementInstruction;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTradePayment", builder=LoanTradePaymentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanTradePayment", model="fpml", builder=LoanTradePaymentBuilderImpl.class, version="1.1.0")
public interface LoanTradePayment
extends LoanSimplePayment {
    public static final LoanTradePaymentMeta metaData = new LoanTradePaymentMeta();

    public LoanTradeReference getTradeReference();

    public SettlementInstruction getReceiverSettlementInstruction();

    @Override
    public LoanTradePayment build();

    @Override
    public LoanTradePaymentBuilder toBuilder();

    public static LoanTradePaymentBuilder builder() {
        return new LoanTradePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradePayment> getType() {
        return LoanTradePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, LoanTradeReference.class, this.getTradeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("receiverSettlementInstruction"), processor, SettlementInstruction.class, this.getReceiverSettlementInstruction(), new AttributeMeta[0]);
    }

    public static class LoanTradePaymentBuilderImpl
    extends LoanSimplePayment.LoanSimplePaymentBuilderImpl
    implements LoanTradePaymentBuilder {
        protected LoanTradeReference.LoanTradeReferenceBuilder tradeReference;
        protected SettlementInstruction.SettlementInstructionBuilder receiverSettlementInstruction;

        @Override
        @RosettaAttribute(value="tradeReference", isRequired=true)
        @RuneAttribute(value="tradeReference", isRequired=true)
        public LoanTradeReference.LoanTradeReferenceBuilder getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public LoanTradeReference.LoanTradeReferenceBuilder getOrCreateTradeReference() {
            LoanTradeReference.LoanTradeReferenceBuilder result = this.tradeReference != null ? this.tradeReference : (this.tradeReference = LoanTradeReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="receiverSettlementInstruction")
        @RuneAttribute(value="receiverSettlementInstruction")
        public SettlementInstruction.SettlementInstructionBuilder getReceiverSettlementInstruction() {
            return this.receiverSettlementInstruction;
        }

        @Override
        public SettlementInstruction.SettlementInstructionBuilder getOrCreateReceiverSettlementInstruction() {
            SettlementInstruction.SettlementInstructionBuilder result = this.receiverSettlementInstruction != null ? this.receiverSettlementInstruction : (this.receiverSettlementInstruction = SettlementInstruction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanTradePaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel", isRequired=true)
        @RuneAttribute(value="simplePayerReceiverModel", isRequired=true)
        public LoanTradePaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel _simplePayerReceiverModel) {
            this.simplePayerReceiverModel = _simplePayerReceiverModel == null ? null : _simplePayerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public LoanTradePaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public LoanTradePaymentBuilder setPaymentDate(AdjustableDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference", isRequired=true)
        @RuneAttribute(value="tradeReference", isRequired=true)
        public LoanTradePaymentBuilder setTradeReference(LoanTradeReference _tradeReference) {
            this.tradeReference = _tradeReference == null ? null : _tradeReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverSettlementInstruction")
        @RuneAttribute(value="receiverSettlementInstruction")
        public LoanTradePaymentBuilder setReceiverSettlementInstruction(SettlementInstruction _receiverSettlementInstruction) {
            this.receiverSettlementInstruction = _receiverSettlementInstruction == null ? null : _receiverSettlementInstruction.toBuilder();
            return this;
        }

        @Override
        public LoanTradePayment build() {
            return new LoanTradePaymentImpl(this);
        }

        @Override
        public LoanTradePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradePaymentBuilder prune() {
            super.prune();
            if (this.tradeReference != null && !this.tradeReference.prune().hasData()) {
                this.tradeReference = null;
            }
            if (this.receiverSettlementInstruction != null && !this.receiverSettlementInstruction.prune().hasData()) {
                this.receiverSettlementInstruction = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeReference() != null && this.getTradeReference().hasData()) {
                return true;
            }
            return this.getReceiverSettlementInstruction() != null && this.getReceiverSettlementInstruction().hasData();
        }

        @Override
        public LoanTradePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanTradePaymentBuilder o = (LoanTradePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeReference(), (RosettaModelObjectBuilder)o.getTradeReference(), this::setTradeReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReceiverSettlementInstruction(), (RosettaModelObjectBuilder)o.getReceiverSettlementInstruction(), this::setReceiverSettlementInstruction);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradePayment _that = (LoanTradePayment)this.getType().cast(o);
            if (!Objects.equals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            return Objects.equals(this.receiverSettlementInstruction, _that.getReceiverSettlementInstruction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.receiverSettlementInstruction != null ? this.receiverSettlementInstruction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradePaymentBuilder {tradeReference=" + this.tradeReference + ", receiverSettlementInstruction=" + this.receiverSettlementInstruction + '}' + " " + super.toString();
        }
    }

    public static interface LoanTradePaymentBuilder
    extends LoanTradePayment,
    LoanSimplePayment.LoanSimplePaymentBuilder {
        public LoanTradeReference.LoanTradeReferenceBuilder getOrCreateTradeReference();

        @Override
        public LoanTradeReference.LoanTradeReferenceBuilder getTradeReference();

        public SettlementInstruction.SettlementInstructionBuilder getOrCreateReceiverSettlementInstruction();

        @Override
        public SettlementInstruction.SettlementInstructionBuilder getReceiverSettlementInstruction();

        @Override
        public LoanTradePaymentBuilder setId(String var1);

        @Override
        public LoanTradePaymentBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel var1);

        @Override
        public LoanTradePaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        @Override
        public LoanTradePaymentBuilder setPaymentDate(AdjustableDate var1);

        public LoanTradePaymentBuilder setTradeReference(LoanTradeReference var1);

        public LoanTradePaymentBuilder setReceiverSettlementInstruction(SettlementInstruction var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.SimplePayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, LoanTradeReference.LoanTradeReferenceBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("receiverSettlementInstruction"), processor, SettlementInstruction.SettlementInstructionBuilder.class, this.getReceiverSettlementInstruction(), new AttributeMeta[0]);
        }

        @Override
        public LoanTradePaymentBuilder prune();
    }

    public static class LoanTradePaymentImpl
    extends LoanSimplePayment.LoanSimplePaymentImpl
    implements LoanTradePayment {
        private final LoanTradeReference tradeReference;
        private final SettlementInstruction receiverSettlementInstruction;

        protected LoanTradePaymentImpl(LoanTradePaymentBuilder builder) {
            super(builder);
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).map(f -> f.build()).orElse(null);
            this.receiverSettlementInstruction = Optional.ofNullable(builder.getReceiverSettlementInstruction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeReference", isRequired=true)
        @RuneAttribute(value="tradeReference", isRequired=true)
        public LoanTradeReference getTradeReference() {
            return this.tradeReference;
        }

        @Override
        @RosettaAttribute(value="receiverSettlementInstruction")
        @RuneAttribute(value="receiverSettlementInstruction")
        public SettlementInstruction getReceiverSettlementInstruction() {
            return this.receiverSettlementInstruction;
        }

        @Override
        public LoanTradePayment build() {
            return this;
        }

        @Override
        public LoanTradePaymentBuilder toBuilder() {
            LoanTradePaymentBuilder builder = LoanTradePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
            Optional.ofNullable(this.getReceiverSettlementInstruction()).ifPresent(builder::setReceiverSettlementInstruction);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradePayment _that = (LoanTradePayment)this.getType().cast(o);
            if (!Objects.equals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            return Objects.equals(this.receiverSettlementInstruction, _that.getReceiverSettlementInstruction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.receiverSettlementInstruction != null ? this.receiverSettlementInstruction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradePayment {tradeReference=" + this.tradeReference + ", receiverSettlementInstruction=" + this.receiverSettlementInstruction + '}' + " " + super.toString();
        }
    }
}

