/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LoanLegalStructureAfterChoice;
import fpml.consolidated.loan.meta.LoanLegalStructureAfterMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanLegalStructureAfter", builder=LoanLegalStructureAfterBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanLegalStructureAfter", model="fpml", builder=LoanLegalStructureAfterBuilderImpl.class, version="1.1.0")
public interface LoanLegalStructureAfter
extends RosettaModelObject {
    public static final LoanLegalStructureAfterMeta metaData = new LoanLegalStructureAfterMeta();

    public DealReference getDealReference();

    public List<? extends FacilityReference> getFacilityReference();

    public List<? extends LoanLegalStructureAfterChoice> getLoanLegalStructureAfterChoice();

    public LoanLegalStructureAfter build();

    public LoanLegalStructureAfterBuilder toBuilder();

    public static LoanLegalStructureAfterBuilder builder() {
        return new LoanLegalStructureAfterBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanLegalStructureAfter> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanLegalStructureAfter> getType() {
        return LoanLegalStructureAfter.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanLegalStructureAfterChoice"), processor, LoanLegalStructureAfterChoice.class, this.getLoanLegalStructureAfterChoice(), new AttributeMeta[0]);
    }

    public static class LoanLegalStructureAfterBuilderImpl
    implements LoanLegalStructureAfterBuilder {
        protected DealReference.DealReferenceBuilder dealReference;
        protected List<FacilityReference.FacilityReferenceBuilder> facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();
        protected List<LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder> loanLegalStructureAfterChoice = new ArrayList<LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder>();

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference.DealReferenceBuilder getDealReference() {
            return this.dealReference;
        }

        @Override
        public DealReference.DealReferenceBuilder getOrCreateDealReference() {
            DealReference.DealReferenceBuilder result = this.dealReference != null ? this.dealReference : (this.dealReference = DealReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int index) {
            if (this.facilityReference == null) {
                this.facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();
            }
            return (FacilityReference.FacilityReferenceBuilder)this.getIndex(this.facilityReference, index, () -> {
                FacilityReference.FacilityReferenceBuilder newFacilityReference = FacilityReference.builder();
                return newFacilityReference;
            });
        }

        @Override
        @RosettaAttribute(value="loanLegalStructureAfterChoice")
        @RuneAttribute(value="loanLegalStructureAfterChoice")
        public List<? extends LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder> getLoanLegalStructureAfterChoice() {
            return this.loanLegalStructureAfterChoice;
        }

        @Override
        public LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder getOrCreateLoanLegalStructureAfterChoice(int index) {
            if (this.loanLegalStructureAfterChoice == null) {
                this.loanLegalStructureAfterChoice = new ArrayList<LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder>();
            }
            return (LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder)this.getIndex(this.loanLegalStructureAfterChoice, index, () -> {
                LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder newLoanLegalStructureAfterChoice = LoanLegalStructureAfterChoice.builder();
                return newLoanLegalStructureAfterChoice;
            });
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public LoanLegalStructureAfterBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public LoanLegalStructureAfterBuilder addFacilityReference(FacilityReference _facilityReference) {
            if (_facilityReference != null) {
                this.facilityReference.add(_facilityReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalStructureAfterBuilder addFacilityReference(FacilityReference _facilityReference, int idx) {
            this.getIndex(this.facilityReference, idx, () -> _facilityReference.toBuilder());
            return this;
        }

        @Override
        public LoanLegalStructureAfterBuilder addFacilityReference(List<? extends FacilityReference> facilityReferences) {
            if (facilityReferences != null) {
                for (FacilityReference facilityReference : facilityReferences) {
                    this.facilityReference.add(facilityReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityReference")
        public LoanLegalStructureAfterBuilder setFacilityReference(List<? extends FacilityReference> facilityReferences) {
            this.facilityReference = facilityReferences == null ? new ArrayList<FacilityReference.FacilityReferenceBuilder>() : (List)facilityReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanLegalStructureAfterChoice")
        @RuneAttribute(value="loanLegalStructureAfterChoice")
        public LoanLegalStructureAfterBuilder addLoanLegalStructureAfterChoice(LoanLegalStructureAfterChoice _loanLegalStructureAfterChoice) {
            if (_loanLegalStructureAfterChoice != null) {
                this.loanLegalStructureAfterChoice.add(_loanLegalStructureAfterChoice.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalStructureAfterBuilder addLoanLegalStructureAfterChoice(LoanLegalStructureAfterChoice _loanLegalStructureAfterChoice, int idx) {
            this.getIndex(this.loanLegalStructureAfterChoice, idx, () -> _loanLegalStructureAfterChoice.toBuilder());
            return this;
        }

        @Override
        public LoanLegalStructureAfterBuilder addLoanLegalStructureAfterChoice(List<? extends LoanLegalStructureAfterChoice> loanLegalStructureAfterChoices) {
            if (loanLegalStructureAfterChoices != null) {
                for (LoanLegalStructureAfterChoice loanLegalStructureAfterChoice : loanLegalStructureAfterChoices) {
                    this.loanLegalStructureAfterChoice.add(loanLegalStructureAfterChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanLegalStructureAfterChoice")
        public LoanLegalStructureAfterBuilder setLoanLegalStructureAfterChoice(List<? extends LoanLegalStructureAfterChoice> loanLegalStructureAfterChoices) {
            this.loanLegalStructureAfterChoice = loanLegalStructureAfterChoices == null ? new ArrayList<LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder>() : (List)loanLegalStructureAfterChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanLegalStructureAfter build() {
            return new LoanLegalStructureAfterImpl(this);
        }

        @Override
        public LoanLegalStructureAfterBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanLegalStructureAfterBuilder prune() {
            if (this.dealReference != null && !this.dealReference.prune().hasData()) {
                this.dealReference = null;
            }
            this.facilityReference = this.facilityReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.loanLegalStructureAfterChoice = this.loanLegalStructureAfterChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDealReference() != null && this.getDealReference().hasData()) {
                return true;
            }
            if (this.getFacilityReference() != null && this.getFacilityReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getLoanLegalStructureAfterChoice() != null && this.getLoanLegalStructureAfterChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LoanLegalStructureAfterBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanLegalStructureAfterBuilder o = (LoanLegalStructureAfterBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealReference(), (RosettaModelObjectBuilder)o.getDealReference(), this::setDealReference);
            merger.mergeRosetta(this.getFacilityReference(), o.getFacilityReference(), this::getOrCreateFacilityReference);
            merger.mergeRosetta(this.getLoanLegalStructureAfterChoice(), o.getLoanLegalStructureAfterChoice(), this::getOrCreateLoanLegalStructureAfterChoice);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanLegalStructureAfter _that = this.getType().cast(o);
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            return ListEquals.listEquals(this.loanLegalStructureAfterChoice, _that.getLoanLegalStructureAfterChoice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalStructureAfterChoice != null ? this.loanLegalStructureAfterChoice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanLegalStructureAfterBuilder {dealReference=" + this.dealReference + ", facilityReference=" + this.facilityReference + ", loanLegalStructureAfterChoice=" + this.loanLegalStructureAfterChoice + '}';
        }
    }

    public static interface LoanLegalStructureAfterBuilder
    extends LoanLegalStructureAfter,
    RosettaModelObjectBuilder {
        public DealReference.DealReferenceBuilder getOrCreateDealReference();

        @Override
        public DealReference.DealReferenceBuilder getDealReference();

        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int var1);

        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference();

        public LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder getOrCreateLoanLegalStructureAfterChoice(int var1);

        public List<? extends LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder> getLoanLegalStructureAfterChoice();

        public LoanLegalStructureAfterBuilder setDealReference(DealReference var1);

        public LoanLegalStructureAfterBuilder addFacilityReference(FacilityReference var1);

        public LoanLegalStructureAfterBuilder addFacilityReference(FacilityReference var1, int var2);

        public LoanLegalStructureAfterBuilder addFacilityReference(List<? extends FacilityReference> var1);

        public LoanLegalStructureAfterBuilder setFacilityReference(List<? extends FacilityReference> var1);

        public LoanLegalStructureAfterBuilder addLoanLegalStructureAfterChoice(LoanLegalStructureAfterChoice var1);

        public LoanLegalStructureAfterBuilder addLoanLegalStructureAfterChoice(LoanLegalStructureAfterChoice var1, int var2);

        public LoanLegalStructureAfterBuilder addLoanLegalStructureAfterChoice(List<? extends LoanLegalStructureAfterChoice> var1);

        public LoanLegalStructureAfterBuilder setLoanLegalStructureAfterChoice(List<? extends LoanLegalStructureAfterChoice> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanLegalStructureAfterChoice"), processor, LoanLegalStructureAfterChoice.LoanLegalStructureAfterChoiceBuilder.class, this.getLoanLegalStructureAfterChoice(), new AttributeMeta[0]);
        }

        public LoanLegalStructureAfterBuilder prune();
    }

    public static class LoanLegalStructureAfterImpl
    implements LoanLegalStructureAfter {
        private final DealReference dealReference;
        private final List<? extends FacilityReference> facilityReference;
        private final List<? extends LoanLegalStructureAfterChoice> loanLegalStructureAfterChoice;

        protected LoanLegalStructureAfterImpl(LoanLegalStructureAfterBuilder builder) {
            this.dealReference = Optional.ofNullable(builder.getDealReference()).map(f -> f.build()).orElse(null);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.loanLegalStructureAfterChoice = Optional.ofNullable(builder.getLoanLegalStructureAfterChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference getDealReference() {
            return this.dealReference;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        @RosettaAttribute(value="loanLegalStructureAfterChoice")
        @RuneAttribute(value="loanLegalStructureAfterChoice")
        public List<? extends LoanLegalStructureAfterChoice> getLoanLegalStructureAfterChoice() {
            return this.loanLegalStructureAfterChoice;
        }

        @Override
        public LoanLegalStructureAfter build() {
            return this;
        }

        @Override
        public LoanLegalStructureAfterBuilder toBuilder() {
            LoanLegalStructureAfterBuilder builder = LoanLegalStructureAfter.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanLegalStructureAfterBuilder builder) {
            Optional.ofNullable(this.getDealReference()).ifPresent(builder::setDealReference);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
            Optional.ofNullable(this.getLoanLegalStructureAfterChoice()).ifPresent(builder::setLoanLegalStructureAfterChoice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanLegalStructureAfter _that = this.getType().cast(o);
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            return ListEquals.listEquals(this.loanLegalStructureAfterChoice, _that.getLoanLegalStructureAfterChoice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalStructureAfterChoice != null ? this.loanLegalStructureAfterChoice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanLegalStructureAfter {dealReference=" + this.dealReference + ", facilityReference=" + this.facilityReference + ", loanLegalStructureAfterChoice=" + this.loanLegalStructureAfterChoice + '}';
        }
    }
}

