/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanContractEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.LoanContractMaturityChangeMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanContractMaturityChange", builder=LoanContractMaturityChangeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanContractMaturityChange", model="fpml", builder=LoanContractMaturityChangeBuilderImpl.class, version="1.1.0")
public interface LoanContractMaturityChange
extends AbstractLoanContractEvent {
    public static final LoanContractMaturityChangeMeta metaData = new LoanContractMaturityChangeMeta();

    public ZonedDateTime getCurrentMaturityDate();

    public ZonedDateTime getPriorMaturityDate();

    @Override
    public LoanContractMaturityChange build();

    @Override
    public LoanContractMaturityChangeBuilder toBuilder();

    public static LoanContractMaturityChangeBuilder builder() {
        return new LoanContractMaturityChangeBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanContractMaturityChange> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanContractMaturityChange> getType() {
        return LoanContractMaturityChange.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currentMaturityDate"), ZonedDateTime.class, (Object)this.getCurrentMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorMaturityDate"), ZonedDateTime.class, (Object)this.getPriorMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LoanContractMaturityChangeBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements LoanContractMaturityChangeBuilder {
        protected ZonedDateTime currentMaturityDate;
        protected ZonedDateTime priorMaturityDate;

        @Override
        @RosettaAttribute(value="currentMaturityDate", isRequired=true)
        @RuneAttribute(value="currentMaturityDate", isRequired=true)
        public ZonedDateTime getCurrentMaturityDate() {
            return this.currentMaturityDate;
        }

        @Override
        @RosettaAttribute(value="priorMaturityDate")
        @RuneAttribute(value="priorMaturityDate")
        public ZonedDateTime getPriorMaturityDate() {
            return this.priorMaturityDate;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LoanContractMaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractMaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanContractMaturityChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LoanContractMaturityChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LoanContractMaturityChangeBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LoanContractMaturityChangeBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanContractMaturityChangeBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LoanContractMaturityChangeBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LoanContractMaturityChangeBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LoanContractMaturityChangeBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanContractMaturityChangeBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currentMaturityDate", isRequired=true)
        @RuneAttribute(value="currentMaturityDate", isRequired=true)
        public LoanContractMaturityChangeBuilder setCurrentMaturityDate(ZonedDateTime _currentMaturityDate) {
            this.currentMaturityDate = _currentMaturityDate == null ? null : _currentMaturityDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorMaturityDate")
        @RuneAttribute(value="priorMaturityDate")
        public LoanContractMaturityChangeBuilder setPriorMaturityDate(ZonedDateTime _priorMaturityDate) {
            this.priorMaturityDate = _priorMaturityDate == null ? null : _priorMaturityDate;
            return this;
        }

        @Override
        public LoanContractMaturityChange build() {
            return new LoanContractMaturityChangeImpl(this);
        }

        @Override
        public LoanContractMaturityChangeBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanContractMaturityChangeBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCurrentMaturityDate() != null) {
                return true;
            }
            return this.getPriorMaturityDate() != null;
        }

        @Override
        public LoanContractMaturityChangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanContractMaturityChangeBuilder o = (LoanContractMaturityChangeBuilder)other;
            merger.mergeBasic((Object)this.getCurrentMaturityDate(), (Object)o.getCurrentMaturityDate(), this::setCurrentMaturityDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorMaturityDate(), (Object)o.getPriorMaturityDate(), this::setPriorMaturityDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractMaturityChange _that = (LoanContractMaturityChange)this.getType().cast(o);
            if (!Objects.equals(this.currentMaturityDate, _that.getCurrentMaturityDate())) {
                return false;
            }
            return Objects.equals(this.priorMaturityDate, _that.getPriorMaturityDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currentMaturityDate != null ? this.currentMaturityDate.hashCode() : 0);
            _result = 31 * _result + (this.priorMaturityDate != null ? this.priorMaturityDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractMaturityChangeBuilder {currentMaturityDate=" + this.currentMaturityDate + ", priorMaturityDate=" + this.priorMaturityDate + '}' + " " + super.toString();
        }
    }

    public static interface LoanContractMaturityChangeBuilder
    extends LoanContractMaturityChange,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        @Override
        public LoanContractMaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LoanContractMaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LoanContractMaturityChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanContractMaturityChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanContractMaturityChangeBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LoanContractMaturityChangeBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LoanContractMaturityChangeBuilder setComment(String var1);

        @Override
        public LoanContractMaturityChangeBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LoanContractMaturityChangeBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LoanContractMaturityChangeBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LoanContractMaturityChangeBuilder setLoanContractReference(LoanContractReference var1);

        public LoanContractMaturityChangeBuilder setCurrentMaturityDate(ZonedDateTime var1);

        public LoanContractMaturityChangeBuilder setPriorMaturityDate(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currentMaturityDate"), ZonedDateTime.class, (Object)this.getCurrentMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorMaturityDate"), ZonedDateTime.class, (Object)this.getPriorMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LoanContractMaturityChangeBuilder prune();
    }

    public static class LoanContractMaturityChangeImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements LoanContractMaturityChange {
        private final ZonedDateTime currentMaturityDate;
        private final ZonedDateTime priorMaturityDate;

        protected LoanContractMaturityChangeImpl(LoanContractMaturityChangeBuilder builder) {
            super(builder);
            this.currentMaturityDate = builder.getCurrentMaturityDate();
            this.priorMaturityDate = builder.getPriorMaturityDate();
        }

        @Override
        @RosettaAttribute(value="currentMaturityDate", isRequired=true)
        @RuneAttribute(value="currentMaturityDate", isRequired=true)
        public ZonedDateTime getCurrentMaturityDate() {
            return this.currentMaturityDate;
        }

        @Override
        @RosettaAttribute(value="priorMaturityDate")
        @RuneAttribute(value="priorMaturityDate")
        public ZonedDateTime getPriorMaturityDate() {
            return this.priorMaturityDate;
        }

        @Override
        public LoanContractMaturityChange build() {
            return this;
        }

        @Override
        public LoanContractMaturityChangeBuilder toBuilder() {
            LoanContractMaturityChangeBuilder builder = LoanContractMaturityChange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanContractMaturityChangeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrentMaturityDate()).ifPresent(builder::setCurrentMaturityDate);
            Optional.ofNullable(this.getPriorMaturityDate()).ifPresent(builder::setPriorMaturityDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractMaturityChange _that = (LoanContractMaturityChange)this.getType().cast(o);
            if (!Objects.equals(this.currentMaturityDate, _that.getCurrentMaturityDate())) {
                return false;
            }
            return Objects.equals(this.priorMaturityDate, _that.getPriorMaturityDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currentMaturityDate != null ? this.currentMaturityDate.hashCode() : 0);
            _result = 31 * _result + (this.priorMaturityDate != null ? this.priorMaturityDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractMaturityChange {currentMaturityDate=" + this.currentMaturityDate + ", priorMaturityDate=" + this.priorMaturityDate + '}' + " " + super.toString();
        }
    }
}

