/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.LegacyAccrualPeriod;
import fpml.consolidated.loan.PaymentProjection;
import fpml.consolidated.loan.meta.LegacyInterestCapitalizationSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegacyInterestCapitalizationSequence", builder=LegacyInterestCapitalizationSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LegacyInterestCapitalizationSequence", model="fpml", builder=LegacyInterestCapitalizationSequenceBuilderImpl.class, version="1.1.0")
public interface LegacyInterestCapitalizationSequence
extends RosettaModelObject {
    public static final LegacyInterestCapitalizationSequenceMeta metaData = new LegacyInterestCapitalizationSequenceMeta();

    public List<? extends LegacyAccrualPeriod> getAccrualSchedule();

    public PaymentProjection getProjection();

    public LegacyInterestCapitalizationSequence build();

    public LegacyInterestCapitalizationSequenceBuilder toBuilder();

    public static LegacyInterestCapitalizationSequenceBuilder builder() {
        return new LegacyInterestCapitalizationSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends LegacyInterestCapitalizationSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegacyInterestCapitalizationSequence> getType() {
        return LegacyInterestCapitalizationSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualSchedule"), processor, LegacyAccrualPeriod.class, this.getAccrualSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("projection"), processor, PaymentProjection.class, this.getProjection(), new AttributeMeta[0]);
    }

    public static class LegacyInterestCapitalizationSequenceBuilderImpl
    implements LegacyInterestCapitalizationSequenceBuilder {
        protected List<LegacyAccrualPeriod.LegacyAccrualPeriodBuilder> accrualSchedule = new ArrayList<LegacyAccrualPeriod.LegacyAccrualPeriodBuilder>();
        protected PaymentProjection.PaymentProjectionBuilder projection;

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends LegacyAccrualPeriod.LegacyAccrualPeriodBuilder> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        public LegacyAccrualPeriod.LegacyAccrualPeriodBuilder getOrCreateAccrualSchedule(int index) {
            if (this.accrualSchedule == null) {
                this.accrualSchedule = new ArrayList<LegacyAccrualPeriod.LegacyAccrualPeriodBuilder>();
            }
            return (LegacyAccrualPeriod.LegacyAccrualPeriodBuilder)this.getIndex(this.accrualSchedule, index, () -> {
                LegacyAccrualPeriod.LegacyAccrualPeriodBuilder newAccrualSchedule = LegacyAccrualPeriod.builder();
                return newAccrualSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="projection")
        @RuneAttribute(value="projection")
        public PaymentProjection.PaymentProjectionBuilder getProjection() {
            return this.projection;
        }

        @Override
        public PaymentProjection.PaymentProjectionBuilder getOrCreateProjection() {
            PaymentProjection.PaymentProjectionBuilder result = this.projection != null ? this.projection : (this.projection = PaymentProjection.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public LegacyInterestCapitalizationSequenceBuilder addAccrualSchedule(LegacyAccrualPeriod _accrualSchedule) {
            if (_accrualSchedule != null) {
                this.accrualSchedule.add(_accrualSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public LegacyInterestCapitalizationSequenceBuilder addAccrualSchedule(LegacyAccrualPeriod _accrualSchedule, int idx) {
            this.getIndex(this.accrualSchedule, idx, () -> _accrualSchedule.toBuilder());
            return this;
        }

        @Override
        public LegacyInterestCapitalizationSequenceBuilder addAccrualSchedule(List<? extends LegacyAccrualPeriod> accrualSchedules) {
            if (accrualSchedules != null) {
                for (LegacyAccrualPeriod legacyAccrualPeriod : accrualSchedules) {
                    this.accrualSchedule.add(legacyAccrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualSchedule")
        public LegacyInterestCapitalizationSequenceBuilder setAccrualSchedule(List<? extends LegacyAccrualPeriod> accrualSchedules) {
            this.accrualSchedule = accrualSchedules == null ? new ArrayList<LegacyAccrualPeriod.LegacyAccrualPeriodBuilder>() : (List)accrualSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="projection")
        @RuneAttribute(value="projection")
        public LegacyInterestCapitalizationSequenceBuilder setProjection(PaymentProjection _projection) {
            this.projection = _projection == null ? null : _projection.toBuilder();
            return this;
        }

        @Override
        public LegacyInterestCapitalizationSequence build() {
            return new LegacyInterestCapitalizationSequenceImpl(this);
        }

        @Override
        public LegacyInterestCapitalizationSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public LegacyInterestCapitalizationSequenceBuilder prune() {
            this.accrualSchedule = this.accrualSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.projection != null && !this.projection.prune().hasData()) {
                this.projection = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAccrualSchedule() != null && this.getAccrualSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getProjection() != null && this.getProjection().hasData();
        }

        public LegacyInterestCapitalizationSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegacyInterestCapitalizationSequenceBuilder o = (LegacyInterestCapitalizationSequenceBuilder)other;
            merger.mergeRosetta(this.getAccrualSchedule(), o.getAccrualSchedule(), this::getOrCreateAccrualSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProjection(), (RosettaModelObjectBuilder)o.getProjection(), this::setProjection);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegacyInterestCapitalizationSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule())) {
                return false;
            }
            return Objects.equals(this.projection, _that.getProjection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            _result = 31 * _result + (this.projection != null ? this.projection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegacyInterestCapitalizationSequenceBuilder {accrualSchedule=" + this.accrualSchedule + ", projection=" + this.projection + '}';
        }
    }

    public static interface LegacyInterestCapitalizationSequenceBuilder
    extends LegacyInterestCapitalizationSequence,
    RosettaModelObjectBuilder {
        public LegacyAccrualPeriod.LegacyAccrualPeriodBuilder getOrCreateAccrualSchedule(int var1);

        public List<? extends LegacyAccrualPeriod.LegacyAccrualPeriodBuilder> getAccrualSchedule();

        public PaymentProjection.PaymentProjectionBuilder getOrCreateProjection();

        @Override
        public PaymentProjection.PaymentProjectionBuilder getProjection();

        public LegacyInterestCapitalizationSequenceBuilder addAccrualSchedule(LegacyAccrualPeriod var1);

        public LegacyInterestCapitalizationSequenceBuilder addAccrualSchedule(LegacyAccrualPeriod var1, int var2);

        public LegacyInterestCapitalizationSequenceBuilder addAccrualSchedule(List<? extends LegacyAccrualPeriod> var1);

        public LegacyInterestCapitalizationSequenceBuilder setAccrualSchedule(List<? extends LegacyAccrualPeriod> var1);

        public LegacyInterestCapitalizationSequenceBuilder setProjection(PaymentProjection var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualSchedule"), processor, LegacyAccrualPeriod.LegacyAccrualPeriodBuilder.class, this.getAccrualSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("projection"), processor, PaymentProjection.PaymentProjectionBuilder.class, this.getProjection(), new AttributeMeta[0]);
        }

        public LegacyInterestCapitalizationSequenceBuilder prune();
    }

    public static class LegacyInterestCapitalizationSequenceImpl
    implements LegacyInterestCapitalizationSequence {
        private final List<? extends LegacyAccrualPeriod> accrualSchedule;
        private final PaymentProjection projection;

        protected LegacyInterestCapitalizationSequenceImpl(LegacyInterestCapitalizationSequenceBuilder builder) {
            this.accrualSchedule = Optional.ofNullable(builder.getAccrualSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.projection = Optional.ofNullable(builder.getProjection()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="accrualSchedule")
        @RuneAttribute(value="accrualSchedule")
        public List<? extends LegacyAccrualPeriod> getAccrualSchedule() {
            return this.accrualSchedule;
        }

        @Override
        @RosettaAttribute(value="projection")
        @RuneAttribute(value="projection")
        public PaymentProjection getProjection() {
            return this.projection;
        }

        @Override
        public LegacyInterestCapitalizationSequence build() {
            return this;
        }

        @Override
        public LegacyInterestCapitalizationSequenceBuilder toBuilder() {
            LegacyInterestCapitalizationSequenceBuilder builder = LegacyInterestCapitalizationSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegacyInterestCapitalizationSequenceBuilder builder) {
            Optional.ofNullable(this.getAccrualSchedule()).ifPresent(builder::setAccrualSchedule);
            Optional.ofNullable(this.getProjection()).ifPresent(builder::setProjection);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegacyInterestCapitalizationSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.accrualSchedule, _that.getAccrualSchedule())) {
                return false;
            }
            return Objects.equals(this.projection, _that.getProjection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.accrualSchedule != null ? this.accrualSchedule.hashCode() : 0);
            _result = 31 * _result + (this.projection != null ? this.projection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegacyInterestCapitalizationSequence {accrualSchedule=" + this.accrualSchedule + ", projection=" + this.projection + '}';
        }
    }
}

