/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AbstractLegacyFloatingRateOptionBase;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.LegacyFloatingRateAccrualSequence;
import fpml.consolidated.loan.LegacyFloatingRateIndexLoanModel;
import fpml.consolidated.loan.PaymentProjection;
import fpml.consolidated.loan.PeriodWithDaysModel;
import fpml.consolidated.loan.meta.LegacyFloatingRateAccrualMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LegacyFloatingRateAccrual", builder=LegacyFloatingRateAccrualBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LegacyFloatingRateAccrual", model="fpml", builder=LegacyFloatingRateAccrualBuilderImpl.class, version="1.1.0")
public interface LegacyFloatingRateAccrual
extends AbstractLegacyFloatingRateOptionBase {
    public static final LegacyFloatingRateAccrualMeta metaData = new LegacyFloatingRateAccrualMeta();

    public PeriodWithDaysModel getPeriodWithDaysModel();

    public LegacyFloatingRateAccrualSequence getLegacyFloatingRateAccrualSequence();

    public PaymentProjection getPaymentProjection();

    @Override
    public LegacyFloatingRateAccrual build();

    @Override
    public LegacyFloatingRateAccrualBuilder toBuilder();

    public static LegacyFloatingRateAccrualBuilder builder() {
        return new LegacyFloatingRateAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends LegacyFloatingRateAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegacyFloatingRateAccrual> getType() {
        return LegacyFloatingRateAccrual.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyFloatingRateIndexLoanModel"), processor, LegacyFloatingRateIndexLoanModel.class, this.getLegacyFloatingRateIndexLoanModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("pikSpread"), BigDecimal.class, (Object)this.getPikSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyFloatingRateAccrualSequence"), processor, LegacyFloatingRateAccrualSequence.class, this.getLegacyFloatingRateAccrualSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentProjection"), processor, PaymentProjection.class, this.getPaymentProjection(), new AttributeMeta[0]);
    }

    public static class LegacyFloatingRateAccrualBuilderImpl
    extends AbstractLegacyFloatingRateOptionBase.AbstractLegacyFloatingRateOptionBaseBuilderImpl
    implements LegacyFloatingRateAccrualBuilder {
        protected PeriodWithDaysModel.PeriodWithDaysModelBuilder periodWithDaysModel;
        protected LegacyFloatingRateAccrualSequence.LegacyFloatingRateAccrualSequenceBuilder legacyFloatingRateAccrualSequence;
        protected PaymentProjection.PaymentProjectionBuilder paymentProjection;

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel() {
            PeriodWithDaysModel.PeriodWithDaysModelBuilder result = this.periodWithDaysModel != null ? this.periodWithDaysModel : (this.periodWithDaysModel = PeriodWithDaysModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateAccrualSequence")
        @RuneAttribute(value="legacyFloatingRateAccrualSequence")
        public LegacyFloatingRateAccrualSequence.LegacyFloatingRateAccrualSequenceBuilder getLegacyFloatingRateAccrualSequence() {
            return this.legacyFloatingRateAccrualSequence;
        }

        @Override
        public LegacyFloatingRateAccrualSequence.LegacyFloatingRateAccrualSequenceBuilder getOrCreateLegacyFloatingRateAccrualSequence() {
            LegacyFloatingRateAccrualSequence.LegacyFloatingRateAccrualSequenceBuilder result = this.legacyFloatingRateAccrualSequence != null ? this.legacyFloatingRateAccrualSequence : (this.legacyFloatingRateAccrualSequence = LegacyFloatingRateAccrualSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentProjection")
        @RuneAttribute(value="paymentProjection")
        public PaymentProjection.PaymentProjectionBuilder getPaymentProjection() {
            return this.paymentProjection;
        }

        @Override
        public PaymentProjection.PaymentProjectionBuilder getOrCreatePaymentProjection() {
            PaymentProjection.PaymentProjectionBuilder result = this.paymentProjection != null ? this.paymentProjection : (this.paymentProjection = PaymentProjection.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public LegacyFloatingRateAccrualBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public LegacyFloatingRateAccrualBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public LegacyFloatingRateAccrualBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateIndexLoanModel", isRequired=true)
        @RuneAttribute(value="legacyFloatingRateIndexLoanModel", isRequired=true)
        public LegacyFloatingRateAccrualBuilder setLegacyFloatingRateIndexLoanModel(LegacyFloatingRateIndexLoanModel _legacyFloatingRateIndexLoanModel) {
            this.legacyFloatingRateIndexLoanModel = _legacyFloatingRateIndexLoanModel == null ? null : _legacyFloatingRateIndexLoanModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public LegacyFloatingRateAccrualBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="pikSpread")
        @RuneAttribute(value="pikSpread")
        public LegacyFloatingRateAccrualBuilder setPikSpread(BigDecimal _pikSpread) {
            this.pikSpread = _pikSpread == null ? null : _pikSpread;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public LegacyFloatingRateAccrualBuilder setPeriodWithDaysModel(PeriodWithDaysModel _periodWithDaysModel) {
            this.periodWithDaysModel = _periodWithDaysModel == null ? null : _periodWithDaysModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateAccrualSequence")
        @RuneAttribute(value="legacyFloatingRateAccrualSequence")
        public LegacyFloatingRateAccrualBuilder setLegacyFloatingRateAccrualSequence(LegacyFloatingRateAccrualSequence _legacyFloatingRateAccrualSequence) {
            this.legacyFloatingRateAccrualSequence = _legacyFloatingRateAccrualSequence == null ? null : _legacyFloatingRateAccrualSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentProjection")
        @RuneAttribute(value="paymentProjection")
        public LegacyFloatingRateAccrualBuilder setPaymentProjection(PaymentProjection _paymentProjection) {
            this.paymentProjection = _paymentProjection == null ? null : _paymentProjection.toBuilder();
            return this;
        }

        @Override
        public LegacyFloatingRateAccrual build() {
            return new LegacyFloatingRateAccrualImpl(this);
        }

        @Override
        public LegacyFloatingRateAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public LegacyFloatingRateAccrualBuilder prune() {
            super.prune();
            if (this.periodWithDaysModel != null && !this.periodWithDaysModel.prune().hasData()) {
                this.periodWithDaysModel = null;
            }
            if (this.legacyFloatingRateAccrualSequence != null && !this.legacyFloatingRateAccrualSequence.prune().hasData()) {
                this.legacyFloatingRateAccrualSequence = null;
            }
            if (this.paymentProjection != null && !this.paymentProjection.prune().hasData()) {
                this.paymentProjection = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodWithDaysModel() != null && this.getPeriodWithDaysModel().hasData()) {
                return true;
            }
            if (this.getLegacyFloatingRateAccrualSequence() != null && this.getLegacyFloatingRateAccrualSequence().hasData()) {
                return true;
            }
            return this.getPaymentProjection() != null && this.getPaymentProjection().hasData();
        }

        @Override
        public LegacyFloatingRateAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LegacyFloatingRateAccrualBuilder o = (LegacyFloatingRateAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodWithDaysModel(), (RosettaModelObjectBuilder)o.getPeriodWithDaysModel(), this::setPeriodWithDaysModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyFloatingRateAccrualSequence(), (RosettaModelObjectBuilder)o.getLegacyFloatingRateAccrualSequence(), this::setLegacyFloatingRateAccrualSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentProjection(), (RosettaModelObjectBuilder)o.getPaymentProjection(), this::setPaymentProjection);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegacyFloatingRateAccrual _that = (LegacyFloatingRateAccrual)this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            if (!Objects.equals(this.legacyFloatingRateAccrualSequence, _that.getLegacyFloatingRateAccrualSequence())) {
                return false;
            }
            return Objects.equals(this.paymentProjection, _that.getPaymentProjection());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.legacyFloatingRateAccrualSequence != null ? this.legacyFloatingRateAccrualSequence.hashCode() : 0);
            _result = 31 * _result + (this.paymentProjection != null ? this.paymentProjection.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegacyFloatingRateAccrualBuilder {periodWithDaysModel=" + this.periodWithDaysModel + ", legacyFloatingRateAccrualSequence=" + this.legacyFloatingRateAccrualSequence + ", paymentProjection=" + this.paymentProjection + '}' + " " + super.toString();
        }
    }

    public static interface LegacyFloatingRateAccrualBuilder
    extends LegacyFloatingRateAccrual,
    AbstractLegacyFloatingRateOptionBase.AbstractLegacyFloatingRateOptionBaseBuilder {
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel();

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel();

        public LegacyFloatingRateAccrualSequence.LegacyFloatingRateAccrualSequenceBuilder getOrCreateLegacyFloatingRateAccrualSequence();

        @Override
        public LegacyFloatingRateAccrualSequence.LegacyFloatingRateAccrualSequenceBuilder getLegacyFloatingRateAccrualSequence();

        public PaymentProjection.PaymentProjectionBuilder getOrCreatePaymentProjection();

        @Override
        public PaymentProjection.PaymentProjectionBuilder getPaymentProjection();

        @Override
        public LegacyFloatingRateAccrualBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public LegacyFloatingRateAccrualBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public LegacyFloatingRateAccrualBuilder setPaymentFrequency(Period var1);

        @Override
        public LegacyFloatingRateAccrualBuilder setLegacyFloatingRateIndexLoanModel(LegacyFloatingRateIndexLoanModel var1);

        @Override
        public LegacyFloatingRateAccrualBuilder setSpread(BigDecimal var1);

        @Override
        public LegacyFloatingRateAccrualBuilder setPikSpread(BigDecimal var1);

        public LegacyFloatingRateAccrualBuilder setPeriodWithDaysModel(PeriodWithDaysModel var1);

        public LegacyFloatingRateAccrualBuilder setLegacyFloatingRateAccrualSequence(LegacyFloatingRateAccrualSequence var1);

        public LegacyFloatingRateAccrualBuilder setPaymentProjection(PaymentProjection var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyFloatingRateIndexLoanModel"), processor, LegacyFloatingRateIndexLoanModel.LegacyFloatingRateIndexLoanModelBuilder.class, (RosettaModelObjectBuilder)this.getLegacyFloatingRateIndexLoanModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("pikSpread"), BigDecimal.class, (Object)this.getPikSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.PeriodWithDaysModelBuilder.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyFloatingRateAccrualSequence"), processor, LegacyFloatingRateAccrualSequence.LegacyFloatingRateAccrualSequenceBuilder.class, this.getLegacyFloatingRateAccrualSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentProjection"), processor, PaymentProjection.PaymentProjectionBuilder.class, this.getPaymentProjection(), new AttributeMeta[0]);
        }

        @Override
        public LegacyFloatingRateAccrualBuilder prune();
    }

    public static class LegacyFloatingRateAccrualImpl
    extends AbstractLegacyFloatingRateOptionBase.AbstractLegacyFloatingRateOptionBaseImpl
    implements LegacyFloatingRateAccrual {
        private final PeriodWithDaysModel periodWithDaysModel;
        private final LegacyFloatingRateAccrualSequence legacyFloatingRateAccrualSequence;
        private final PaymentProjection paymentProjection;

        protected LegacyFloatingRateAccrualImpl(LegacyFloatingRateAccrualBuilder builder) {
            super(builder);
            this.periodWithDaysModel = Optional.ofNullable(builder.getPeriodWithDaysModel()).map(f -> f.build()).orElse(null);
            this.legacyFloatingRateAccrualSequence = Optional.ofNullable(builder.getLegacyFloatingRateAccrualSequence()).map(f -> f.build()).orElse(null);
            this.paymentProjection = Optional.ofNullable(builder.getPaymentProjection()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateAccrualSequence")
        @RuneAttribute(value="legacyFloatingRateAccrualSequence")
        public LegacyFloatingRateAccrualSequence getLegacyFloatingRateAccrualSequence() {
            return this.legacyFloatingRateAccrualSequence;
        }

        @Override
        @RosettaAttribute(value="paymentProjection")
        @RuneAttribute(value="paymentProjection")
        public PaymentProjection getPaymentProjection() {
            return this.paymentProjection;
        }

        @Override
        public LegacyFloatingRateAccrual build() {
            return this;
        }

        @Override
        public LegacyFloatingRateAccrualBuilder toBuilder() {
            LegacyFloatingRateAccrualBuilder builder = LegacyFloatingRateAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegacyFloatingRateAccrualBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodWithDaysModel()).ifPresent(builder::setPeriodWithDaysModel);
            Optional.ofNullable(this.getLegacyFloatingRateAccrualSequence()).ifPresent(builder::setLegacyFloatingRateAccrualSequence);
            Optional.ofNullable(this.getPaymentProjection()).ifPresent(builder::setPaymentProjection);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegacyFloatingRateAccrual _that = (LegacyFloatingRateAccrual)this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            if (!Objects.equals(this.legacyFloatingRateAccrualSequence, _that.getLegacyFloatingRateAccrualSequence())) {
                return false;
            }
            return Objects.equals(this.paymentProjection, _that.getPaymentProjection());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.legacyFloatingRateAccrualSequence != null ? this.legacyFloatingRateAccrualSequence.hashCode() : 0);
            _result = 31 * _result + (this.paymentProjection != null ? this.paymentProjection.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegacyFloatingRateAccrual {periodWithDaysModel=" + this.periodWithDaysModel + ", legacyFloatingRateAccrualSequence=" + this.legacyFloatingRateAccrualSequence + ", paymentProjection=" + this.paymentProjection + '}' + " " + super.toString();
        }
    }
}

