/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.FxTerms;
import fpml.consolidated.loan.meta.LcAccrualSequenceMeta;
import fpml.consolidated.shared.Currency;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LcAccrualSequence", builder=LcAccrualSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LcAccrualSequence", model="fpml", builder=LcAccrualSequenceBuilderImpl.class, version="1.1.0")
public interface LcAccrualSequence
extends RosettaModelObject {
    public static final LcAccrualSequenceMeta metaData = new LcAccrualSequenceMeta();

    public Currency getCurrency();

    public FxTerms getLcFxRate();

    public LcAccrualSequence build();

    public LcAccrualSequenceBuilder toBuilder();

    public static LcAccrualSequenceBuilder builder() {
        return new LcAccrualSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends LcAccrualSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcAccrualSequence> getType() {
        return LcAccrualSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lcFxRate"), processor, FxTerms.class, this.getLcFxRate(), new AttributeMeta[0]);
    }

    public static class LcAccrualSequenceBuilderImpl
    implements LcAccrualSequenceBuilder {
        protected Currency.CurrencyBuilder currency;
        protected FxTerms.FxTermsBuilder lcFxRate;

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lcFxRate", isRequired=true)
        @RuneAttribute(value="lcFxRate", isRequired=true)
        public FxTerms.FxTermsBuilder getLcFxRate() {
            return this.lcFxRate;
        }

        @Override
        public FxTerms.FxTermsBuilder getOrCreateLcFxRate() {
            FxTerms.FxTermsBuilder result = this.lcFxRate != null ? this.lcFxRate : (this.lcFxRate = FxTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public LcAccrualSequenceBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lcFxRate", isRequired=true)
        @RuneAttribute(value="lcFxRate", isRequired=true)
        public LcAccrualSequenceBuilder setLcFxRate(FxTerms _lcFxRate) {
            this.lcFxRate = _lcFxRate == null ? null : _lcFxRate.toBuilder();
            return this;
        }

        @Override
        public LcAccrualSequence build() {
            return new LcAccrualSequenceImpl(this);
        }

        @Override
        public LcAccrualSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public LcAccrualSequenceBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.lcFxRate != null && !this.lcFxRate.prune().hasData()) {
                this.lcFxRate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            return this.getLcFxRate() != null && this.getLcFxRate().hasData();
        }

        public LcAccrualSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LcAccrualSequenceBuilder o = (LcAccrualSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLcFxRate(), (RosettaModelObjectBuilder)o.getLcFxRate(), this::setLcFxRate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LcAccrualSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            return Objects.equals(this.lcFxRate, _that.getLcFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.lcFxRate != null ? this.lcFxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LcAccrualSequenceBuilder {currency=" + this.currency + ", lcFxRate=" + this.lcFxRate + '}';
        }
    }

    public static interface LcAccrualSequenceBuilder
    extends LcAccrualSequence,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public FxTerms.FxTermsBuilder getOrCreateLcFxRate();

        @Override
        public FxTerms.FxTermsBuilder getLcFxRate();

        public LcAccrualSequenceBuilder setCurrency(Currency var1);

        public LcAccrualSequenceBuilder setLcFxRate(FxTerms var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lcFxRate"), processor, FxTerms.FxTermsBuilder.class, this.getLcFxRate(), new AttributeMeta[0]);
        }

        public LcAccrualSequenceBuilder prune();
    }

    public static class LcAccrualSequenceImpl
    implements LcAccrualSequence {
        private final Currency currency;
        private final FxTerms lcFxRate;

        protected LcAccrualSequenceImpl(LcAccrualSequenceBuilder builder) {
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.lcFxRate = Optional.ofNullable(builder.getLcFxRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="lcFxRate", isRequired=true)
        @RuneAttribute(value="lcFxRate", isRequired=true)
        public FxTerms getLcFxRate() {
            return this.lcFxRate;
        }

        @Override
        public LcAccrualSequence build() {
            return this;
        }

        @Override
        public LcAccrualSequenceBuilder toBuilder() {
            LcAccrualSequenceBuilder builder = LcAccrualSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcAccrualSequenceBuilder builder) {
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getLcFxRate()).ifPresent(builder::setLcFxRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LcAccrualSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            return Objects.equals(this.lcFxRate, _that.getLcFxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.lcFxRate != null ? this.lcFxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LcAccrualSequence {currency=" + this.currency + ", lcFxRate=" + this.lcFxRate + '}';
        }
    }
}

