/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractFacilityEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.FacilityPrepaymentMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityPrepayment", builder=FacilityPrepaymentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FacilityPrepayment", model="fpml", builder=FacilityPrepaymentBuilderImpl.class, version="1.1.0")
public interface FacilityPrepayment
extends AbstractFacilityEvent {
    public static final FacilityPrepaymentMeta metaData = new FacilityPrepaymentMeta();

    public MoneyWithParticipantShare getAmount();

    @Override
    public FacilityPrepayment build();

    @Override
    public FacilityPrepaymentBuilder toBuilder();

    public static FacilityPrepaymentBuilder builder() {
        return new FacilityPrepaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityPrepayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityPrepayment> getType() {
        return FacilityPrepayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
    }

    public static class FacilityPrepaymentBuilderImpl
    extends AbstractFacilityEvent.AbstractFacilityEventBuilderImpl
    implements FacilityPrepaymentBuilder {
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public FacilityPrepaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityPrepaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public FacilityPrepaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public FacilityPrepaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public FacilityPrepaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public FacilityPrepaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public FacilityPrepaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public FacilityPrepaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public FacilityPrepaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public FacilityPrepaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityPrepaymentBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public FacilityPrepaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        public FacilityPrepayment build() {
            return new FacilityPrepaymentImpl(this);
        }

        @Override
        public FacilityPrepaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityPrepaymentBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getAmount() != null && this.getAmount().hasData();
        }

        @Override
        public FacilityPrepaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FacilityPrepaymentBuilder o = (FacilityPrepaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityPrepayment _that = (FacilityPrepayment)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityPrepaymentBuilder {amount=" + this.amount + '}' + " " + super.toString();
        }
    }

    public static interface FacilityPrepaymentBuilder
    extends FacilityPrepayment,
    AbstractFacilityEvent.AbstractFacilityEventBuilder {
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        @Override
        public FacilityPrepaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public FacilityPrepaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public FacilityPrepaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public FacilityPrepaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public FacilityPrepaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public FacilityPrepaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public FacilityPrepaymentBuilder setComment(String var1);

        @Override
        public FacilityPrepaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public FacilityPrepaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public FacilityPrepaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public FacilityPrepaymentBuilder setFacilityReference(FacilityReference var1);

        public FacilityPrepaymentBuilder setAmount(MoneyWithParticipantShare var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
        }

        @Override
        public FacilityPrepaymentBuilder prune();
    }

    public static class FacilityPrepaymentImpl
    extends AbstractFacilityEvent.AbstractFacilityEventImpl
    implements FacilityPrepayment {
        private final MoneyWithParticipantShare amount;

        protected FacilityPrepaymentImpl(FacilityPrepaymentBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        public FacilityPrepayment build() {
            return this;
        }

        @Override
        public FacilityPrepaymentBuilder toBuilder() {
            FacilityPrepaymentBuilder builder = FacilityPrepayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityPrepaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityPrepayment _that = (FacilityPrepayment)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityPrepayment {amount=" + this.amount + '}' + " " + super.toString();
        }
    }
}

